/**
* Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
*
* This software is the confidential and proprietary information of Sonic
* Software Corpoation. (Confidential Information).  You shall not
* disclose such Confidential Information and shall use it only in
* accordance with the terms of the license agreement you entered into
* with Sonic.
*
* SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
* THIS SOFTWARE OR ITS DERIVATIVES.
*
* CopyrightVersion 1.0
*/

   package com.sonicsw.mf.mgmtapi.config;

   import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.gen.IAbstractContainerBean;

/**
 * Configuration Bean representing a 'Container'
 */
public interface IContainerBean extends IAbstractContainerBean
{
     /**
     * Generate the data for a Container bootfile
     * @return the boot file data
     * @throws MgmtException Thrown if there is a problem generating the bootfile.
     * @deprecated 8.0 release onwards should use generateSetupFile instead.
     */
    public String generateBootFile() throws MgmtException;

    /**
    * Generates setup file which is used to generate the startup scripts for the Container.
     *
    * @param targetFolder  The path where the setup file would be generated and saved.
    * @param windowsServiceName  The name for windows service. This value is applicable only for Windows OS.
    * @throws MgmtException Thrown if there is a problem generating the setupfile.
    */
    public void generateSetupFile(String targetFolder,String windowServiceName) throws MgmtException;
    
    public IContainerBean createBackupContainer(String viewName) throws MgmtException;

    public boolean isFaultTolerant();

    /**
     * Inner class representing MonitoringType
     * This class extends IAbstractMonitoringType
     */
    public interface IMonitoringType extends IAbstractMonitoringType
    {
    }

    /**
     * Inner class representing CacheType
     * This class extends IAbstractCacheType
     */
    public interface ICacheType extends IAbstractCacheType
    {
    }

    /**
     * Inner class representing ComponentsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractComponentsType
     */
    public interface IComponentsType extends IAbstractComponentsType
    {
    }

    /**
     * Inner class representing MetricsCollectionType
     * This class extends IAbstractMetricsCollectionType
     */
    public interface IMetricsCollectionType extends IAbstractMetricsCollectionType
    {
    }

    /**
     * Inner class representing SystemPropertiesType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractSystemPropertiesType
     */
    public interface ISystemPropertiesType extends IAbstractSystemPropertiesType
    {
    }

    /**
     * Inner class representing EnabledMetricsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractEnabledMetricsType
     */
    public interface IEnabledMetricsType extends IAbstractEnabledMetricsType
    {
    }

    /**
     * Inner class representing EnabledAlertsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractEnabledAlertsType
     */
    public interface IEnabledAlertsType extends IAbstractEnabledAlertsType
    {
    }

    /**
     * Inner class representing CentralConnectionType
     * This class extends IAbstractCentralConnectionType
     */
    public interface ICentralConnectionType extends IAbstractCentralConnectionType
    {
    }

    /**
     * Inner class representing ExtensionsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractExtensionsType
     */
    public interface IExtensionsType extends IAbstractExtensionsType
    {
    }

    /**
     * Inner class representing FaultToleranceType
     * This class extends IAbstractFaultToleranceType
     */
    public interface IFaultToleranceType extends IAbstractFaultToleranceType
    {
    }

    /**
     * Inner class representing ConnectionType
     * This class extends IAbstractConnectionType
     */
    public interface IConnectionType extends IAbstractConnectionType
    {
    }

    /**
     * Inner class representing StartupParams
     * This class extends IAbstractStartupParams
     */
    public interface IStartupParams extends IAbstractStartupParams
    {
    }

    /**
     * Inner class representing EnabledAlertParams
     * This class extends IAbstractEnabledAlertParams
     */
    public interface IEnabledAlertParams extends IAbstractEnabledAlertParams
    {
    }

    /**
     * Inner class representing ExtensionType
     * This class extends IAbstractExtensionType
     */
    public interface IExtensionType extends IAbstractExtensionType
    {
    }

    /**
     * Inner class representing LibrariesType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractLibrariesType
     */
    public interface ILibrariesType extends IAbstractLibrariesType
    {
    }

    /**
     * Inner class representing DeploymentParametersSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractDeploymentParametersSet
     */
    public interface IDeploymentParametersSet extends IAbstractDeploymentParametersSet
    {
    }

    /**
     * Inner class representing LibraryParams
     * This class extends IAbstractLibraryParams
     */
    public interface ILibraryParams extends IAbstractLibraryParams
    {
    }

    /**
     * Inner class representing DeploymentParameterType
     * This class extends IAbstractDeploymentParameterType
     */
    public interface IDeploymentParameterType extends IAbstractDeploymentParameterType
    {
    }
}
