/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config;

import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.gen.IAbstractDirectoryServiceBean;

/**
 * Configuration Bean representing a 'DirectoryService'
 */
public interface IDirectoryServiceBean extends IAbstractDirectoryServiceBean
{

    /**
     * Inner class representing ReplicationParametersType
     * This class extends IAbstractReplicationParametersType
     */
    public interface IReplicationParametersType extends IAbstractReplicationParametersType
    {
    }

    /**
     * Inner class representing DsReferencesType
     * This class extends IAbstractDsReferencesType
     */
    public interface IDsReferencesType extends IAbstractDsReferencesType
    {
    }

    /**
     * Inner class representing StorageType
     * This class extends IAbstractStorageType
     */
    public interface IStorageType extends IAbstractStorageType
    {
    }

    /**
     * Inner class representing SslParametersType
     * This class extends IAbstractSslParametersType
     */
    public interface ISslParametersType extends IAbstractSslParametersType
    {
    }
    /**
     * Generate the data for a Directory bootfile
     * @return the boot file data
     * @throws MgmtException Thrown if there is a problem generating the bootfile.
     */
    public String generateBootFile() throws MgmtException;
}
