// Copyright (c) 2003-2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.util.ValidName;
import com.sonicsw.mx.config.ConfigServerUtility;

import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;
import com.sonicsw.mf.mgmtapi.config.gen.AbstractMFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationDomainBean;

public class MFMgmtBeanFactory extends AbstractMFMgmtBeanFactory
{
    public MFMgmtBeanFactory()
    {
        super();
    }

    public IDomainBean getDomainBean() throws MgmtException
    {
        return getDomainBean("/" + ConfigServerUtility.DEFAULT_SUFFIX);
    }
    
    /**
     * Get the names of all beans of type IDomain
     * @return an array of bean names
     */
    @Override
    public List getDomainBeanNames() throws MgmtException
    {
        List list = new ArrayList();
        list.add("/" + ConfigServerUtility.DEFAULT_SUFFIX);
        return list;
    }

    @Override
    public List getAuthenticationDomainBeanNames() throws MgmtException
    {
        return listFolderElements(AuthenticationDomainBean.DS_TYPE);
    }

    @Override
    public IComponentCollectionBean createComponentCollectionBean(String name)
        throws MgmtException
    {
        String tail = name.substring(name.lastIndexOf('/') + 1);
        try
        {
            ValidName.validate(tail, ValidName.COLLECTION_TYPE);
        }
        catch (Exception e)
        {
            throw new MgmtException("Invalid collection name " + tail + " ", e);
        }
        return super.createComponentCollectionBean(name);
    }

    @Override
    public IContainerCollectionBean createContainerCollectionBean(String name)
        throws MgmtException
    {
        String tail = name.substring(name.lastIndexOf('/') + 1);
        try
        {
            ValidName.validate(tail, ValidName.COLLECTION_TYPE);
        }
        catch (Exception e)
        {
            throw new MgmtException("Invalid collection name " + tail + " ", e);
        }
        return super.createContainerCollectionBean(name);
    }

    public HashMap getDeployedComponents(String containerName)
        throws MgmtException
    {
        IContainerBean container = super.getContainerBean(containerName);
        IContainerBean.IComponentsType types = container.getComponents();
        List names = types.getKeyNames();

        HashMap componentInfo = new HashMap(names.size());

        for (Iterator iter = names.iterator(); iter.hasNext();)
        {
            String name = (String) iter.next();
            String id = getDomain() + "." + container.getContainerName() + IComponentIdentity.DELIMITED_ID_PREFIX + name;
            IContainerBean.IStartupParams params = types.getEntry(name);
            IMgmtBeanBase bean = params.getConfigRef();
            componentInfo.put(id, bean);

        }

        return componentInfo;
    }

    public String[] getComponentsRuntimeIDs() throws MgmtException
    {
        ArrayList ids = new ArrayList(0);
        List names = super.getContainerBeanNames();

        for (Iterator iter = names.iterator(); iter.hasNext();)
        {
            HashMap components = getDeployedComponents((String) iter.next());
            Iterator i = components.keySet().iterator();
            while (i.hasNext())
            {
                ids.add((String) i.next());
            }

        }
        return (String[]) ids.toArray(new String[0]);
    }

    public String[] getContainersRuntimeIDs() throws MgmtException
    {
        ArrayList ids = new ArrayList(0);
        List names = super.getContainerBeanNames();

        for (Iterator iter = names.iterator(); iter.hasNext();)
        {
            IContainerBean container = super.getContainerBean((String) iter.next());
            String id = getDomain() + "." + container.getContainerName();

            ids.add(id);
        }
        return (String[]) ids.toArray(new String[0]);
    }

    @Override
    public void saveContainerBean(IContainerBean bean) throws MgmtException
    {
        if (!bean.isFaultTolerant())
        {
            saveBean(bean);
            return;
        }

        if (bean.getFaultToleranceParameters().getFaultToleranceRole().equals(IContainerConstants.FAULT_TOLERANCE_ROLE_PRIMARY))
        {
            saveBeans(new IMgmtBeanBase[] { bean, bean.getFaultToleranceParameters().getFaultTolerancePeerRef() });
        }

        if (bean.getFaultToleranceParameters().getFaultToleranceRole().equals(IContainerConstants.FAULT_TOLERANCE_ROLE_BACKUP))
        {
            saveBean(bean);
        }
    }
}
