// Copyright (c) 2011 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.config.gen;

import java.util.HashMap;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IActivationDaemonBean;
import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IBackupAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IBackupDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.ICollectionsMonitorBean;
import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IContainerCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.IDomainBean;
import com.sonicsw.mf.mgmtapi.config.IGenericComponentBean;
import com.sonicsw.mf.mgmtapi.config.IHostManagerBean;
import com.sonicsw.mf.mgmtapi.config.ILoggerBean;
import com.sonicsw.mf.mgmtapi.config.IReplicationConnectionBean;
import com.sonicsw.mf.mgmtapi.config.impl.ActivationDaemonBean;
import com.sonicsw.mf.mgmtapi.config.impl.AgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.impl.BackupAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.impl.BackupDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.impl.CollectionsMonitorBean;
import com.sonicsw.mf.mgmtapi.config.impl.ComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.impl.ContainerBean;
import com.sonicsw.mf.mgmtapi.config.impl.ContainerCollectionBean;
import com.sonicsw.mf.mgmtapi.config.impl.DirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.impl.DomainBean;
import com.sonicsw.mf.mgmtapi.config.impl.GenericComponentBean;
import com.sonicsw.mf.mgmtapi.config.impl.HostManagerBean;
import com.sonicsw.mf.mgmtapi.config.impl.LoggerBean;
import com.sonicsw.mf.mgmtapi.config.impl.ReplicationConnectionBean;

public class AbstractMFMgmtBeanFactory extends MgmtBeanFactory
{
    public AbstractMFMgmtBeanFactory()
    {
        super();

        registerDomainBean();
        registerContainerBean();
        registerActivationDaemonBean();
        registerAgentManagerBean();
        registerBackupAgentManagerBean();
        registerDirectoryServiceBean();
        registerBackupDirectoryServiceBean();
        registerReplicationConnectionBean();
        registerComponentCollectionBean();
        registerContainerCollectionBean();
        registerCollectionsMonitorBean();
        registerAuthenticationDomainBean();
        registerAuthenticationUserBean();
        registerAuthenticationGroupBean();
        registerGenericComponentBean();
        registerHostManagerBean();
        registerLoggerBean();
    }

    // -----------------------------------------------------------------------
    // Domain methods for DomainBean
    //
    private void registerDomainBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      DomainBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, DomainBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, DomainBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     DomainBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IDomain
     * @return an array of bean names
     */
    public List getDomainBeanNames() throws MgmtException
    {
        return listConfigElements(DomainBean.DS_TYPE);
    }

    /**
     * Get the 'Domain' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IDomain
     */
    public IDomainBean getDomainBean(String name) throws MgmtException
    {
        DomainBean bean = new DomainBean(this);

        bean.loadBean(name, DomainBean.DS_TYPE);

        return bean;
    }

    /**
     * Save the specified Domain bean
     * @param bean the Domain bean to save
     */
    public void saveDomainBean(IDomainBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for ContainerBean
    //
    private void registerContainerBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      ContainerBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, ContainerBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, ContainerBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     ContainerBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.TRUE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IContainer
     * @return an array of bean names
     */
    public List getContainerBeanNames() throws MgmtException
    {
        return listConfigElements(ContainerBean.DS_TYPE);
    }

    /**
     * Get the 'Container' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IContainer
     */
    public IContainerBean getContainerBean(String name) throws MgmtException
    {
        ContainerBean bean = new ContainerBean(this);

        bean.loadBean(name, ContainerBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a Container bean with the specified name
     * @param name the name of the new bean
     * @return a new Container bean
     */
    public IContainerBean createContainerBean(String name) throws MgmtException
    {
        ContainerBean bean = new ContainerBean(this);

        bean.createBean(name, ContainerBean.DS_TYPE, ContainerBean.DS_C_VERSION, ContainerBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified Container bean
     * @param bean the Container bean to save
     */
    public void saveContainerBean(IContainerBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified Container bean
     * @param bean the Container bean to delete
     */
    public void deleteContainerBean(IContainerBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for ActivationDaemonBean
    //
    private void registerActivationDaemonBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      ActivationDaemonBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, ActivationDaemonBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, ActivationDaemonBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     ActivationDaemonBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.TRUE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IActivationDaemon
     * @return an array of bean names
     */
    public List getActivationDaemonBeanNames() throws MgmtException
    {
        return listConfigElements(ActivationDaemonBean.DS_TYPE);
    }

    /**
     * Get the 'ActivationDaemon' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IActivationDaemon
     */
    public IActivationDaemonBean getActivationDaemonBean(String name) throws MgmtException
    {
        ActivationDaemonBean bean = new ActivationDaemonBean(this);

        bean.loadBean(name, ActivationDaemonBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a ActivationDaemon bean with the specified name
     * @param name the name of the new bean
     * @return a new ActivationDaemon bean
     */
    public IActivationDaemonBean createActivationDaemonBean(String name) throws MgmtException
    {
        ActivationDaemonBean bean = new ActivationDaemonBean(this);

        bean.createBean(name, ActivationDaemonBean.DS_TYPE, ActivationDaemonBean.DS_C_VERSION, ActivationDaemonBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified ActivationDaemon bean
     * @param bean the ActivationDaemon bean to save
     */
    public void saveActivationDaemonBean(IActivationDaemonBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified ActivationDaemon bean
     * @param bean the ActivationDaemon bean to delete
     */
    public void deleteActivationDaemonBean(IActivationDaemonBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for AgentManagerBean
    //
    private void registerAgentManagerBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      AgentManagerBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, AgentManagerBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, AgentManagerBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     AgentManagerBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IAgentManager
     * @return an array of bean names
     */
    public List getAgentManagerBeanNames() throws MgmtException
    {
        return listConfigElements(AgentManagerBean.DS_TYPE);
    }

    /**
     * Get the 'AgentManager' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IAgentManager
     */
    public IAgentManagerBean getAgentManagerBean(String name) throws MgmtException
    {
        AgentManagerBean bean = new AgentManagerBean(this);

        bean.loadBean(name, AgentManagerBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a AgentManager bean with the specified name
     * @param name the name of the new bean
     * @return a new AgentManager bean
     */
    public IAgentManagerBean createAgentManagerBean(String name) throws MgmtException
    {
        AgentManagerBean bean = new AgentManagerBean(this);

        bean.createBean(name, AgentManagerBean.DS_TYPE, AgentManagerBean.DS_C_VERSION, AgentManagerBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified AgentManager bean
     * @param bean the AgentManager bean to save
     */
    public void saveAgentManagerBean(IAgentManagerBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified AgentManager bean
     * @param bean the AgentManager bean to delete
     */
    public void deleteAgentManagerBean(IAgentManagerBean bean) throws MgmtException
    {
        IAgentManagerBean.IAMReferences amReferences = bean.getConfigElementReferences();
        if(amReferences!=null){
            IMgmtBeanBase backupAM = null;
            try{
                backupAM = amReferences.getBackupAmConfigElementRef();
            }catch(Exception e){}
            if(backupAM instanceof IBackupAgentManagerBean)
            {
                deleteBackupAgentManagerBean((IBackupAgentManagerBean) backupAM);
            }
        }
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for BackupAgentManagerBean
    //
    private void registerBackupAgentManagerBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      BackupAgentManagerBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, BackupAgentManagerBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, BackupAgentManagerBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     BackupAgentManagerBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IBackupAgentManager
     * @return an array of bean names
     */
    public List getBackupAgentManagerBeanNames() throws MgmtException
    {
        return listConfigElements(BackupAgentManagerBean.DS_TYPE);
    }

    /**
     * Get the 'BackupAgentManager' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IBackupAgentManager
     */
    public IBackupAgentManagerBean getBackupAgentManagerBean(String name) throws MgmtException
    {
        BackupAgentManagerBean bean = new BackupAgentManagerBean(this);

        bean.loadBean(name, BackupAgentManagerBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a BackupAgentManager bean with the specified name
     * @param name the name of the new bean
     * @return a new BackupAgentManager bean
     */
    public IBackupAgentManagerBean createBackupAgentManagerBean(String name) throws MgmtException
    {
        BackupAgentManagerBean bean = new BackupAgentManagerBean(this);

        bean.createBean(name, BackupAgentManagerBean.DS_TYPE, BackupAgentManagerBean.DS_C_VERSION, BackupAgentManagerBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified BackupAgentManager bean
     * @param bean the BackupAgentManager bean to save
     */
    public void saveBackupAgentManagerBean(IBackupAgentManagerBean bean) throws MgmtException
    {
        if(bean !=null){
            IBackupAgentManagerBean.IAMReferences configElementReferences = bean.getConfigElementReferences();
            try {
                IMgmtBeanBase referenceAttribute = configElementReferences.getReferenceAttribute(BackupAgentManagerBean.PRIMARY_AM_CONFIG_ELEMENT_REF_ATTR);
            } catch (MgmtException e) {
                throw new MgmtException("The Primary Reference Attribute is not set for the Backup Agent Manager.",e);
            }
        }
        saveBean(bean);
    }

    /**
     * Delete the specified BackupAgentManager bean
     * @param bean the BackupAgentManager bean to delete
     */
    public void deleteBackupAgentManagerBean(IBackupAgentManagerBean bean) throws MgmtException
    {
        //Removing the config reference attributes from the primary.
        IBackupAgentManagerBean.IAMReferences amReferences = bean.getConfigElementReferences();
        IAgentManagerBean primaryBean = (IAgentManagerBean) amReferences.getPrimaryAmConfigElementRef();
        IAgentManagerBean.IAMReferences configElementReferences = primaryBean.getConfigElementReferences();
        configElementReferences.removeAttribute(AgentManagerBean.BACKUP_AM_CONFIG_ELEMENT_REF_ATTR);

        //Deleting the Backup Bean.
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for DirectoryServiceBean
    //
    private void registerDirectoryServiceBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      DirectoryServiceBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, DirectoryServiceBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, DirectoryServiceBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     DirectoryServiceBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IDirectoryService
     * @return an array of bean names
     */
    public List getDirectoryServiceBeanNames() throws MgmtException
    {
        return listConfigElements(DirectoryServiceBean.DS_TYPE);
    }

    /**
     * Get the 'DirectoryService' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IDirectoryService
     */
    public IDirectoryServiceBean getDirectoryServiceBean(String name) throws MgmtException
    {
        DirectoryServiceBean bean = new DirectoryServiceBean(this);

        bean.loadBean(name, DirectoryServiceBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a DirectoryService bean with the specified name
     * @param name the name of the new bean
     * @return a new DirectoryService bean
     */
    public IDirectoryServiceBean createDirectoryServiceBean(String name) throws MgmtException
    {
        DirectoryServiceBean bean = new DirectoryServiceBean(this);

        bean.createBean(name, DirectoryServiceBean.DS_TYPE, DirectoryServiceBean.DS_C_VERSION, DirectoryServiceBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified DirectoryService bean
     * @param bean the DirectoryService bean to save
     */
    public void saveDirectoryServiceBean(IDirectoryServiceBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified DirectoryService bean
     * @param bean the DirectoryService bean to delete
     */
    public void deleteDirectoryServiceBean(IDirectoryServiceBean bean) throws MgmtException
    {
        IDirectoryServiceBean.IDsReferencesType configElementReferences = bean.getConfigElementReferences();
        if(configElementReferences!=null){
            IMgmtBeanBase backupDS = null;
            try{
                backupDS= configElementReferences.getBackupConfigElementRef();
            }catch(Exception e){}
            if(backupDS instanceof IBackupDirectoryServiceBean){
                deleteBackupDirectoryServiceBean((IBackupDirectoryServiceBean) backupDS);
            }
        }
        String path = bean.getConfigBeanName();
        deleteBean(bean);
        path = path.substring(0, path.lastIndexOf('/'));
        //delete folders and all configurations under specified path
        deleteFolderPath(path);
    }



    // -----------------------------------------------------------------------
    // Domain methods for BackupDirectoryServiceBean
    //
    private void registerBackupDirectoryServiceBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      BackupDirectoryServiceBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, BackupDirectoryServiceBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, BackupDirectoryServiceBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     BackupDirectoryServiceBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IBackupDirectoryService
     * @return an array of bean names
     */
    public List getBackupDirectoryServiceBeanNames() throws MgmtException
    {
        return listConfigElements(BackupDirectoryServiceBean.DS_TYPE);
    }

    /**
     * Get the 'BackupDirectoryService' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IBackupDirectoryService
     */
    public IBackupDirectoryServiceBean getBackupDirectoryServiceBean(String name) throws MgmtException
    {
        BackupDirectoryServiceBean bean = new BackupDirectoryServiceBean(this);

        bean.loadBean(name, BackupDirectoryServiceBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a BackupDirectoryService bean with the specified name
     * @param name the name of the new bean.
     * @return a new BackupDirectoryService bean
     */
    public IBackupDirectoryServiceBean createBackupDirectoryServiceBean(String name) throws MgmtException
    {
        BackupDirectoryServiceBean bean = new BackupDirectoryServiceBean(this);
        bean.createBean(name, BackupDirectoryServiceBean.DS_TYPE, BackupDirectoryServiceBean.DS_C_VERSION, BackupDirectoryServiceBean.DS_P_VERSION);
        return bean;
    }

    /**
     * Save the specified BackupDirectoryService bean
     * @param bean the BackupDirectoryService bean to save
     */
    public void saveBackupDirectoryServiceBean(IBackupDirectoryServiceBean bean) throws MgmtException
    {
        if(bean !=null){
            IBackupDirectoryServiceBean.IDsReferencesType configElementReferences = bean.getConfigElementReferences();
            try {
                IMgmtBeanBase referenceAttribute = configElementReferences.getReferenceAttribute(BackupDirectoryServiceBean.PRIMARY_CONFIG_ELEMENT_REF_ATTR);
            } catch (MgmtException e) {
                throw new MgmtException("The Primary Reference Attribute is not set for the Backup Directory Service.",e);
            }
        }
        saveBean(bean);
    }

    /**
     * Delete the specified BackupDirectoryService bean
     * @param bean the BackupDirectoryService bean to delete
     */
    public void deleteBackupDirectoryServiceBean(IBackupDirectoryServiceBean bean) throws MgmtException
    {
        String path = bean.getConfigBeanName();
        IBackupDirectoryServiceBean.IDsReferencesType configElementReferences = bean.getConfigElementReferences();

        //Getting the primary bean.
        IDirectoryServiceBean primaryBean = (IDirectoryServiceBean) configElementReferences.getPrimaryConfigElementRef();

        //Deleting the Replication Connection bean.
        IDirectoryServiceBean.IDsReferencesType primaryConfigElementReferences = primaryBean.getConfigElementReferences();
        deleteReplicationConnectionBean((IReplicationConnectionBean) primaryConfigElementReferences.getReplicationConnectionsElementRef());

        //Removing the config reference attributes from the primary.
        primaryConfigElementReferences.removeAttribute(DirectoryServiceBean.BACKUP_CONFIG_ELEMENT_REF_ATTR);
        primaryConfigElementReferences.removeAttribute(DirectoryServiceBean.REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
        primaryBean.removeAttribute(DirectoryServiceBean.REPLICATION_PARAMETERS_ATTR);

        //Deleting the Backup Bean.
        deleteBean(bean);

        path = path.substring(0, path.lastIndexOf('/'));
        //delete folders and all configurations under specified path
        deleteFolderPath(path);
    }

    // -----------------------------------------------------------------------
    // Domain methods for ReplicationConnectionBean
    //
    private void registerReplicationConnectionBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      ReplicationConnectionBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, ReplicationConnectionBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, ReplicationConnectionBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     ReplicationConnectionBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IReplicationConnection
     * @return an array of bean names
     */
    public List getReplicationConnectionBeanNames() throws MgmtException
    {
        return listConfigElements(ReplicationConnectionBean.DS_TYPE);
    }

    /**
     * Get the 'ReplicationConnection' bean with the specified name
     * @param name The name of the Directory Service to which it belongs.
     * @return a bean of type IReplicationConnection
     */
    public IReplicationConnectionBean getReplicationConnectionBean(String name) throws MgmtException
    {
        ReplicationConnectionBean bean = new ReplicationConnectionBean(this);

        bean.loadBean(name, ReplicationConnectionBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a ReplicationConnection bean with the name
     * &lt;name&gt;/Replication Connections
     * @param name the name of the Directory Service bean
     * @return a new ReplicationConnection bean
     */
    public IReplicationConnectionBean createReplicationConnectionBean(String name) throws MgmtException
    {
        ReplicationConnectionBean bean = new ReplicationConnectionBean(this);

        bean.createBean(name, ReplicationConnectionBean.DS_TYPE, ReplicationConnectionBean.DS_C_VERSION, ReplicationConnectionBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified ReplicationConnection bean
     * @param bean the ReplicationConnection bean to save
     */
    public void saveReplicationConnectionBean(IReplicationConnectionBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified ReplicationConnection bean
     * @param bean the ReplicationConnection bean to delete
     */
    public void deleteReplicationConnectionBean(IReplicationConnectionBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for ComponentCollectionBean
    //
    private void registerComponentCollectionBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      ComponentCollectionBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, ComponentCollectionBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, ComponentCollectionBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     ComponentCollectionBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IComponentCollection
     * @return an array of bean names
     */
    public List getComponentCollectionBeanNames() throws MgmtException
    {
        return listConfigElements(ComponentCollectionBean.DS_TYPE);
    }

    /**
     * Get the 'ComponentCollection' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IComponentCollection
     */
    public IComponentCollectionBean getComponentCollectionBean(String name) throws MgmtException
    {
        ComponentCollectionBean bean = new ComponentCollectionBean(this);

        bean.loadBean(name, ComponentCollectionBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a ComponentCollection bean with the specified name
     * @param name the name of the new bean
     * @return a new ComponentCollection bean
     */
    public IComponentCollectionBean createComponentCollectionBean(String name) throws MgmtException
    {
        ComponentCollectionBean bean = new ComponentCollectionBean(this);

        bean.createBean(name, ComponentCollectionBean.DS_TYPE, ComponentCollectionBean.DS_C_VERSION, ComponentCollectionBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified ComponentCollection bean
     * @param bean the ComponentCollection bean to save
     */
    public void saveComponentCollectionBean(IComponentCollectionBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified ComponentCollection bean
     * @param bean the ComponentCollection bean to delete
     */
    public void deleteComponentCollectionBean(IComponentCollectionBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for ContainerCollectionBean
    //
    private void registerContainerCollectionBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      ContainerCollectionBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, ContainerCollectionBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, ContainerCollectionBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     ContainerCollectionBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IContainerCollection
     * @return an array of bean names
     */
    public List getContainerCollectionBeanNames() throws MgmtException
    {
        return listConfigElements(ContainerCollectionBean.DS_TYPE);
    }

    /**
     * Get the 'ContainerCollection' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IContainerCollection
     */
    public IContainerCollectionBean getContainerCollectionBean(String name) throws MgmtException
    {
        ContainerCollectionBean bean = new ContainerCollectionBean(this);

        bean.loadBean(name, ContainerCollectionBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a ContainerCollection bean with the specified name
     * @param name the name of the new bean
     * @return a new ContainerCollection bean
     */
    public IContainerCollectionBean createContainerCollectionBean(String name) throws MgmtException
    {
        ContainerCollectionBean bean = new ContainerCollectionBean(this);

        bean.createBean(name, ContainerCollectionBean.DS_TYPE, ContainerCollectionBean.DS_C_VERSION, ContainerCollectionBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified ContainerCollection bean
     * @param bean the ContainerCollection bean to save
     */
    public void saveContainerCollectionBean(IContainerCollectionBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified ContainerCollection bean
     * @param bean the ContainerCollection bean to delete
     */
    public void deleteContainerCollectionBean(IContainerCollectionBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for CollectionsMonitorBean
    //
    private void registerCollectionsMonitorBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      CollectionsMonitorBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, CollectionsMonitorBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, CollectionsMonitorBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     CollectionsMonitorBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type ICollectionsMonitor
     * @return an array of bean names
     */
    public List getCollectionsMonitorBeanNames() throws MgmtException
    {
        return listConfigElements(CollectionsMonitorBean.DS_TYPE);
    }

    /**
     * Get the 'CollectionsMonitor' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type ICollectionsMonitor
     */
    public ICollectionsMonitorBean getCollectionsMonitorBean(String name) throws MgmtException
    {
        CollectionsMonitorBean bean = new CollectionsMonitorBean(this);

        bean.loadBean(name, CollectionsMonitorBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a CollectionsMonitor bean with the specified name
     * @param name the name of the new bean
     * @return a new CollectionsMonitor bean
     */
    public ICollectionsMonitorBean createCollectionsMonitorBean(String name) throws MgmtException
    {
        CollectionsMonitorBean bean = new CollectionsMonitorBean(this);

        bean.createBean(name, CollectionsMonitorBean.DS_TYPE, CollectionsMonitorBean.DS_C_VERSION, CollectionsMonitorBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified CollectionsMonitor bean
     * @param bean the CollectionsMonitor bean to save
     */
    public void saveCollectionsMonitorBean(ICollectionsMonitorBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified CollectionsMonitor bean
     * @param bean the CollectionsMonitor bean to delete
     */
    public void deleteCollectionsMonitorBean(ICollectionsMonitorBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for AuthenticationDomainBean
    //
    private void registerAuthenticationDomainBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      AuthenticationDomainBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, AuthenticationDomainBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, AuthenticationDomainBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     AuthenticationDomainBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.TRUE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IAuthenticationDomain
     * @return an array of bean names
     */
    public List getAuthenticationDomainBeanNames() throws MgmtException
    {
        return listConfigElements(AuthenticationDomainBean.DS_TYPE);
    }

    /**
     * Get the 'AuthenticationDomain' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IAuthenticationDomain
     */
    public IAuthenticationDomainBean getAuthenticationDomainBean(String name) throws MgmtException
    {
        AuthenticationDomainBean bean = new AuthenticationDomainBean(this);

        bean.loadBean(name, AuthenticationDomainBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a AuthenticationDomain bean with the specified name
     * @param name the name of the new bean
     * @return a new AuthenticationDomain bean
     */
    public IAuthenticationDomainBean createAuthenticationDomainBean(String name) throws MgmtException
    {
        AuthenticationDomainBean bean = new AuthenticationDomainBean(this);

        bean.createBean(name, AuthenticationDomainBean.DS_TYPE, AuthenticationDomainBean.DS_C_VERSION, AuthenticationDomainBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified AuthenticationDomain bean
     * @param bean the AuthenticationDomain bean to save
     */
    public void saveAuthenticationDomainBean(IAuthenticationDomainBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified AuthenticationDomain bean
     * @param bean the AuthenticationDomain bean to delete
     */
    public void deleteAuthenticationDomainBean(IAuthenticationDomainBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

    // -----------------------------------------------------------------------
    // Domain methods for AuthenticationUserBean
    //
    private void registerAuthenticationUserBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      AuthenticationUserBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, AuthenticationUserBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, AuthenticationUserBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     AuthenticationUserBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }


    // -----------------------------------------------------------------------
    // Domain methods for AuthenticationGroupBean
    //
    private void registerAuthenticationGroupBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      AuthenticationGroupBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, AuthenticationGroupBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, AuthenticationGroupBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     AuthenticationGroupBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }


    // -----------------------------------------------------------------------
    // Domain methods for GenericComponentBean
    //
    private void registerGenericComponentBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      GenericComponentBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, GenericComponentBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, GenericComponentBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     GenericComponentBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.TRUE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IGenericComponent
     * @return an array of bean names
     * @deprecated
     */
    public List getGenericComponentBeanNames() throws MgmtException
    {
        return listConfigElements(GenericComponentBean.DS_TYPE);
    }

    /**
     * Get the 'GenericComponent' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IGenericComponent
     * @deprecated
     */
    public IGenericComponentBean getGenericComponentBean(String name) throws MgmtException
    {
        GenericComponentBean bean = new GenericComponentBean(this);

        bean.loadBean(name, GenericComponentBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a GenericComponent bean with the specified name
     * @param name the name of the new bean
     * @return a new GenericComponent bean
     * @deprecated
     */
    public IGenericComponentBean createGenericComponentBean(String name) throws MgmtException
    {
        GenericComponentBean bean = new GenericComponentBean(this);

        bean.createBean(name, GenericComponentBean.DS_TYPE, GenericComponentBean.DS_C_VERSION, GenericComponentBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified GenericComponent bean
     * @param bean the GenericComponent bean to save
     * @deprecated
     */
    public void saveGenericComponentBean(IGenericComponentBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified GenericComponent bean
     * @param bean the GenericComponent bean to delete
     * @deprecated
     */
    public void deleteGenericComponentBean(IGenericComponentBean bean) throws MgmtException
    {
        deleteBean(bean);
    }


    // -----------------------------------------------------------------------
    // Domain methods for HostManagerBean
    //
    private void registerHostManagerBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      HostManagerBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, HostManagerBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, HostManagerBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     HostManagerBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.FALSE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type IHostManager
     * @return an array of bean names
     */
    public List getHostManagerBeanNames() throws MgmtException
    {
        return listConfigElements(HostManagerBean.DS_TYPE);
    }

    /**
     * Get the 'HostManager' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type IHostManager
     */
    public IHostManagerBean getHostManagerBean(String name) throws MgmtException
    {
        HostManagerBean bean = new HostManagerBean(this);

        bean.loadBean(name, HostManagerBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a HostManager bean with the specified name
     * @param name the name of the new bean
     * @return a new HostManager bean
     */
    public IHostManagerBean createHostManagerBean(String name) throws MgmtException
    {
        HostManagerBean bean = new HostManagerBean(this);

        bean.createBean(name, HostManagerBean.DS_TYPE, HostManagerBean.DS_C_VERSION, HostManagerBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified HostManager bean
     * @param bean the HostManager bean to save
     */
    public void saveHostManagerBean(IHostManagerBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified HostManager bean
     * @param bean the HostManager bean to delete
     */
    public void deleteHostManagerBean(IHostManagerBean bean) throws MgmtException
    {
        deleteBean(bean);
    }


    // -----------------------------------------------------------------------
    // Domain methods for LoggerBean
    //
    private void registerLoggerBean()
    {
        HashMap map = new HashMap();

        map.put(IMgmtBeanBase.TYPE_PROPERTY,      LoggerBean.DS_TYPE);
        map.put(IMgmtBeanBase.C_VERSION_PROPERTY, LoggerBean.DS_C_VERSION);
        map.put(IMgmtBeanBase.P_VERSION_PROPERTY, LoggerBean.DS_P_VERSION);
        map.put(IMgmtBeanBase.CLASS_PROPERTY,     LoggerBean.class);
        map.put(IMgmtBeanBase.TEMPLATE_PROPERTY,  Boolean.TRUE);

        registerBean(map);
    }

    /**
     * Get the names of all beans of type ILogger
     * @return an array of bean names
     */
    public List getLoggerBeanNames() throws MgmtException
    {
        return listConfigElements(LoggerBean.DS_TYPE);
    }

    /**
     * Get the 'Logger' bean with the specified name
     * @param name The name of the bean
     * @return a bean of type ILogger
     */
    public ILoggerBean getLoggerBean(String name) throws MgmtException
    {
        LoggerBean bean = new LoggerBean(this);

        bean.loadBean(name, LoggerBean.DS_TYPE);

        return bean;
    }

    /**
     * Create a Logger bean with the specified name
     * @param name the name of the new bean
     * @return a new Logger bean
     */
    public ILoggerBean createLoggerBean(String name) throws MgmtException
    {
        LoggerBean bean = new LoggerBean(this);

        bean.createBean(name, LoggerBean.DS_TYPE, LoggerBean.DS_C_VERSION, LoggerBean.DS_P_VERSION);

        return bean;
    }

    /**
     * Save the specified Logger bean
     * @param bean the Logger bean to save
     */
    public void saveLoggerBean(ILoggerBean bean) throws MgmtException
    {
        saveBean(bean);
    }

    /**
     * Delete the specified Logger bean
     * @param bean the Logger bean to delete
     */
    public void deleteLoggerBean(ILoggerBean bean) throws MgmtException
    {
        deleteBean(bean);
    }

}
