/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IActivationDaemonBean;

/**
 * Configuration Bean representing a 'ActivationDaemon'
 */
public interface IAbstractActivationDaemonBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for CONTAINERS.
     * @return The IContainersSet value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IActivationDaemonBean.IContainersSet getContainers() throws MgmtException;

    /**
     * Get the attribute metadata for CONTAINERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getContainersMetaData() throws MgmtException;

    /**
     * Inner class representing ContainersSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractContainersSet extends IMgmtMapBase
    {

        /**
         * Get the IActivationDaemonBean.IChildType atribute from the map with the specified key name
         * @param name The key name for this Container within the Map
         * @return The IActivationDaemonBean.IChildType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IActivationDaemonBean.IChildType getContainer(String name) throws MgmtException;

        /**
         * Create an instance of an IActivationDaemonBean.IChildType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addContainer
         * or insertContainer methods
         * @return The new IActivationDaemonBean.IChildType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IActivationDaemonBean.IChildType createContainer() throws MgmtException;

        /**
         * Add the new Container of type IActivationDaemonBean.IChildType into this map keyed
         * off the specified key name
         * @param name The key name for this Container in the map
         * @param value The IActivationDaemonBean.IChildType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addContainer(String name, IActivationDaemonBean.IChildType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteContainer(String name) throws MgmtException;

        /**
         * Get the attribute metadata for container.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getContainerMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ChildType
     * This class extends IMgmtListBase
     */
    public interface IAbstractChildType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for SCHEDULES.
         * @return The IScheduleList value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IActivationDaemonBean.IScheduleList getSchedules() throws MgmtException;

        /**
         * Set the attribute for SCHEDULES to the specified IScheduleList value.
         * @param value The IScheduleList value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setSchedules(IActivationDaemonBean.IScheduleList value) throws MgmtException;

        /**
         * Create an instance of an IScheduleList attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setSchedules method.
         * @return The new IScheduleList bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IActivationDaemonBean.IScheduleList createSchedules() throws MgmtException;

        /**
         * Get the attribute metadata for SCHEDULES.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getSchedulesMetaData() throws MgmtException;

        /**
         * Get the attribute for RETRY_INTERVAL_SECONDS as a long value.
         * @return The long value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public long getRetryIntervalSeconds() throws MgmtException;

        /**
         * Set the attribute for RETRY_INTERVAL_SECONDS to the specified long value.
         * @param value The long value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRetryIntervalSeconds(long value) throws MgmtException;

        /**
         * Get the attribute metadata for RETRY_INTERVAL_SECONDS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRetryIntervalSecondsMetaData() throws MgmtException;

        /**
         * Get the attribute for CONTAINER_REF as a IMgmtBeanBase value.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getContainerRef() throws MgmtException;

        /**
         * Set the attribute for CONTAINER_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setContainerRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for CONTAINER_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getContainerRefMetaData() throws MgmtException;

        /**
         * Get the attribute for RETRY_TIMES as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRetryTimes() throws MgmtException;

        /**
         * Set the attribute for RETRY_TIMES to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRetryTimes(int value) throws MgmtException;

        /**
         * Get the attribute metadata for RETRY_TIMES.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRetryTimesMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ScheduleList
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractScheduleList extends IMgmtMapBase
    {

        /**
         * Get the IActivationDaemonBean.IScheduleType atribute from the map with the specified key name
         * @param name The key name for this Schedule within the Map
         * @return The IActivationDaemonBean.IScheduleType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IActivationDaemonBean.IScheduleType getSchedule(String name) throws MgmtException;

        /**
         * Create an instance of an IActivationDaemonBean.IScheduleType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addSchedule
         * or insertSchedule methods
         * @return The new IActivationDaemonBean.IScheduleType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IActivationDaemonBean.IScheduleType createSchedule() throws MgmtException;

        /**
         * Add the new Schedule of type IActivationDaemonBean.IScheduleType into this map keyed
         * off the specified key name
         * @param name The key name for this Schedule in the map
         * @param value The IActivationDaemonBean.IScheduleType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addSchedule(String name, IActivationDaemonBean.IScheduleType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteSchedule(String name) throws MgmtException;

        /**
         * Get the attribute metadata for schedule.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getScheduleMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ScheduleType
     * This class extends IMgmtListBase
     */
    public interface IAbstractScheduleType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for OCCURS_VALUE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getOccursValue() throws MgmtException;

        /**
         * Set the attribute for OCCURS_VALUE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setOccursValue(String value) throws MgmtException;

        /**
         * Get the attribute metadata for OCCURS_VALUE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getOccursValueMetaData() throws MgmtException;

        /**
         * Get the attribute for ACTION_TYPE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getActionType() throws MgmtException;

        /**
         * Set the attribute for ACTION_TYPE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setActionType(String value) throws MgmtException;

        /**
         * Get the attribute metadata for ACTION_TYPE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getActionTypeMetaData() throws MgmtException;

        /**
         * Get the attribute for OCCURS_TYPE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getOccursType() throws MgmtException;

        /**
         * Set the attribute for OCCURS_TYPE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setOccursType(String value) throws MgmtException;

        /**
         * Get the attribute metadata for OCCURS_TYPE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getOccursTypeMetaData() throws MgmtException;
    }
}
