/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;

/**
 * Configuration Bean representing a 'AgentManager'
 */
public interface IAbstractAgentManagerBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for MIN_POLL_THREADS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMinPollThreads() throws MgmtException;

    /**
     * Set the attribute for MIN_POLL_THREADS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMinPollThreads(int value) throws MgmtException;

    /**
     * Get the attribute metadata for MIN_POLL_THREADS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMinPollThreadsMetaData() throws MgmtException;

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for METRICS.
     * @return The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAgentManagerBean.IMetricsCollectionType getMetrics() throws MgmtException;

    /**
     * Set the attribute for METRICS to the specified IMetricsCollectionType value.
     * @param value The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMetrics(IAgentManagerBean.IMetricsCollectionType value) throws MgmtException;

    /**
     * Create an instance of an IMetricsCollectionType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMetrics method.
     * @return The new IMetricsCollectionType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IAgentManagerBean.IMetricsCollectionType createMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for MAX_POLL_THREADS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMaxPollThreads() throws MgmtException;

    /**
     * Set the attribute for MAX_POLL_THREADS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMaxPollThreads(int value) throws MgmtException;

    /**
     * Get the attribute metadata for MAX_POLL_THREADS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMaxPollThreadsMetaData() throws MgmtException;

    /**
     * Get the attribute for CONFIG_ELEMENT_REFERENCES.
     * @return The IAMReferences value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAgentManagerBean.IAMReferences getConfigElementReferences() throws MgmtException;

    /**
     * Get the attribute metadata for CONFIG_ELEMENT_REFERENCES.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException;

    /**
     * Get the attribute for FAULT_DETECTION_INTERVAL as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getFaultDetectionInterval() throws MgmtException;

    /**
     * Set the attribute for FAULT_DETECTION_INTERVAL to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setFaultDetectionInterval(int value) throws MgmtException;

    /**
     * Get the attribute metadata for FAULT_DETECTION_INTERVAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getFaultDetectionIntervalMetaData() throws MgmtException;

    /**
     * Inner class representing MetricsCollectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMetricsCollectionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for REFRESH_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRefreshInterval() throws MgmtException;

        /**
         * Set the attribute for REFRESH_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRefreshInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REFRESH_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException;

        /**
         * Get the attribute for REPEAT_ALERT_NOTIFICATIONS as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getRepeatAlertNotifications() throws MgmtException;

        /**
         * Set the attribute for REPEAT_ALERT_NOTIFICATIONS to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRepeatAlertNotifications(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for REPEAT_ALERT_NOTIFICATIONS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException;

        /**
         * Get the attribute for COLLECTION_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCollectionInterval() throws MgmtException;

        /**
         * Set the attribute for COLLECTION_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCollectionInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for COLLECTION_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing AMReferences
     * This class extends IMgmtListBase
     */
    public interface IAbstractAMReferences extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for BACKUP_AM_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getBackupAmConfigElementRef() throws MgmtException;

        /**
         * Get the attribute for BACKUP_AM_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getBackupAmConfigElementRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_AM_CONFIG_ELEMENT_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupAmConfigElementRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_AM_CONFIG_ELEMENT_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupAmConfigElementRefMetaData() throws MgmtException;
    }
}
