/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;

/**
 * Configuration Bean representing a 'AuthenticationDomain'
 */
public interface IAbstractAuthenticationDomainBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for EXTERNAL as a boolean value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getExternal() throws MgmtException;

    /**
     * Get the attribute for EXTERNAL as a boolean value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getExternal(boolean defValue) throws MgmtException;

    /**
     * Set the attribute for EXTERNAL to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setExternal(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for EXTERNAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getExternalMetaData() throws MgmtException;

    /**
     * Get the attribute for GROUP_MAP.
     * @return The IGroupMapType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAuthenticationDomainBean.IGroupMapType getGroupMap() throws MgmtException;

    /**
     * Set the attribute for GROUP_MAP to the specified IGroupMapType value.
     * @param value The IGroupMapType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setGroupMap(IAuthenticationDomainBean.IGroupMapType value) throws MgmtException;

    /**
     * Create an instance of an IGroupMapType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setGroupMap method.
     * @return The new IGroupMapType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IAuthenticationDomainBean.IGroupMapType createGroupMap() throws MgmtException;

    /**
     * Get the attribute metadata for GROUP_MAP.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getGroupMapMetaData() throws MgmtException;

    /**
     * Get the attribute for AUTH_SPI_CONNECTION_PARAMETERS.
     * @return The IConnectionParamMap value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAuthenticationDomainBean.IConnectionParamMap getAuthSpiConnectionParameters() throws MgmtException;

    /**
     * Set the attribute for AUTH_SPI_CONNECTION_PARAMETERS to the specified IConnectionParamMap value.
     * @param value The IConnectionParamMap value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setAuthSpiConnectionParameters(IAuthenticationDomainBean.IConnectionParamMap value) throws MgmtException;

    /**
     * Create an instance of an IConnectionParamMap attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setAuthSpiConnectionParameters method.
     * @return The new IConnectionParamMap bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IAuthenticationDomainBean.IConnectionParamMap createAuthSpiConnectionParameters() throws MgmtException;

    /**
     * Get the attribute metadata for AUTH_SPI_CONNECTION_PARAMETERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getAuthSpiConnectionParametersMetaData() throws MgmtException;

    /**
     * Get the attribute for AUTH_SPI as a IMgmtBeanBase value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getAuthSpi() throws MgmtException;

    /**
     * Get the attribute for AUTH_SPI as a IMgmtBeanBase value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getAuthSpi(IMgmtBeanBase defValue) throws MgmtException;

    /**
     * Set the attribute for AUTH_SPI to the specified IMgmtBeanBase value.
     * @param value The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setAuthSpi(IMgmtBeanBase value) throws MgmtException;

    /**
     * Get the attribute metadata for AUTH_SPI.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getAuthSpiMetaData() throws MgmtException;

    /**
     * Get the attribute for MGMT_SPI as a IMgmtBeanBase value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getMgmtSpi() throws MgmtException;

    /**
     * Get the attribute for MGMT_SPI as a IMgmtBeanBase value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getMgmtSpi(IMgmtBeanBase defValue) throws MgmtException;

    /**
     * Set the attribute for MGMT_SPI to the specified IMgmtBeanBase value.
     * @param value The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMgmtSpi(IMgmtBeanBase value) throws MgmtException;

    /**
     * Get the attribute metadata for MGMT_SPI.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMgmtSpiMetaData() throws MgmtException;

    /**
     * Get the attribute for DOMAIN_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getDomainName() throws MgmtException;

    /**
     * Set the attribute for DOMAIN_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setDomainName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for DOMAIN_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException;

    /**
     * Get the attribute for MGMT_SPI_CONNECTION_PARAMETERS.
     * @return The IConnectionParamMap value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAuthenticationDomainBean.IConnectionParamMap getMgmtSpiConnectionParameters() throws MgmtException;

    /**
     * Set the attribute for MGMT_SPI_CONNECTION_PARAMETERS to the specified IConnectionParamMap value.
     * @param value The IConnectionParamMap value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMgmtSpiConnectionParameters(IAuthenticationDomainBean.IConnectionParamMap value) throws MgmtException;

    /**
     * Create an instance of an IConnectionParamMap attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMgmtSpiConnectionParameters method.
     * @return The new IConnectionParamMap bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IAuthenticationDomainBean.IConnectionParamMap createMgmtSpiConnectionParameters() throws MgmtException;

    /**
     * Get the attribute metadata for MGMT_SPI_CONNECTION_PARAMETERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMgmtSpiConnectionParametersMetaData() throws MgmtException;

    /**
     * Inner class representing GroupMapType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractGroupMapType extends IMgmtMapBase
    {

        /**
         * Get the String atribute from the map with the specified key name
         * @param name The key name for this InternalGroupName within the Map
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getInternalGroupName(String name) throws MgmtException;

        /**
         * Add the new InternalGroupName of type String into this map keyed
         * off the specified key name
         * @param name The key name for this InternalGroupName in the map
         * @param value The String value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addInternalGroupName(String name, String value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteInternalGroupName(String name) throws MgmtException;

        /**
         * Get the attribute metadata for internalGroupName.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getInternalGroupNameMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ConnectionParamMap
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractConnectionParamMap extends IMgmtMapBase
    {

        /**
         * Get the String atribute from the map with the specified key name
         * @param name The key name for this ConnectionItem within the Map
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getConnectionItem(String name) throws MgmtException;

        /**
         * Add the new ConnectionItem of type String into this map keyed
         * off the specified key name
         * @param name The key name for this ConnectionItem in the map
         * @param value The String value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addConnectionItem(String name, String value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteConnectionItem(String name) throws MgmtException;

        /**
         * Get the attribute metadata for connectionItem.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getConnectionItemMetaData() throws MgmtException;
    }
}
