/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;

/**
 * Configuration Bean representing a 'AuthenticationGroup'
 */
public interface IAbstractAuthenticationGroupBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for GROUP_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getGroupName() throws MgmtException;

    /**
     * Set the attribute for GROUP_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setGroupName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for GROUP_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getGroupNameMetaData() throws MgmtException;

    /**
     * Get the attribute for GROUP_MEMBERS.
     * @return The IGroupMembersType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IAuthenticationGroupBean.IGroupMembersType getGroupMembers() throws MgmtException;

    /**
     * Set the attribute for GROUP_MEMBERS to the specified IGroupMembersType value.
     * @param value The IGroupMembersType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setGroupMembers(IAuthenticationGroupBean.IGroupMembersType value) throws MgmtException;

    /**
     * Create an instance of an IGroupMembersType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setGroupMembers method.
     * @return The new IGroupMembersType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IAuthenticationGroupBean.IGroupMembersType createGroupMembers() throws MgmtException;

    /**
     * Get the attribute metadata for GROUP_MEMBERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getGroupMembersMetaData() throws MgmtException;

    /**
     * Inner class representing GroupMembersType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractGroupMembersType extends IMgmtMapBase
    {

        /**
         * Get the IAuthenticationGroupBean.IGroupMemberType atribute from the map with the specified key name
         * @param name The key name for this Member within the Map
         * @return The IAuthenticationGroupBean.IGroupMemberType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IAuthenticationGroupBean.IGroupMemberType getMember(String name) throws MgmtException;

        /**
         * Create an instance of an IAuthenticationGroupBean.IGroupMemberType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addMember
         * or insertMember methods
         * @return The new IAuthenticationGroupBean.IGroupMemberType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IAuthenticationGroupBean.IGroupMemberType createMember() throws MgmtException;

        /**
         * Add the new Member of type IAuthenticationGroupBean.IGroupMemberType into this map keyed
         * off the specified key name
         * @param name The key name for this Member in the map
         * @param value The IAuthenticationGroupBean.IGroupMemberType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addMember(String name, IAuthenticationGroupBean.IGroupMemberType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteMember(String name) throws MgmtException;

        /**
         * Get the attribute metadata for member.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getMemberMetaData() throws MgmtException;
    }

    /**
     * Inner class representing GroupMemberType
     * This class extends IMgmtListBase
     */
    public interface IAbstractGroupMemberType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for MEMBER_TYPE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getMemberType() throws MgmtException;

        /**
         * Set the attribute for MEMBER_TYPE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setMemberType(String value) throws MgmtException;

        /**
         * Get the attribute metadata for MEMBER_TYPE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getMemberTypeMetaData() throws MgmtException;

        /**
         * Get the attribute for MEMBER_NAME as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getMemberName() throws MgmtException;

        /**
         * Set the attribute for MEMBER_NAME to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setMemberName(String value) throws MgmtException;

        /**
         * Get the attribute metadata for MEMBER_NAME.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getMemberNameMetaData() throws MgmtException;
    }
}
