/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IBackupAgentManagerBean;

/**
 * Configuration Bean representing a 'BackupAgentManager'
 */
public interface IAbstractBackupAgentManagerBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for CONFIG_ELEMENT_REFERENCES.
     * @return The IAMReferences value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IBackupAgentManagerBean.IAMReferences getConfigElementReferences() throws MgmtException;

    /**
     * Get the attribute metadata for CONFIG_ELEMENT_REFERENCES.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException;

    /**
     * Inner class representing AMReferences
     * This class extends IMgmtListBase
     */
    public interface IAbstractAMReferences extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for PRIMARY_AM_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getPrimaryAmConfigElementRef() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_AM_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getPrimaryAmConfigElementRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_AM_CONFIG_ELEMENT_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryAmConfigElementRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_AM_CONFIG_ELEMENT_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryAmConfigElementRefMetaData() throws MgmtException;
    }
}
