/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IBackupDirectoryServiceBean;

/**
 * Configuration Bean representing a 'BackupDirectoryService'
 */
public interface IAbstractBackupDirectoryServiceBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CONFIG_ELEMENT_REFERENCES.
     * @return The IDsReferencesType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IBackupDirectoryServiceBean.IDsReferencesType getConfigElementReferences() throws MgmtException;

    /**
     * Get the attribute metadata for CONFIG_ELEMENT_REFERENCES.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException;

    /**
     * Get the attribute for HOST_DIRECTORY as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getHostDirectory() throws MgmtException;

    /**
     * Set the attribute for HOST_DIRECTORY to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setHostDirectory(String value) throws MgmtException;

    /**
     * Get the attribute metadata for HOST_DIRECTORY.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getHostDirectoryMetaData() throws MgmtException;

    /**
     * Inner class representing DsReferencesType
     * This class extends IMgmtListBase
     */
    public interface IAbstractDsReferencesType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for PRIMARY_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getPrimaryConfigElementRef() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getPrimaryConfigElementRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_CONFIG_ELEMENT_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryConfigElementRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_CONFIG_ELEMENT_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryConfigElementRefMetaData() throws MgmtException;
    }
}
