/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtListBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.ICollectionsMonitorBean;

/**
 * Configuration Bean representing a 'CollectionsMonitor'
 */
public interface IAbstractCollectionsMonitorBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for SAVE_MONITORED_NOTIFICATIONS as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getSaveMonitoredNotifications() throws MgmtException;

    /**
     * Set the attribute for SAVE_MONITORED_NOTIFICATIONS to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setSaveMonitoredNotifications(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for SAVE_MONITORED_NOTIFICATIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getSaveMonitoredNotificationsMetaData() throws MgmtException;

    /**
     * Get the attribute for HISTORY_DURATION_HOURS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getHistoryDurationHours() throws MgmtException;

    /**
     * Set the attribute for HISTORY_DURATION_HOURS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setHistoryDurationHours(int value) throws MgmtException;

    /**
     * Get the attribute metadata for HISTORY_DURATION_HOURS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getHistoryDurationHoursMetaData() throws MgmtException;

    /**
     * Get the attribute for METRICS.
     * @return The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ICollectionsMonitorBean.IMetricsCollectionType getMetrics() throws MgmtException;

    /**
     * Set the attribute for METRICS to the specified IMetricsCollectionType value.
     * @param value The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMetrics(ICollectionsMonitorBean.IMetricsCollectionType value) throws MgmtException;

    /**
     * Create an instance of an IMetricsCollectionType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMetrics method.
     * @return The new IMetricsCollectionType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public ICollectionsMonitorBean.IMetricsCollectionType createMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException;

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for COLLECTIONS.
     * @return The ICollectionList value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ICollectionsMonitorBean.ICollectionList getCollections() throws MgmtException;

    /**
     * Get the attribute metadata for COLLECTIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getCollectionsMetaData() throws MgmtException;

    /**
     * Get the attribute for SAVE_THRESHOLD_NOTIFICATIONS as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getSaveThresholdNotifications() throws MgmtException;

    /**
     * Set the attribute for SAVE_THRESHOLD_NOTIFICATIONS to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setSaveThresholdNotifications(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for SAVE_THRESHOLD_NOTIFICATIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getSaveThresholdNotificationsMetaData() throws MgmtException;

    /**
     * Get the attribute for JDBC_HISTORY_STORAGE.
     * @return The IJdbcStorageType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ICollectionsMonitorBean.IJdbcStorageType getJdbcHistoryStorage() throws MgmtException;

    /**
     * Set the attribute for JDBC_HISTORY_STORAGE to the specified IJdbcStorageType value.
     * @param value The IJdbcStorageType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setJdbcHistoryStorage(ICollectionsMonitorBean.IJdbcStorageType value) throws MgmtException;

    /**
     * Create an instance of an IJdbcStorageType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setJdbcHistoryStorage method.
     * @return The new IJdbcStorageType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public ICollectionsMonitorBean.IJdbcStorageType createJdbcHistoryStorage() throws MgmtException;

    /**
     * Get the attribute metadata for JDBC_HISTORY_STORAGE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getJdbcHistoryStorageMetaData() throws MgmtException;

    /**
     * Get the attribute for MAX_STORAGE_SIZE as a long value.
     * @return The long value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public long getMaxStorageSize() throws MgmtException;

    /**
     * Set the attribute for MAX_STORAGE_SIZE to the specified long value.
     * @param value The long value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMaxStorageSize(long value) throws MgmtException;

    /**
     * Get the attribute metadata for MAX_STORAGE_SIZE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMaxStorageSizeMetaData() throws MgmtException;

    /**
     * Get the attribute for FS_HISTORY_STORAGE.
     * @return The IFsStorageType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ICollectionsMonitorBean.IFsStorageType getFsHistoryStorage() throws MgmtException;

    /**
     * Get the attribute metadata for FS_HISTORY_STORAGE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getFsHistoryStorageMetaData() throws MgmtException;

    /**
     * Get the attribute for NOTIFICATION_SUBSCRIPTION_TIMEOUT as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getNotificationSubscriptionTimeout() throws MgmtException;

    /**
     * Set the attribute for NOTIFICATION_SUBSCRIPTION_TIMEOUT to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setNotificationSubscriptionTimeout(int value) throws MgmtException;

    /**
     * Get the attribute metadata for NOTIFICATION_SUBSCRIPTION_TIMEOUT.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getNotificationSubscriptionTimeoutMetaData() throws MgmtException;

    /**
     * Inner class representing MetricsCollectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMetricsCollectionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for REFRESH_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRefreshInterval() throws MgmtException;

        /**
         * Set the attribute for REFRESH_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRefreshInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REFRESH_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException;

        /**
         * Get the attribute for REPEAT_ALERT_NOTIFICATIONS as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getRepeatAlertNotifications() throws MgmtException;

        /**
         * Set the attribute for REPEAT_ALERT_NOTIFICATIONS to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRepeatAlertNotifications(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for REPEAT_ALERT_NOTIFICATIONS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException;

        /**
         * Get the attribute for COLLECTION_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCollectionInterval() throws MgmtException;

        /**
         * Set the attribute for COLLECTION_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCollectionInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for COLLECTION_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing CollectionList
     * This inner class contains inner data items that have a zero based
     * index. This class extends IMgmtListBase
     */
    public interface IAbstractCollectionList extends IMgmtListBase
    {

        /**
         * Get the IMgmtBeanBase atribute from the list at the
         * specified index
         * @param index The index of the Entry in the list.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getEntry(int index) throws MgmtException;

        /**
         * Add the new Entry of type IMgmtBeanBase into this list at
         * the end of the list
         * @param value The IMgmtBeanBase value to add to the list
         * @throws MgmtException Thrown if there is some problem adding this item to the list
         */
        public void addEntry(IMgmtBeanBase value) throws MgmtException;

        /**
         * Insert the new Entry of type IMgmtBeanBase into this list at
         * the specified location
         * @param index The location in the list to add the new item
         * @param value The IMgmtBeanBase value to add to the list
         * @throws MgmtException Thrown if there is some problem inserting this item into the list
         */
        public void insertEntry(int index, IMgmtBeanBase value) throws MgmtException;

        /**
         * Delete the item at the specified index from the list
         * @param index The index of the item to delete
         * @throws MgmtException Thrown if there is some problem deleting this item from the list
         */
        public void deleteEntry(int index) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing JdbcStorageType
     * This class extends IMgmtListBase
     */
    public interface IAbstractJdbcStorageType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for USER as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getUser() throws MgmtException;

        /**
         * Set the attribute for USER to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setUser(String value) throws MgmtException;

        /**
         * Get the attribute metadata for USER.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getUserMetaData() throws MgmtException;

        /**
         * Get the attribute for BLOB_SQL_TYPE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBlobSqlType() throws MgmtException;

        /**
         * Set the attribute for BLOB_SQL_TYPE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBlobSqlType(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BLOB_SQL_TYPE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBlobSqlTypeMetaData() throws MgmtException;

        /**
         * Get the attribute for DRIVER as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDriver() throws MgmtException;

        /**
         * Set the attribute for DRIVER to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDriver(String value) throws MgmtException;

        /**
         * Get the attribute metadata for DRIVER.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getDriverMetaData() throws MgmtException;

        /**
         * Get the attribute for PASSWORD as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPassword() throws MgmtException;

        /**
         * Set the attribute for PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for URL as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getUrl() throws MgmtException;

        /**
         * Set the attribute for URL to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setUrl(String value) throws MgmtException;

        /**
         * Get the attribute metadata for URL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getUrlMetaData() throws MgmtException;

        /**
         * Get the attribute for UNIQUE_CONSTRAINT_ERROR as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getUniqueConstraintError() throws MgmtException;

        /**
         * Set the attribute for UNIQUE_CONSTRAINT_ERROR to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setUniqueConstraintError(String value) throws MgmtException;

        /**
         * Get the attribute metadata for UNIQUE_CONSTRAINT_ERROR.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getUniqueConstraintErrorMetaData() throws MgmtException;

        /**
         * Get the attribute for TABLE_NOT_FOUND_ERROR as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getTableNotFoundError() throws MgmtException;

        /**
         * Set the attribute for TABLE_NOT_FOUND_ERROR to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setTableNotFoundError(String value) throws MgmtException;

        /**
         * Get the attribute metadata for TABLE_NOT_FOUND_ERROR.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getTableNotFoundErrorMetaData() throws MgmtException;
    }

    /**
     * Inner class representing FsStorageType
     * This class extends IMgmtListBase
     */
    public interface IAbstractFsStorageType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for DIRECTORY as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDirectory() throws MgmtException;

        /**
         * Set the attribute for DIRECTORY to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDirectory(String value) throws MgmtException;

        /**
         * Get the attribute metadata for DIRECTORY.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getDirectoryMetaData() throws MgmtException;
    }
}
