/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtListBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;

/**
 * Configuration Bean representing a 'ComponentCollection'
 */
public interface IAbstractComponentCollectionBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for FORWARD_NOTIFICATIONS.
     * @return The INotifListType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IComponentCollectionBean.INotifListType getForwardNotifications() throws MgmtException;

    /**
     * Set the attribute for FORWARD_NOTIFICATIONS to the specified INotifListType value.
     * @param value The INotifListType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setForwardNotifications(IComponentCollectionBean.INotifListType value) throws MgmtException;

    /**
     * Create an instance of an INotifListType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setForwardNotifications method.
     * @return The new INotifListType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IComponentCollectionBean.INotifListType createForwardNotifications() throws MgmtException;

    /**
     * Get the attribute metadata for FORWARD_NOTIFICATIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getForwardNotificationsMetaData() throws MgmtException;

    /**
     * Get the attribute for COMPONENTS.
     * @return The IComponentsSet value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IComponentCollectionBean.IComponentsSet getComponents() throws MgmtException;

    /**
     * Get the attribute metadata for COMPONENTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getComponentsMetaData() throws MgmtException;

    /**
     * Get the attribute for METRICS_REFRESH_INTERVAL_SECONDS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMetricsRefreshIntervalSeconds() throws MgmtException;

    /**
     * Set the attribute for METRICS_REFRESH_INTERVAL_SECONDS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMetricsRefreshIntervalSeconds(int value) throws MgmtException;

    /**
     * Get the attribute metadata for METRICS_REFRESH_INTERVAL_SECONDS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMetricsRefreshIntervalSecondsMetaData() throws MgmtException;

    /**
     * Get the attribute for NOTIFICATION_MONITORS.
     * @return The IMonitorsSet value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IComponentCollectionBean.IMonitorsSet getNotificationMonitors() throws MgmtException;

    /**
     * Set the attribute for NOTIFICATION_MONITORS to the specified IMonitorsSet value.
     * @param value The IMonitorsSet value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setNotificationMonitors(IComponentCollectionBean.IMonitorsSet value) throws MgmtException;

    /**
     * Create an instance of an IMonitorsSet attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setNotificationMonitors method.
     * @return The new IMonitorsSet bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IComponentCollectionBean.IMonitorsSet createNotificationMonitors() throws MgmtException;

    /**
     * Get the attribute metadata for NOTIFICATION_MONITORS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getNotificationMonitorsMetaData() throws MgmtException;

    /**
     * Get the attribute for MONITOR_METRICS.
     * @return The IMetricListType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IComponentCollectionBean.IMetricListType getMonitorMetrics() throws MgmtException;

    /**
     * Set the attribute for MONITOR_METRICS to the specified IMetricListType value.
     * @param value The IMetricListType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMonitorMetrics(IComponentCollectionBean.IMetricListType value) throws MgmtException;

    /**
     * Create an instance of an IMetricListType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMonitorMetrics method.
     * @return The new IMetricListType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IComponentCollectionBean.IMetricListType createMonitorMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for MONITOR_METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMonitorMetricsMetaData() throws MgmtException;

    /**
     * Inner class representing NotifListType
     * This inner class contains inner data items that have a zero based
     * index. This class extends IMgmtListBase
     */
    public interface IAbstractNotifListType extends IMgmtListBase
    {

        /**
         * Get the String atribute from the list at the
         * specified index
         * @param index The index of the ListItem in the list.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getListItem(int index) throws MgmtException;

        /**
         * Add the new ListItem of type String into this list at
         * the end of the list
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem adding this item to the list
         */
        public void addListItem(String value) throws MgmtException;

        /**
         * Insert the new ListItem of type String into this list at
         * the specified location
         * @param index The location in the list to add the new item
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem inserting this item into the list
         */
        public void insertListItem(int index, String value) throws MgmtException;

        /**
         * Delete the item at the specified index from the list
         * @param index The index of the item to delete
         * @throws MgmtException Thrown if there is some problem deleting this item from the list
         */
        public void deleteListItem(int index) throws MgmtException;

        /**
         * Get the attribute metadata for listItem.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ComponentsSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractComponentsSet extends IMgmtMapBase
    {

        /**
         * Get the IComponentCollectionBean.IComponent atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IComponentCollectionBean.IComponent value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IComponentCollectionBean.IComponent getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IComponentCollectionBean.IComponent attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IComponentCollectionBean.IComponent bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IComponentCollectionBean.IComponent createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IComponentCollectionBean.IComponent into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IComponentCollectionBean.IComponent value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IComponentCollectionBean.IComponent value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing MonitorsSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractMonitorsSet extends IMgmtMapBase
    {

        /**
         * Get the IComponentCollectionBean.IMonitorType atribute from the map with the specified key name
         * @param name The key name for this Monitor within the Map
         * @return The IComponentCollectionBean.IMonitorType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IComponentCollectionBean.IMonitorType getMonitor(String name) throws MgmtException;

        /**
         * Create an instance of an IComponentCollectionBean.IMonitorType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addMonitor
         * or insertMonitor methods
         * @return The new IComponentCollectionBean.IMonitorType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IComponentCollectionBean.IMonitorType createMonitor() throws MgmtException;

        /**
         * Add the new Monitor of type IComponentCollectionBean.IMonitorType into this map keyed
         * off the specified key name
         * @param name The key name for this Monitor in the map
         * @param value The IComponentCollectionBean.IMonitorType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addMonitor(String name, IComponentCollectionBean.IMonitorType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteMonitor(String name) throws MgmtException;

        /**
         * Get the attribute metadata for monitor.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getMonitorMetaData() throws MgmtException;
    }

    /**
     * Inner class representing MetricListType
     * This inner class contains inner data items that have a zero based
     * index. This class extends IMgmtListBase
     */
    public interface IAbstractMetricListType extends IMgmtListBase
    {

        /**
         * Get the String atribute from the list at the
         * specified index
         * @param index The index of the ListItem in the list.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getListItem(int index) throws MgmtException;

        /**
         * Add the new ListItem of type String into this list at
         * the end of the list
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem adding this item to the list
         */
        public void addListItem(String value) throws MgmtException;

        /**
         * Insert the new ListItem of type String into this list at
         * the specified location
         * @param index The location in the list to add the new item
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem inserting this item into the list
         */
        public void insertListItem(int index, String value) throws MgmtException;

        /**
         * Delete the item at the specified index from the list
         * @param index The index of the item to delete
         * @throws MgmtException Thrown if there is some problem deleting this item from the list
         */
        public void deleteListItem(int index) throws MgmtException;

        /**
         * Get the attribute metadata for listItem.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException;
    }

    /**
     * Inner class representing Component
     * This class extends IMgmtListBase
     */
    public interface IAbstractComponent extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for COMPONENT_RUNTIME_ID as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getComponentRuntimeId() throws MgmtException;

        /**
         * Set the attribute for COMPONENT_RUNTIME_ID to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setComponentRuntimeId(String value) throws MgmtException;

        /**
         * Get the attribute metadata for COMPONENT_RUNTIME_ID.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getComponentRuntimeIdMetaData() throws MgmtException;

        /**
         * Get the attribute for CONFIG_REF as a IMgmtBeanBase value.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getConfigRef() throws MgmtException;

        /**
         * Set the attribute for CONFIG_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for CONFIG_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException;
    }

    /**
     * Inner class representing MonitorType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMonitorType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for INTERVAL_SECONDS as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getIntervalSeconds() throws MgmtException;

        /**
         * Set the attribute for INTERVAL_SECONDS to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setIntervalSeconds(int value) throws MgmtException;

        /**
         * Get the attribute metadata for INTERVAL_SECONDS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getIntervalSecondsMetaData() throws MgmtException;

        /**
         * Get the attribute for MONITOR_NOTIFICATIONS.
         * @return The INotifList value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IComponentCollectionBean.INotifList getMonitorNotifications() throws MgmtException;

        /**
         * Get the attribute metadata for MONITOR_NOTIFICATIONS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getMonitorNotificationsMetaData() throws MgmtException;

        /**
         * Get the attribute for LOW_THRESHOLD as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getLowThreshold() throws MgmtException;

        /**
         * Get the attribute for LOW_THRESHOLD as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getLowThreshold(int defValue) throws MgmtException;

        /**
         * Set the attribute for LOW_THRESHOLD to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setLowThreshold(int value) throws MgmtException;

        /**
         * Get the attribute metadata for LOW_THRESHOLD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getLowThresholdMetaData() throws MgmtException;

        /**
         * Get the attribute for HIGH_THRESHOLD as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getHighThreshold() throws MgmtException;

        /**
         * Get the attribute for HIGH_THRESHOLD as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getHighThreshold(int defValue) throws MgmtException;

        /**
         * Set the attribute for HIGH_THRESHOLD to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setHighThreshold(int value) throws MgmtException;

        /**
         * Get the attribute metadata for HIGH_THRESHOLD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getHighThresholdMetaData() throws MgmtException;
    }

    /**
     * Inner class representing NotifList
     * This inner class contains inner data items that have a zero based
     * index. This class extends IMgmtListBase
     */
    public interface IAbstractNotifList extends IMgmtListBase
    {

        /**
         * Get the String atribute from the list at the
         * specified index
         * @param index The index of the ListItem in the list.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getListItem(int index) throws MgmtException;

        /**
         * Add the new ListItem of type String into this list at
         * the end of the list
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem adding this item to the list
         */
        public void addListItem(String value) throws MgmtException;

        /**
         * Insert the new ListItem of type String into this list at
         * the specified location
         * @param index The location in the list to add the new item
         * @param value The String value to add to the list
         * @throws MgmtException Thrown if there is some problem inserting this item into the list
         */
        public void insertListItem(int index, String value) throws MgmtException;

        /**
         * Delete the item at the specified index from the list
         * @param index The index of the item to delete
         * @throws MgmtException Thrown if there is some problem deleting this item from the list
         */
        public void deleteListItem(int index) throws MgmtException;

        /**
         * Get the attribute metadata for listItem.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException;
    }
}
