/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IContainerBean;

/**
 * Configuration Bean representing a 'Container'
 */
public interface IAbstractContainerBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for MAX_THREADS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMaxThreads() throws MgmtException;

    /**
     * Set the attribute for MAX_THREADS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMaxThreads(int value) throws MgmtException;

    /**
     * Get the attribute metadata for MAX_THREADS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMaxThreadsMetaData() throws MgmtException;

    /**
     * Get the attribute for JVM_HOME as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getJvmHome() throws MgmtException;

    /**
     * Get the attribute for JVM_HOME as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getJvmHome(String defValue) throws MgmtException;

    /**
     * Set the attribute for JVM_HOME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setJvmHome(String value) throws MgmtException;

    /**
     * Get the attribute metadata for JVM_HOME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getJvmHomeMetaData() throws MgmtException;

    /**
     * Get the attribute for MONITORING.
     * @return The IMonitoringType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IMonitoringType getMonitoring() throws MgmtException;

    /**
     * Get the attribute metadata for MONITORING.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMonitoringMetaData() throws MgmtException;

    /**
     * Get the attribute for CACHE.
     * @return The ICacheType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.ICacheType getCache() throws MgmtException;

    /**
     * Get the attribute metadata for CACHE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getCacheMetaData() throws MgmtException;

    /**
     * Get the attribute for COMPONENTS.
     * @return The IComponentsType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IComponentsType getComponents() throws MgmtException;

    /**
     * Get the attribute metadata for COMPONENTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getComponentsMetaData() throws MgmtException;

    /**
     * Get the attribute for COMMAND_LINE as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getCommandLine() throws MgmtException;

    /**
     * Set the attribute for COMMAND_LINE to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setCommandLine(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for COMMAND_LINE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getCommandLineMetaData() throws MgmtException;

    /**
     * Get the attribute for ARCHIVE_SEARCH_PATH as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveSearchPath() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_SEARCH_PATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveSearchPath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_SEARCH_PATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveSearchPathMetaData() throws MgmtException;

    /**
     * Get the attribute for TRACE_MASK as a int value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getTraceMask() throws MgmtException;

    /**
     * Get the attribute for TRACE_MASK as a int value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getTraceMask(int defValue) throws MgmtException;

    /**
     * Set the attribute for TRACE_MASK to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setTraceMask(int value) throws MgmtException;

    /**
     * Get the attribute metadata for TRACE_MASK.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException;

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for ACTIONAL_SDK_ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getActionalSdkArchiveName() throws MgmtException;

    /**
     * Set the attribute for ACTIONAL_SDK_ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setActionalSdkArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ACTIONAL_SDK_ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getActionalSdkArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for ACTIONAL_PLUGMAKER_ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getActionalPlugmakerArchiveName() throws MgmtException;

    /**
     * Set the attribute for ACTIONAL_PLUGMAKER_ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setActionalPlugmakerArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ACTIONAL_PLUGMAKER_ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getActionalPlugmakerArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for METRICS.
     * @return The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IMetricsCollectionType getMetrics() throws MgmtException;

    /**
     * Set the attribute for METRICS to the specified IMetricsCollectionType value.
     * @param value The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMetrics(IContainerBean.IMetricsCollectionType value) throws MgmtException;

    /**
     * Create an instance of an IMetricsCollectionType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMetrics method.
     * @return The new IMetricsCollectionType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.IMetricsCollectionType createMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException;

    /**
     * Get the attribute for CONTAINER_NATIVE_LIBRARY_PATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getContainerNativeLibraryPath() throws MgmtException;

    /**
     * Get the attribute for CONTAINER_NATIVE_LIBRARY_PATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getContainerNativeLibraryPath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CONTAINER_NATIVE_LIBRARY_PATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setContainerNativeLibraryPath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CONTAINER_NATIVE_LIBRARY_PATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getContainerNativeLibraryPathMetaData() throws MgmtException;

    /**
     * Get the attribute for SYSTEM_PROPERTIES.
     * @return The ISystemPropertiesType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.ISystemPropertiesType getSystemProperties() throws MgmtException;

    /**
     * Set the attribute for SYSTEM_PROPERTIES to the specified ISystemPropertiesType value.
     * @param value The ISystemPropertiesType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setSystemProperties(IContainerBean.ISystemPropertiesType value) throws MgmtException;

    /**
     * Create an instance of an ISystemPropertiesType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setSystemProperties method.
     * @return The new ISystemPropertiesType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.ISystemPropertiesType createSystemProperties() throws MgmtException;

    /**
     * Get the attribute metadata for SYSTEM_PROPERTIES.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getSystemPropertiesMetaData() throws MgmtException;

    /**
     * Get the attribute for ENABLED_METRICS.
     * @return The IEnabledMetricsType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IEnabledMetricsType getEnabledMetrics() throws MgmtException;

    /**
     * Set the attribute for ENABLED_METRICS to the specified IEnabledMetricsType value.
     * @param value The IEnabledMetricsType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setEnabledMetrics(IContainerBean.IEnabledMetricsType value) throws MgmtException;

    /**
     * Create an instance of an IEnabledMetricsType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setEnabledMetrics method.
     * @return The new IEnabledMetricsType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.IEnabledMetricsType createEnabledMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for ENABLED_METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getEnabledMetricsMetaData() throws MgmtException;


    /**
     * Get the attribute for ENABLED_ALERTS.
     * @return The IEnabledAlertsType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IEnabledAlertsType getEnabledAlerts() throws MgmtException;

    /**
     * Set the attribute for ENABLED_ALERTS to the specified IEnabledAlertsType value.
     * @param value The IEnabledAlertsType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setEnabledAlerts(IContainerBean.IEnabledAlertsType value) throws MgmtException;

    /**
     * Create an instance of an IEnabledAlertsType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setEnabledAlerts method.
     * @return The new IEnabledAlertsType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.IEnabledAlertsType createEnabledAlerts() throws MgmtException;

    /**
     * Get the attribute metadata for ENABLED_ALERTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getEnabledAlertsMetaData() throws MgmtException;

    /**
     * Get the attribute for EXTENSIONS.
     * @return The IExtensionsType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IExtensionsType getExtensions() throws MgmtException;

    /**
     * Set the attribute for EXTENSIONS to the specified IExtensionsType value.
     * @param value The IExtensionsType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setExtensions(IContainerBean.IExtensionsType value) throws MgmtException;

    /**
     * Create an instance of an IExtensionsType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setExtensions method.
     * @return The new IExtensionsType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.IExtensionsType createExtensions() throws MgmtException;

    /**
     * Get the attribute metadata for EXTENSIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getExtensionsMetaData() throws MgmtException;

    /**
     * Get the attribute for DOMAIN_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getDomainName() throws MgmtException;

    /**
     * Set the attribute for DOMAIN_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setDomainName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for DOMAIN_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE_SIZE_THRESHOLD as a long value.
     * @return The long value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public long getLogFileSizeThreshold() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_SIZE_THRESHOLD to the specified long value.
     * @param value The long value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileSizeThreshold(long value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_SIZE_THRESHOLD.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileSizeThresholdMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE_ROLLOVER_SIZE_THRESHOLD as a long value.
     * @return The long value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public long getLogFileRolloverSizeThreshold() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_ROLLOVER_SIZE_THRESHOLD to the specified long value.
     * @param value The long value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileRolloverSizeThreshold(long value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_ROLLOVER_SIZE_THRESHOLD.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileRolloverSizeThresholdMetaData() throws MgmtException;


    /**
     * Get the attribute for LOG_FILE_ROLLOVER_TIME_INTERVAL as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getLogFileRolloverTimeInterval() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_ROLLOVER_TIME_INTERVAL to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileRolloverTimeInterval(int value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_ROLLOVER_TIME_INTERVAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileRolloverTimeIntervalMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getLogFile() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getLogFile(String defValue) throws MgmtException;

    /**
     * Set the attribute for LOG_FILE to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFile(String value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_TO_CONSOLE as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getLogToConsole() throws MgmtException;

    /**
     * Set the attribute for LOG_TO_CONSOLE to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogToConsole(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_TO_CONSOLE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogToConsoleMetaData() throws MgmtException;

    /**
     * Get the attribute for JVM_ARGUMENTS as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getJvmArguments() throws MgmtException;

    /**
     * Get the attribute for JVM_ARGUMENTS as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getJvmArguments(String defValue) throws MgmtException;

    /**
     * Set the attribute for JVM_ARGUMENTS to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setJvmArguments(String value) throws MgmtException;

    /**
     * Get the attribute metadata for JVM_ARGUMENTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getJvmArgumentsMetaData() throws MgmtException;

    /**
     * Get the attribute for MANAGEMENT_AUDIT_CONFIG as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getManagementAuditConfig() throws MgmtException;

    /**
     * Get the attribute for MANAGEMENT_AUDIT_CONFIG as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getManagementAuditConfig(String defValue) throws MgmtException;

    /**
     * Set the attribute for MANAGEMENT_AUDIT_CONFIG to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setManagementAuditConfig(String value) throws MgmtException;

    /**
     * Get the attribute metadata for MANAGEMENT_AUDIT_CONFIG.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getManagementAuditConfigMetaData() throws MgmtException;

    /**
     * Get the attribute for DIRECTORY_SERVICE_PING_INTERVAL as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getDirectoryServicePingInterval() throws MgmtException;

    /**
     * Set the attribute for DIRECTORY_SERVICE_PING_INTERVAL to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setDirectoryServicePingInterval(int value) throws MgmtException;

    /**
     * Get the attribute metadata for DIRECTORY_SERVICE_PING_INTERVAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getDirectoryServicePingIntervalMetaData() throws MgmtException;

    /**
     * Get the attribute for CENTRAL_CONNECTION.
     * @return The ICentralConnectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.ICentralConnectionType getCentralConnection() throws MgmtException;

    /**
     * Set the attribute for CENTRAL_CONNECTION to the specified ICentralConnectionType value.
     * @param value The ICentralConnectionType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setCentralConnection(IContainerBean.ICentralConnectionType value) throws MgmtException;

    /**
     * Create an instance of an ICentralConnectionType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setCentralConnection method.
     * @return The new ICentralConnectionType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.ICentralConnectionType createCentralConnection() throws MgmtException;

    /**
     * Get the attribute metadata for CENTRAL_CONNECTION.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getCentralConnectionMetaData() throws MgmtException;


    /**
     * Get the attribute for FAULT_TOLERANCE_PARAMETERS.
     * @return The IFaultToleranceType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IFaultToleranceType getFaultToleranceParameters() throws MgmtException;

    /**
     * Set the attribute for FAULT_TOLERANCE_PARAMETERS to the specified IFaultToleranceType value.
     * @param value The IFaultToleranceType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setFaultToleranceParameters(IContainerBean.IFaultToleranceType value) throws MgmtException;

    /**
     * Create an instance of an IFaultToleranceType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setFaultToleranceParameters method.
     * @return The new IFaultToleranceType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IContainerBean.IFaultToleranceType createFaultToleranceParameters() throws MgmtException;

    /**
     * Get the attribute metadata for FAULT_TOLERANCE_PARAMETERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getFaultToleranceParametersMetaData() throws MgmtException;

    /**
     * Get the attribute for MIN_THREADS as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMinThreads() throws MgmtException;

    /**
     * Set the attribute for MIN_THREADS to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMinThreads(int value) throws MgmtException;

    /**
     * Get the attribute metadata for MIN_THREADS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMinThreadsMetaData() throws MgmtException;

    /**
     * Get the attribute for CONNECTION.
     * @return The IConnectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerBean.IConnectionType getConnection() throws MgmtException;

    /**
     * Get the attribute metadata for CONNECTION.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getConnectionMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_TO_FILE as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getLogToFile() throws MgmtException;

    /**
     * Set the attribute for LOG_TO_FILE to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogToFile(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_TO_FILE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogToFileMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CONTAINER_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getContainerName() throws MgmtException;

    /**
     * Set the attribute for CONTAINER_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setContainerName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CONTAINER_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getContainerNameMetaData() throws MgmtException;

    /**
     * Get the attribute for ENABLE_CENTRALIZED_LOGGING as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getEnableCentralizedLogging() throws MgmtException;

    /**
     * Set the attribute for ENABLE_CENTRALIZED_LOGGING to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setEnableCentralizedLogging(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for ENABLE_CENTRALIZED_LOGGING.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getEnableCentralizedLoggingMetaData() throws MgmtException;

    /**
     * Get the attribute for ACTIONAL_LOG_INTERCEPTOR as a boolean value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getActionalLogInterceptor() throws MgmtException;

    /**
     * Get the attribute for ACTIONAL_LOG_INTERCEPTOR as a boolean value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getActionalLogInterceptor(boolean defValue) throws MgmtException;

    /**
     * Set the attribute for ACTIONAL_LOG_INTERCEPTOR to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setActionalLogInterceptor(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for ACTIONAL_LOG_INTERCEPTOR.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getActionalLogInterceptorMetaData() throws MgmtException;


    /**
     * Get the attribute for HOSTS_DIRECTORY_SERVICE as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getHostsDirectoryService() throws MgmtException;

    /**
     * Set the attribute for HOSTS_DIRECTORY_SERVICE to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setHostsDirectoryService(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for HOSTS_DIRECTORY_SERVICE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getHostsDirectoryServiceMetaData() throws MgmtException;

    /**
     * Get the attribute for NOTIFICATION_DISPATCH_QUEUE_SIZE as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getNotificationDispatchQueueSize() throws MgmtException;

    /**
     * Set the attribute for NOTIFICATION_DISPATCH_QUEUE_SIZE to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setNotificationDispatchQueueSize(int value) throws MgmtException;

    /**
     * Get the attribute metadata for NOTIFICATION_DISPATCH_QUEUE_SIZE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getNotificationDispatchQueueSizeMetaData() throws MgmtException;

    /**
     * Inner class representing MonitoringType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMonitoringType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for STATUS_POLL_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getStatusPollTimeout() throws MgmtException;

        /**
         * Set the attribute for STATUS_POLL_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setStatusPollTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for STATUS_POLL_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getStatusPollTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for STATUS_POLL_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getStatusPollInterval() throws MgmtException;

        /**
         * Set the attribute for STATUS_POLL_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setStatusPollInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for STATUS_POLL_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getStatusPollIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing CacheType
     * This class extends IMgmtListBase
     */
    public interface IAbstractCacheType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPassword() throws MgmtException;

        /**
         * Get the attribute for PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for CACHE_DIRECTORY as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getCacheDirectory() throws MgmtException;

        /**
         * Set the attribute for CACHE_DIRECTORY to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCacheDirectory(String value) throws MgmtException;

        /**
         * Get the attribute metadata for CACHE_DIRECTORY.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCacheDirectoryMetaData() throws MgmtException;

        /**
         * Get the attribute for PERSISTENT_BLOB_CACHE_SIZE as a long value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The long value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public long getPersistentBlobCacheSize() throws MgmtException;

        /**
         * Get the attribute for PERSISTENT_BLOB_CACHE_SIZE as a long value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The long value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public long getPersistentBlobCacheSize(long defValue) throws MgmtException;

        /**
         * Set the attribute for PERSISTENT_BLOB_CACHE_SIZE to the specified long value.
         * @param value The long value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPersistentBlobCacheSize(long value) throws MgmtException;

        /**
         * Get the attribute metadata for PERSISTENT_BLOB_CACHE_SIZE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPersistentBlobCacheSizeMetaData() throws MgmtException;

        /**
         * Get the attribute for MAXIMUM_DATA_MEMORY as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getMaximumDataMemory() throws MgmtException;

        /**
         * Set the attribute for MAXIMUM_DATA_MEMORY to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setMaximumDataMemory(int value) throws MgmtException;

        /**
         * Get the attribute metadata for MAXIMUM_DATA_MEMORY.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getMaximumDataMemoryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ComponentsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractComponentsType extends IMgmtMapBase
    {

        /**
         * Get the IContainerBean.IStartupParams atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerBean.IStartupParams value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IStartupParams getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerBean.IStartupParams attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerBean.IStartupParams bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IStartupParams createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerBean.IStartupParams into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerBean.IStartupParams value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerBean.IStartupParams value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing MetricsCollectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMetricsCollectionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for REFRESH_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRefreshInterval() throws MgmtException;

        /**
         * Set the attribute for REFRESH_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRefreshInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REFRESH_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException;

        /**
         * Get the attribute for REPEAT_ALERT_NOTIFICATIONS as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getRepeatAlertNotifications() throws MgmtException;

        /**
         * Set the attribute for REPEAT_ALERT_NOTIFICATIONS to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRepeatAlertNotifications(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for REPEAT_ALERT_NOTIFICATIONS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException;

        /**
         * Get the attribute for COLLECTION_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCollectionInterval() throws MgmtException;

        /**
         * Set the attribute for COLLECTION_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCollectionInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for COLLECTION_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing SystemPropertiesType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractSystemPropertiesType extends IMgmtMapBase
    {

        /**
         * Get the String atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getEntry(String name) throws MgmtException;

        /**
         * Add the new Entry of type String into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The String value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, String value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing EnabledMetricsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractEnabledMetricsType extends IMgmtMapBase
    {

        /**
         * Get the String atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getEntry(String name) throws MgmtException;

        /**
         * Add the new Entry of type String into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The String value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, String value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing EnabledAlertsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractEnabledAlertsType extends IMgmtMapBase
    {

        /**
         * Get the IContainerBean.IEnabledAlertParams atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerBean.IEnabledAlertParams value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IEnabledAlertParams getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerBean.IEnabledAlertParams attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerBean.IEnabledAlertParams bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IEnabledAlertParams createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerBean.IEnabledAlertParams into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerBean.IEnabledAlertParams value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerBean.IEnabledAlertParams value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }


    /**
     * Inner class representing EnabledAlertParams
     * This class extends IMgmtListBase
     */
    public interface IAbstractEnabledAlertParams extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for LOW_THRESHOLDS as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getLowThresholds() throws MgmtException;

        /**
         * Get the attribute for LOW_THRESHOLDS as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getLowThresholds(String defValue) throws MgmtException;

        /**
         * Set the attribute for LOW_THRESHOLDS to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setLowThresholds(String value) throws MgmtException;

        /**
         * Get the attribute metadata for LOW_THRESHOLDS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getLowThresholdsMetaData() throws MgmtException;

        /**
         * Get the attribute for HIGH_THRESHOLDS as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getHighThresholds() throws MgmtException;

        /**
         * Get the attribute for HIGH_THRESHOLDS as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getHighThresholds(String defValue) throws MgmtException;

        /**
         * Set the attribute for HIGH_THRESHOLDS to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setHighThresholds(String value) throws MgmtException;

        /**
         * Get the attribute metadata for HIGH_THRESHOLDS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getHighThresholdsMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ExtensionsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractExtensionsType extends IMgmtMapBase
    {

        /**
         * Get the IContainerBean.IExtensionType atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerBean.IExtensionType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IExtensionType getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerBean.IExtensionType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerBean.IExtensionType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IExtensionType createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerBean.IExtensionType into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerBean.IExtensionType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerBean.IExtensionType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }


    /**
     * Inner class representing CentralConnectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractCentralConnectionType extends IMgmtSubBeanBase
    {
        /**
         * Get the attribute for SOCKET_CONNECT_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getSocketConnectTimeout() throws MgmtException;

        /**
         * Set the attribute for SOCKET_CONNECT_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setSocketConnectTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for SOCKET_CONNECT_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getSocketConnectTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for LoadBalancing as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getLoadBalancing() throws MgmtException;

        /**
         * Set the attribute for LoadBalancing to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setLoadBalancing(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for LoadBalancing.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getLoadBalancingMetaData() throws MgmtException;

        /**
         * Get the attribute for REQUEST_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRequestTimeout() throws MgmtException;

        /**
         * Set the attribute for REQUEST_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRequestTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REQUEST_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRequestTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for ConnectionURLs as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getConnectionURLs() throws MgmtException;

        /**
         * Set the attribute for ConnectionURLs to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setConnectionURLs(String value) throws MgmtException;

        /**
         * Get the attribute metadata for ConnectionURLs.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getConnectionURLsMetaData() throws MgmtException;

        /**
         * Get the attribute for DefaultPassword as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDefaultPassword() throws MgmtException;

        /**
         * Get the attribute for DefaultPassword as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDefaultPassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for DefaultPassword to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDefaultPassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for DefaultPassword.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getDefaultPasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for DefaultUser as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDefaultUser() throws MgmtException;

        /**
         * Get the attribute for DefaultUser as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getDefaultUser(String defValue) throws MgmtException;

        /**
         * Set the attribute for DefaultUser to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDefaultUser(String value) throws MgmtException;

        /**
         * Get the attribute metadata for DefaultUser.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getDefaultUserMetaData() throws MgmtException;

        /**
         * Get the attribute for CONNECT_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getConnectTimeout() throws MgmtException;

        /**
         * Set the attribute for CONNECT_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setConnectTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for CONNECT_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getConnectTimeoutMetaData() throws MgmtException;
    }


    /**
     * Inner class representing FaultToleranceType
     * This class extends IMgmtListBase
     */
    public interface IAbstractFaultToleranceType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for FAULT_TOLERANCE_PEER_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getFaultTolerancePeerRef() throws MgmtException;

        /**
         * Get the attribute for FAULT_TOLERANCE_PEER_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getFaultTolerancePeerRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for FAULT_TOLERANCE_PEER_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFaultTolerancePeerRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for FAULT_TOLERANCE_PEER_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFaultTolerancePeerRefMetaData() throws MgmtException;

        /**
         * Get the attribute for FAULT_DETECTION_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFaultDetectionTimeout() throws MgmtException;

        /**
         * Set the attribute for FAULT_DETECTION_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFaultDetectionTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for FAULT_DETECTION_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFaultDetectionTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for FAULT_TOLERANCE_ROLE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFaultToleranceRole() throws MgmtException;

        /**
         * Set the attribute for FAULT_TOLERANCE_ROLE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFaultToleranceRole(String value) throws MgmtException;

        /**
         * Get the attribute metadata for FAULT_TOLERANCE_ROLE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFaultToleranceRoleMetaData() throws MgmtException;

        /**
         * Get the attribute for START_ACTIVE as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getStartActive() throws MgmtException;

        /**
         * Set the attribute for START_ACTIVE to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setStartActive(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for START_ACTIVE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getStartActiveMetaData() throws MgmtException;

        /**
         * Get the attribute for FAULT_DETECTION_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFaultDetectionInterval() throws MgmtException;

        /**
         * Set the attribute for FAULT_DETECTION_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFaultDetectionInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for FAULT_DETECTION_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFaultDetectionIntervalMetaData() throws MgmtException;
        /**
         * Get the attribute for FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFailureDetectionSocketConnectTimeout() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFailureDetectionSocketConnectTimeout(int defValue) throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionSocketConnectTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionSocketConnectTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_DEFAULT_USER as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionDefaultUser() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_DEFAULT_USER as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionDefaultUser(String defValue) throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_DEFAULT_USER to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionDefaultUser(String value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_DEFAULT_USER.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionDefaultUserMetaData() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_CONNECTIONURLS as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionConnectionurls() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_CONNECTIONURLS as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionConnectionurls(String defValue) throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_CONNECTIONURLS to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionConnectionurls(String value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_CONNECTIONURLS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionConnectionurlsMetaData() throws MgmtException;


        /**
         * Get the attribute for FAILURE_DETECTION_CONNECT_TIMEOUT as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFailureDetectionConnectTimeout() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_CONNECT_TIMEOUT as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFailureDetectionConnectTimeout(int defValue) throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_CONNECT_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionConnectTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_CONNECT_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionConnectTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_DEFAULT_PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionDefaultPassword() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_DEFAULT_PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getFailureDetectionDefaultPassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_DEFAULT_PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionDefaultPassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_DEFAULT_PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionDefaultPasswordMetaData() throws MgmtException;

        
    }

    /**
     * Inner class representing ConnectionType
     * This has been manually modified to extend IAbstractCentralConnectionType instead of IMgmtListBase.
     * This was done as the connection and central connection have same fields
     * except for MANAGEMENT_NODE is missing in central connection.
     * This class extends IAbstractCentralConnectionType
     */
    public interface IAbstractConnectionType extends IAbstractCentralConnectionType
    {

        /**
         * Get the attribute for MANAGEMENT_NODE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getManagementNode() throws MgmtException;

        /**
         * Get the attribute for MANAGEMENT_NODE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getManagementNode(String defValue) throws MgmtException;

        /**
         * Set the attribute for MANAGEMENT_NODE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setManagementNode(String value) throws MgmtException;

        /**
         * Get the attribute metadata for MANAGEMENT_NODE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getManagementNodeMetaData() throws MgmtException;
    }

    /**
     * Inner class representing StartupParams
     * This class extends IMgmtListBase
     */
    public interface IAbstractStartupParams extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for NATIVE_LIBRARIES.
         * @return The ILibrariesType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.ILibrariesType getNativeLibraries() throws MgmtException;

        /**
         * Set the attribute for NATIVE_LIBRARIES to the specified ILibrariesType value.
         * @param value The ILibrariesType value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setNativeLibraries(IContainerBean.ILibrariesType value) throws MgmtException;

        /**
         * Create an instance of an ILibrariesType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setNativeLibraries method.
         * @return The new ILibrariesType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.ILibrariesType createNativeLibraries() throws MgmtException;

        /**
         * Get the attribute metadata for NATIVE_LIBRARIES.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getNativeLibrariesMetaData() throws MgmtException;

        /**
         * Get the attribute for AUTO_START as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getAutoStart() throws MgmtException;

        /**
         * Set the attribute for AUTO_START to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setAutoStart(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for AUTO_START.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getAutoStartMetaData() throws MgmtException;

        /**
         * Get the attribute for TRACE_MASK as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getTraceMask() throws MgmtException;

        /**
         * Set the attribute for TRACE_MASK to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setTraceMask(int value) throws MgmtException;

        /**
         * Get the attribute metadata for TRACE_MASK.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException;

        /**
         * Get the attribute for CONFIG_REF as a IMgmtBeanBase value.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getConfigRef() throws MgmtException;

        /**
         * Set the attribute for CONFIG_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for CONFIG_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException;

        /**
         * Get the attribute for DEPLOYMENT_PARAMETERS.
         * @return The IDeploymentParametersSet value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IDeploymentParametersSet getDeploymentParameters() throws MgmtException;

        /**
         * Set the attribute for DEPLOYMENT_PARAMETERS to the specified IDeploymentParametersSet value.
         * @param value The IDeploymentParametersSet value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDeploymentParameters(IContainerBean.IDeploymentParametersSet value) throws MgmtException;

        /**
         * Create an instance of an IDeploymentParametersSet attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setDeploymentParameters method.
         * @return The new IDeploymentParametersSet bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IDeploymentParametersSet createDeploymentParameters() throws MgmtException;

        /**
         * Get the attribute metadata for DEPLOYMENT_PARAMETERS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getDeploymentParametersMetaData() throws MgmtException;

        /**
         * Get the attribute for ENABLED_ALERTS.
         * @return The IEnabledAlertsType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IEnabledAlertsType getEnabledAlerts() throws MgmtException;

        /**
         * Set the attribute for ENABLED_ALERTS to the specified IEnabledAlertsType value.
         * @param value The IEnabledAlertsType value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setEnabledAlerts(IContainerBean.IEnabledAlertsType value) throws MgmtException;

        /**
         * Create an instance of an IEnabledAlertsType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setEnabledAlerts method.
         * @return The new IEnabledAlertsType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IEnabledAlertsType createEnabledAlerts() throws MgmtException;

        /**
         * Get the attribute metadata for ENABLED_ALERTS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEnabledAlertsMetaData() throws MgmtException;

        /**
         * Get the attribute for ENABLED_METRICS.
         * @return The IEnabledMetricsType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IEnabledMetricsType getEnabledMetrics() throws MgmtException;

        /**
         * Set the attribute for ENABLED_METRICS to the specified IEnabledMetricsType value.
         * @param value The IEnabledMetricsType value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setEnabledMetrics(IContainerBean.IEnabledMetricsType value) throws MgmtException;

        /**
         * Create an instance of an IEnabledMetricsType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setEnabledMetrics method.
         * @return The new IEnabledMetricsType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IEnabledMetricsType createEnabledMetrics() throws MgmtException;

        /**
         * Get the attribute metadata for ENABLED_METRICS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEnabledMetricsMetaData() throws MgmtException;

    }

    /**
     * Inner class representing ExtensionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractExtensionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for EXTENSION_ACTIVE as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getExtensionActive() throws MgmtException;

        /**
         * Set the attribute for EXTENSION_ACTIVE to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setExtensionActive(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for EXTENSION_ACTIVE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getExtensionActiveMetaData() throws MgmtException;

        /**
         * Get the attribute for EXTENSION_CONFIG_REF as a IMgmtBeanBase value.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getExtensionConfigRef() throws MgmtException;

        /**
         * Set the attribute for EXTENSION_CONFIG_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setExtensionConfigRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for EXTENSION_CONFIG_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getExtensionConfigRefMetaData() throws MgmtException;
    }

    /**
     * Inner class representing LibrariesType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractLibrariesType extends IMgmtMapBase
    {

        /**
         * Get the IContainerBean.ILibraryParams atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerBean.ILibraryParams value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.ILibraryParams getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerBean.ILibraryParams attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerBean.ILibraryParams bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.ILibraryParams createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerBean.ILibraryParams into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerBean.ILibraryParams value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerBean.ILibraryParams value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing DeploymentParametersSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractDeploymentParametersSet extends IMgmtMapBase
    {

        /**
         * Get the IContainerBean.IDeploymentParameterType atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerBean.IDeploymentParameterType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerBean.IDeploymentParameterType getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerBean.IDeploymentParameterType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerBean.IDeploymentParameterType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerBean.IDeploymentParameterType createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerBean.IDeploymentParameterType into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerBean.IDeploymentParameterType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerBean.IDeploymentParameterType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing LibraryParams
     * This class extends IMgmtListBase
     */
    public interface IAbstractLibraryParams extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for NATIVE_LIBRARY_PATH as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getNativeLibraryPath() throws MgmtException;

        /**
         * Set the attribute for NATIVE_LIBRARY_PATH to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setNativeLibraryPath(String value) throws MgmtException;

        /**
         * Get the attribute metadata for NATIVE_LIBRARY_PATH.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getNativeLibraryPathMetaData() throws MgmtException;
    }

    /**
     * Inner class representing DeploymentParameterType
     * This class extends IMgmtListBase
     */
    public interface IAbstractDeploymentParameterType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for VALUE as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getValue() throws MgmtException;

        /**
         * Set the attribute for VALUE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setValue(String value) throws MgmtException;

        /**
         * Get the attribute metadata for VALUE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getValueMetaData() throws MgmtException;
    }
}
