/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IContainerCollectionBean;

/**
 * Configuration Bean representing a 'ContainerCollection'
 */
public interface IAbstractContainerCollectionBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for CONTAINERS.
     * @return The IContainersSet value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IContainerCollectionBean.IContainersSet getContainers() throws MgmtException;

    /**
     * Get the attribute metadata for CONTAINERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getContainersMetaData() throws MgmtException;

    /**
     * Inner class representing ContainersSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractContainersSet extends IMgmtMapBase
    {

        /**
         * Get the IContainerCollectionBean.IContainer atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IContainerCollectionBean.IContainer value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IContainerCollectionBean.IContainer getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IContainerCollectionBean.IContainer attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IContainerCollectionBean.IContainer bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IContainerCollectionBean.IContainer createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IContainerCollectionBean.IContainer into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IContainerCollectionBean.IContainer value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IContainerCollectionBean.IContainer value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing Container
     * This class extends IMgmtListBase
     */
    public interface IAbstractContainer extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for CONTAINER_RUNTIME_ID as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getContainerRuntimeId() throws MgmtException;

        /**
         * Set the attribute for CONTAINER_RUNTIME_ID to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setContainerRuntimeId(String value) throws MgmtException;

        /**
         * Get the attribute metadata for CONTAINER_RUNTIME_ID.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getContainerRuntimeIdMetaData() throws MgmtException;

        /**
         * Get the attribute for CONFIG_REF as a IMgmtBeanBase value.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getConfigRef() throws MgmtException;

        /**
         * Set the attribute for CONFIG_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for CONFIG_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException;
    }
}
