/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;

/**
 * Configuration Bean representing a 'DirectoryService'
 */
public interface IAbstractDirectoryServiceBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for REPLICATION_PARAMETERS.
     * @return The IReplicationParametersType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IDirectoryServiceBean.IReplicationParametersType getReplicationParameters() throws MgmtException;

    /**
     * Set the attribute for REPLICATION_PARAMETERS to the specified IReplicationParametersType value.
     * @param value The IReplicationParametersType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setReplicationParameters(IDirectoryServiceBean.IReplicationParametersType value) throws MgmtException;

    /**
     * Create an instance of an IReplicationParametersType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setReplicationParameters method.
     * @return The new IReplicationParametersType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public IDirectoryServiceBean.IReplicationParametersType createReplicationParameters() throws MgmtException;

    /**
     * Get the attribute metadata for REPLICATION_PARAMETERS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getReplicationParametersMetaData() throws MgmtException;

    /**
     * Get the attribute for CONFIG_ELEMENT_REFERENCES.
     * @return The IDsReferencesType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IDirectoryServiceBean.IDsReferencesType getConfigElementReferences() throws MgmtException;

    /**
     * Get the attribute metadata for CONFIG_ELEMENT_REFERENCES.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException;

    /**
     * Get the attribute for HOST_DIRECTORY as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getHostDirectory() throws MgmtException;

    /**
     * Set the attribute for HOST_DIRECTORY to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setHostDirectory(String value) throws MgmtException;

    /**
     * Get the attribute metadata for HOST_DIRECTORY.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getHostDirectoryMetaData() throws MgmtException;

    /**
     * Get the attribute for FILE_SYSTEM_STORAGE.
     * @return The IStorageType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IDirectoryServiceBean.IStorageType getFileSystemStorage() throws MgmtException;

    /**
     * Get the attribute metadata for FILE_SYSTEM_STORAGE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getFileSystemStorageMetaData() throws MgmtException;

    /**
     * Get the attribute for TRACE_MASK as a int value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getTraceMask() throws MgmtException;

    /**
     * Get the attribute for TRACE_MASK as a int value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getTraceMask(int defValue) throws MgmtException;

    /**
     * Set the attribute for TRACE_MASK to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setTraceMask(int value) throws MgmtException;

    /**
     * Get the attribute metadata for TRACE_MASK.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException;

    /**
     * Get the attribute for DOMAIN_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getDomainName() throws MgmtException;

    /**
     * Set the attribute for DOMAIN_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setDomainName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for DOMAIN_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException;

    /**
     * Inner class representing ReplicationParametersType
     * This class extends IMgmtListBase
     */
    public interface IAbstractReplicationParametersType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for DUAL_ACTIVE_RESOLUTION as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getDualActiveResolution() throws MgmtException;

        /**
         * Set the attribute for DUAL_ACTIVE_RESOLUTION to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setDualActiveResolution(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for DUAL_ACTIVE_RESOLUTION.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getDualActiveResolutionMetaData() throws MgmtException;

        /**
         * Get the attribute for PING_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getPingInterval() throws MgmtException;

        /**
         * Set the attribute for PING_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPingInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for PING_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPingIntervalMetaData() throws MgmtException;

        /**
         * Get the attribute for FAILURE_DETECTION_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getFailureDetectionTimeout() throws MgmtException;

        /**
         * Set the attribute for FAILURE_DETECTION_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setFailureDetectionTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for FAILURE_DETECTION_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getFailureDetectionTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for MAX_REPLICATION_LOG_SIZE as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getMaxReplicationLogSize() throws MgmtException;

        /**
         * Set the attribute for MAX_REPLICATION_LOG_SIZE to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setMaxReplicationLogSize(int value) throws MgmtException;

        /**
         * Get the attribute metadata for MAX_REPLICATION_LOG_SIZE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getMaxReplicationLogSizeMetaData() throws MgmtException;

        /**
         * Get the attribute for REPLICATION_TIMEOUT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getReplicationTimeout() throws MgmtException;

        /**
         * Set the attribute for REPLICATION_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setReplicationTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REPLICATION_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getReplicationTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_FAILOVER_READ_ONLY as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getBackupFailoverReadOnly() throws MgmtException;

        /**
         * Set the attribute for BACKUP_FAILOVER_READ_ONLY to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupFailoverReadOnly(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_FAILOVER_READ_ONLY.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupFailoverReadOnlyMetaData() throws MgmtException;

        /**
         * Get the attribute for SSL_PARAMETERS.
         * @return The ISslParametersType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IDirectoryServiceBean.ISslParametersType getSslParameters() throws MgmtException;

        /**
         * Set the attribute for SSL_PARAMETERS to the specified ISslParametersType value.
         * @param value The ISslParametersType value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setSslParameters(IDirectoryServiceBean.ISslParametersType value) throws MgmtException;

        /**
         * Create an instance of an ISslParametersType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using the setSslParameters method.
         * @return The new ISslParametersType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IDirectoryServiceBean.ISslParametersType createSslParameters() throws MgmtException;

        /**
         * Get the attribute metadata for SSL_PARAMETERS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getSslParametersMetaData() throws MgmtException;

        /**
         * Get the attribute for RETRY_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRetryInterval() throws MgmtException;

        /**
         * Set the attribute for RETRY_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRetryInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for RETRY_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRetryIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing DsReferencesType
     * This class extends IMgmtListBase
     */
    public interface IAbstractDsReferencesType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for BACKUP_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getBackupConfigElementRef() throws MgmtException;

        /**
         * Get the attribute for BACKUP_CONFIG_ELEMENT_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getBackupConfigElementRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_CONFIG_ELEMENT_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupConfigElementRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_CONFIG_ELEMENT_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupConfigElementRefMetaData() throws MgmtException;

        /**
         * Get the attribute for REPLICATION_CONNECTIONS_ELEMENT_REF as a IMgmtBeanBase value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getReplicationConnectionsElementRef() throws MgmtException;

        /**
         * Get the attribute for REPLICATION_CONNECTIONS_ELEMENT_REF as a IMgmtBeanBase value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getReplicationConnectionsElementRef(IMgmtBeanBase defValue) throws MgmtException;

        /**
         * Set the attribute for REPLICATION_CONNECTIONS_ELEMENT_REF to the specified IMgmtBeanBase value.
         * @param value The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setReplicationConnectionsElementRef(IMgmtBeanBase value) throws MgmtException;

        /**
         * Get the attribute metadata for REPLICATION_CONNECTIONS_ELEMENT_REF.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getReplicationConnectionsElementRefMetaData() throws MgmtException;
    }

    /**
     * Inner class representing StorageType
     * This class extends IMgmtListBase
     */
    public interface IAbstractStorageType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPassword() throws MgmtException;

        /**
         * Get the attribute for PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException;
    }

    /**
     * Inner class representing SslParametersType
     * This class extends IMgmtListBase
     */
    public interface IAbstractSslParametersType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for BACKUP_KEY_STORE_PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupKeyStorePassword() throws MgmtException;

        /**
         * Get the attribute for BACKUP_KEY_STORE_PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupKeyStorePassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_KEY_STORE_PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupKeyStorePassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_KEY_STORE_PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupKeyStorePasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_TRUST_STORE_PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryTrustStorePassword() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_TRUST_STORE_PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryTrustStorePassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_TRUST_STORE_PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryTrustStorePassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_TRUST_STORE_PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryTrustStorePasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for HANDSHAKE_TIMEOUT as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getHandshakeTimeout() throws MgmtException;

        /**
         * Get the attribute for HANDSHAKE_TIMEOUT as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getHandshakeTimeout(int defValue) throws MgmtException;

        /**
         * Set the attribute for HANDSHAKE_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setHandshakeTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for HANDSHAKE_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getHandshakeTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_KEY_STORE_PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryKeyStorePassword() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_KEY_STORE_PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryKeyStorePassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_KEY_STORE_PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryKeyStorePassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_KEY_STORE_PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryKeyStorePasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_KEY_STORE_FILE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryKeyStoreFile() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_KEY_STORE_FILE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryKeyStoreFile(String defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_KEY_STORE_FILE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryKeyStoreFile(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_KEY_STORE_FILE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryKeyStoreFileMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_TRUST_STORE_PASSWORD as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupTrustStorePassword() throws MgmtException;

        /**
         * Get the attribute for BACKUP_TRUST_STORE_PASSWORD as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupTrustStorePassword(String defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_TRUST_STORE_PASSWORD to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupTrustStorePassword(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_TRUST_STORE_PASSWORD.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupTrustStorePasswordMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_TRUST_STORE_FILE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupTrustStoreFile() throws MgmtException;

        /**
         * Get the attribute for BACKUP_TRUST_STORE_FILE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupTrustStoreFile(String defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_TRUST_STORE_FILE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupTrustStoreFile(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_TRUST_STORE_FILE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupTrustStoreFileMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_KEY_STORE_FILE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupKeyStoreFile() throws MgmtException;

        /**
         * Get the attribute for BACKUP_KEY_STORE_FILE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupKeyStoreFile(String defValue) throws MgmtException;

        /**
         * Set the attribute for BACKUP_KEY_STORE_FILE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupKeyStoreFile(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_KEY_STORE_FILE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupKeyStoreFileMetaData() throws MgmtException;

        /**
         * Get the attribute for CLOSE_TIMEOUT as a int value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCloseTimeout() throws MgmtException;

        /**
         * Get the attribute for CLOSE_TIMEOUT as a int value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCloseTimeout(int defValue) throws MgmtException;

        /**
         * Set the attribute for CLOSE_TIMEOUT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCloseTimeout(int value) throws MgmtException;

        /**
         * Get the attribute metadata for CLOSE_TIMEOUT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCloseTimeoutMetaData() throws MgmtException;

        /**
         * Get the attribute for CIPHER_SUITE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getCipherSuite() throws MgmtException;

        /**
         * Get the attribute for CIPHER_SUITE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getCipherSuite(String defValue) throws MgmtException;

        /**
         * Set the attribute for CIPHER_SUITE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCipherSuite(String value) throws MgmtException;

        /**
         * Get the attribute metadata for CIPHER_SUITE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCipherSuiteMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_TRUST_STORE_FILE as a String value.
         * This is an optional attribute and a MgmtException will be
         * thrown if the attribute does not exist.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryTrustStoreFile() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_TRUST_STORE_FILE as a String value.
         * If the attribute doesn't exist then return the specified default value.
         * @param defValue The default value to return if this attribute doesn't exist
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryTrustStoreFile(String defValue) throws MgmtException;

        /**
         * Set the attribute for PRIMARY_TRUST_STORE_FILE to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryTrustStoreFile(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_TRUST_STORE_FILE.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryTrustStoreFileMetaData() throws MgmtException;
    }
}
