/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

/**
 * Configuration Bean representing a 'Domain'
 */
public interface IAbstractDomainBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for AUDIT_CONFIGURE_EVENTS as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getAuditConfigureEvents() throws MgmtException;

    /**
     * Set the attribute for AUDIT_CONFIGURE_EVENTS to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setAuditConfigureEvents(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for AUDIT_CONFIGURE_EVENTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getAuditConfigureEventsMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE_ROLLOVER_SIZE_THRESHOLD as a long value.
     * @return The long value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public long getLogFileRolloverSizeThreshold() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_ROLLOVER_SIZE_THRESHOLD to the specified long value.
     * @param value The long value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileRolloverSizeThreshold(long value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_ROLLOVER_SIZE_THRESHOLD.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileRolloverSizeThresholdMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE_ROLLOVER_TIME_INTERVAL as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getLogFileRolloverTimeInterval() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_ROLLOVER_TIME_INTERVAL to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileRolloverTimeInterval(int value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_ROLLOVER_TIME_INTERVAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileRolloverTimeIntervalMetaData() throws MgmtException;

    /**
     * Get the attribute for FORCE_CENTRALIZED_LOGGING as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getForceCentralizedLogging() throws MgmtException;

    /**
     * Set the attribute for FORCE_CENTRALIZED_LOGGING to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setForceCentralizedLogging(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for FORCE_CENTRALIZED_LOGGING.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getForceCentralizedLoggingMetaData() throws MgmtException;

    /**
     * Get the attribute for ENABLE_CENTRALIZED_AUDIT as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getEnableCentralizedAudit() throws MgmtException;

    /**
     * Set the attribute for ENABLE_CENTRALIZED_AUDIT to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setEnableCentralizedAudit(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for ENABLE_CENTRALIZED_AUDIT.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getEnableCentralizedAuditMetaData() throws MgmtException;

    /**
     * Get the attribute for CENTRALIZED_LOG_FILE as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getCentralizedLogFile() throws MgmtException;

    /**
     * Get the attribute for CENTRALIZED_LOG_FILE as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getCentralizedLogFile(String defValue) throws MgmtException;

    /**
     * Set the attribute for CENTRALIZED_LOG_FILE to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setCentralizedLogFile(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CENTRALIZED_LOG_FILE.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getCentralizedLogFileMetaData() throws MgmtException;

    /**
     * Get the attribute for DEFAULT_MANAGEMENT_AUDIT_CONFIG as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getDefaultManagementAuditConfig() throws MgmtException;

    /**
     * Set the attribute for DEFAULT_MANAGEMENT_AUDIT_CONFIG to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setDefaultManagementAuditConfig(String value) throws MgmtException;

    /**
     * Get the attribute metadata for DEFAULT_MANAGEMENT_AUDIT_CONFIG.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getDefaultManagementAuditConfigMetaData() throws MgmtException;

    /**
     * Get the attribute for AUTHENTICATION_DOMAIN as a IMgmtBeanBase value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getAuthenticationDomain() throws MgmtException;

    /**
     * Get the attribute for AUTHENTICATION_DOMAIN as a IMgmtBeanBase value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IMgmtBeanBase getAuthenticationDomain(IMgmtBeanBase defValue) throws MgmtException;

    /**
     * Set the attribute for AUTHENTICATION_DOMAIN to the specified IMgmtBeanBase value.
     * @param value The IMgmtBeanBase value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setAuthenticationDomain(IMgmtBeanBase value) throws MgmtException;

    /**
     * Get the attribute metadata for AUTHENTICATION_DOMAIN.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getAuthenticationDomainMetaData() throws MgmtException;

    /**
     * Get the attribute for AUDIT_MANAGE_EVENTS as a boolean value.
     * @return The boolean value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public boolean getAuditManageEvents() throws MgmtException;

    /**
     * Set the attribute for AUDIT_MANAGE_EVENTS to the specified boolean value.
     * @param value The boolean value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setAuditManageEvents(boolean value) throws MgmtException;

    /**
     * Get the attribute metadata for AUDIT_MANAGE_EVENTS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getAuditManageEventsMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FILE_SIZE_THRESHOLD as a long value.
     * @return The long value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public long getLogFileSizeThreshold() throws MgmtException;

    /**
     * Set the attribute for LOG_FILE_SIZE_THRESHOLD to the specified long value.
     * @param value The long value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFileSizeThreshold(long value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FILE_SIZE_THRESHOLD.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFileSizeThresholdMetaData() throws MgmtException;
}
