/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

/**
 * Configuration Bean representing a 'HostManager'
 */
public interface IAbstractHostManagerBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;
}
