// Copyright (c) 2011 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.ILoggerBean;

/**
 * Configuration Bean representing a 'Logger'
 */
public interface IAbstractLoggerBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for CLASSNAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClassname() throws MgmtException;

    /**
     * Get the attribute metadata for CLASSNAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException;

    /**
     * Get the attribute for ARCHIVE_NAME as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getArchiveName() throws MgmtException;

    /**
     * Set the attribute for ARCHIVE_NAME to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setArchiveName(String value) throws MgmtException;

    /**
     * Get the attribute metadata for ARCHIVE_NAME.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException;

    /**
     * Get the attribute for MAX_LOOKBACK_PERIOD as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getMaxLookbackPeriod() throws MgmtException;

    /**
     * Set the attribute for MAX_LOOKBACK_PERIOD to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMaxLookbackPeriod(int value) throws MgmtException;

    /**
     * Get the attribute metadata for MAX_LOOKBACK_PERIOD.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getMaxLookbackPeriodMetaData() throws MgmtException;

    /**
     * Get the attribute for METRICS.
     * @return The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ILoggerBean.IMetricsCollectionType getMetrics() throws MgmtException;

    /**
     * Set the attribute for METRICS to the specified IMetricsCollectionType value.
     * @param value The IMetricsCollectionType value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setMetrics(ILoggerBean.IMetricsCollectionType value) throws MgmtException;

    /**
     * Create an instance of an IMetricsCollectionType attribute. This new instance
     * is not currently part of the configuration. Once it has been configured
     * it should be set into the configuration using the setMetrics method.
     * @return The new IMetricsCollectionType bean
     * @throws MgmtException Thrown if there is some problem creating this object
     */
    public ILoggerBean.IMetricsCollectionType createMetrics() throws MgmtException;

    /**
     * Get the attribute metadata for METRICS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath() throws MgmtException;

    /**
     * Get the attribute for CLASSPATH as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getClasspath(String defValue) throws MgmtException;

    /**
     * Set the attribute for CLASSPATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setClasspath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for CLASSPATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException;

    /**
     * Get the attribute for COLLECTIONS_MONITOR_RUNTIME_ID as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getCollectionsMonitorRuntimeId() throws MgmtException;

    /**
     * Set the attribute for COLLECTIONS_MONITOR_RUNTIME_ID to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setCollectionsMonitorRuntimeId(String value) throws MgmtException;

    /**
     * Get the attribute metadata for COLLECTIONS_MONITOR_RUNTIME_ID.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getCollectionsMonitorRuntimeIdMetaData() throws MgmtException;

    /**
     * Get the attribute for COMPONENT_COLLECTIONS.
     * @return The IComponentCollectionsType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public ILoggerBean.IComponentCollectionsType getComponentCollections() throws MgmtException;

    /**
     * Get the attribute metadata for COMPONENT_COLLECTIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getComponentCollectionsMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG4J_CONFIGURATION_FILE_PATH as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getLog4jConfigurationFilePath() throws MgmtException;

    /**
     * Set the attribute for LOG4J_CONFIGURATION_FILE_PATH to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLog4jConfigurationFilePath(String value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG4J_CONFIGURATION_FILE_PATH.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLog4jConfigurationFilePathMetaData() throws MgmtException;

    /**
     * Get the attribute for L0G_TEXT_DELIMITER as a String value.
     * This is an optional attribute and a MgmtException will be
     * thrown if the attribute does not exist.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getL0gTextDelimiter() throws MgmtException;

    /**
     * Get the attribute for L0G_TEXT_DELIMITER as a String value.
     * If the attribute doesn't exist then return the specified default value.
     * @param defValue The default value to return if this attribute doesn't exist
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getL0gTextDelimiter(String defValue) throws MgmtException;

    /**
     * Set the attribute for L0G_TEXT_DELIMITER to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setL0gTextDelimiter(String value) throws MgmtException;

    /**
     * Get the attribute metadata for L0G_TEXT_DELIMITER.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getL0gTextDelimiterMetaData() throws MgmtException;

    /**
     * Get the attribute for COLLECTIONS_MONITOR_POLL_INTERVAL as a int value.
     * @return The int value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public int getCollectionsMonitorPollInterval() throws MgmtException;

    /**
     * Set the attribute for COLLECTIONS_MONITOR_POLL_INTERVAL to the specified int value.
     * @param value The int value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setCollectionsMonitorPollInterval(int value) throws MgmtException;

    /**
     * Get the attribute metadata for COLLECTIONS_MONITOR_POLL_INTERVAL.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getCollectionsMonitorPollIntervalMetaData() throws MgmtException;

    /**
     * Get the attribute for LOG_FORMAT as a String value.
     * @return The String value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public String getLogFormat() throws MgmtException;

    /**
     * Set the attribute for LOG_FORMAT to the specified String value.
     * @param value The String value for this attribute
     * @throws MgmtException Thrown if there is some problem setting this attribute
     */
    public void setLogFormat(String value) throws MgmtException;

    /**
     * Get the attribute metadata for LOG_FORMAT.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute's metadata
     */
    public IMgmtAttributeMetaData getLogFormatMetaData() throws MgmtException;

    /**
     * Inner class representing MetricsCollectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractMetricsCollectionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for REFRESH_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getRefreshInterval() throws MgmtException;

        /**
         * Set the attribute for REFRESH_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRefreshInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for REFRESH_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException;

        /**
         * Get the attribute for REPEAT_ALERT_NOTIFICATIONS as a boolean value.
         * @return The boolean value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public boolean getRepeatAlertNotifications() throws MgmtException;

        /**
         * Set the attribute for REPEAT_ALERT_NOTIFICATIONS to the specified boolean value.
         * @param value The boolean value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setRepeatAlertNotifications(boolean value) throws MgmtException;

        /**
         * Get the attribute metadata for REPEAT_ALERT_NOTIFICATIONS.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException;

        /**
         * Get the attribute for COLLECTION_INTERVAL as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getCollectionInterval() throws MgmtException;

        /**
         * Set the attribute for COLLECTION_INTERVAL to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setCollectionInterval(int value) throws MgmtException;

        /**
         * Get the attribute metadata for COLLECTION_INTERVAL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ComponentCollectionsType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractComponentCollectionsType extends IMgmtMapBase
    {

        /**
         * Get the IMgmtBeanBase atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IMgmtBeanBase value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IMgmtBeanBase getEntry(String name) throws MgmtException;

        /**
         * Add the new Entry of type IMgmtBeanBase into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IMgmtBeanBase value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IMgmtBeanBase value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }
}
