/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtSubBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IReplicationConnectionBean;

/**
 * Configuration Bean representing a 'ReplicationConnection'
 */
public interface IAbstractReplicationConnectionBean extends IMgmtBeanBase
{

    /**
     * Get the attribute for REPLICATION_CONNECTIONS.
     * @return The IReplicationConnectionSetType value for this attribute
     * @throws MgmtException Thrown when this attribute doesn't exist or
     * if there is some problem obtaining this attribute
     */
    public IReplicationConnectionBean.IReplicationConnectionSetType getReplicationConnections() throws MgmtException;

    /**
     * Get the attribute metadata for REPLICATION_CONNECTIONS.
     * @return The IMgmtAttributeMetaData value for this attribute
     * @throws MgmtException Thrown when this attribute metadata doesn't exist or
     * if there is some problem obtaining this attribute metadata
     */
    public IMgmtAttributeMetaData getReplicationConnectionsMetaData() throws MgmtException;

    /**
     * Inner class representing ReplicationConnectionSetType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IMgmtMapBase
     */
    public interface IAbstractReplicationConnectionSetType extends IMgmtMapBase
    {

        /**
         * Get the IReplicationConnectionBean.IReplicationConnectionType atribute from the map with the specified key name
         * @param name The key name for this Entry within the Map
         * @return The IReplicationConnectionBean.IReplicationConnectionType value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public IReplicationConnectionBean.IReplicationConnectionType getEntry(String name) throws MgmtException;

        /**
         * Create an instance of an IReplicationConnectionBean.IReplicationConnectionType attribute. This new instance
         * is not currently part of the configuration. Once it has been configured
         * it should be set into the configuration using either the addEntry
         * or insertEntry methods
         * @return The new IReplicationConnectionBean.IReplicationConnectionType bean
         * @throws MgmtException Thrown if there is some problem creating this object
         */
        public IReplicationConnectionBean.IReplicationConnectionType createEntry() throws MgmtException;

        /**
         * Add the new Entry of type IReplicationConnectionBean.IReplicationConnectionType into this map keyed
         * off the specified key name
         * @param name The key name for this Entry in the map
         * @param value The IReplicationConnectionBean.IReplicationConnectionType value to add to the map
         * @throws MgmtException Thrown if there is some problem adding this item to the map
         */
        public void addEntry(String name, IReplicationConnectionBean.IReplicationConnectionType value) throws MgmtException;

        /**
         * Delete the item with the specified name from this map
         * @param name The key name for the item in the map
         * @throws MgmtException Thrown if there is some problem deleting this item from the map
         */
        public void deleteEntry(String name) throws MgmtException;

        /**
         * Get the attribute metadata for entry.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute metadata doesn't exist or
         * if there is some problem obtaining this attribute metadata
         */
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException;
    }

    /**
     * Inner class representing ReplicationConnectionType
     * This class extends IMgmtListBase
     */
    public interface IAbstractReplicationConnectionType extends IMgmtSubBeanBase
    {

        /**
         * Get the attribute for WEIGHT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getWeight() throws MgmtException;

        /**
         * Set the attribute for WEIGHT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setWeight(int value) throws MgmtException;

        /**
         * Get the attribute metadata for WEIGHT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getWeightMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_ADDR as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getBackupAddr() throws MgmtException;

        /**
         * Set the attribute for BACKUP_ADDR to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupAddr(String value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_ADDR.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupAddrMetaData() throws MgmtException;

        /**
         * Get the attribute for BACKUP_PORT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getBackupPort() throws MgmtException;

        /**
         * Set the attribute for BACKUP_PORT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setBackupPort(int value) throws MgmtException;

        /**
         * Get the attribute metadata for BACKUP_PORT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getBackupPortMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_ADDR as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getPrimaryAddr() throws MgmtException;

        /**
         * Set the attribute for PRIMARY_ADDR to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryAddr(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_ADDR.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryAddrMetaData() throws MgmtException;

        /**
         * Get the attribute for PROTOCOL as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getProtocol() throws MgmtException;

        /**
         * Set the attribute for PROTOCOL to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setProtocol(String value) throws MgmtException;

        /**
         * Get the attribute metadata for PROTOCOL.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getProtocolMetaData() throws MgmtException;

        /**
         * Get the attribute for NAME as a String value.
         * @return The String value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public String getName() throws MgmtException;

        /**
         * Set the attribute for NAME to the specified String value.
         * @param value The String value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setName(String value) throws MgmtException;

        /**
         * Get the attribute metadata for NAME.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getNameMetaData() throws MgmtException;

        /**
         * Get the attribute for PRIMARY_PORT as a int value.
         * @return The int value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute
         */
        public int getPrimaryPort() throws MgmtException;

        /**
         * Set the attribute for PRIMARY_PORT to the specified int value.
         * @param value The int value for this attribute
         * @throws MgmtException Thrown if there is some problem setting this attribute
         */
        public void setPrimaryPort(int value) throws MgmtException;

        /**
         * Get the attribute metadata for PRIMARY_PORT.
         * @return The IMgmtAttributeMetaData value for this attribute
         * @throws MgmtException Thrown when this attribute doesn't exist or
         * if there is some problem obtaining this attribute's metadata
         */
        public IMgmtAttributeMetaData getPrimaryPortMetaData() throws MgmtException;
    }
}
