/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IActivationDaemonBean;
import com.sonicsw.mf.mgmtapi.config.constants.IActivationDaemonConstants;
import com.sonicsw.mf.mgmtapi.config.impl.ActivationDaemonBean;

public abstract class AbstractActivationDaemonBean
extends MgmtBeanBase implements IActivationDaemonConstants, IActivationDaemonBean
{
    public AbstractActivationDaemonBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public IActivationDaemonBean.IContainersSet getContainers() throws MgmtException
    {
        return new ActivationDaemonBean.ContainersSet(this, CONTAINERS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getContainersMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONTAINERS_ATTR);
    }

    public static class AbstractContainersSet
    extends MgmtMapBase implements IAbstractContainersSet
    {
        public AbstractContainersSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IActivationDaemonBean.IChildType getContainer(String name) throws MgmtException
        {
            return new ActivationDaemonBean.ChildType(this, name, false);
        }

        @Override
        public IActivationDaemonBean.IChildType createContainer() throws MgmtException
        {
            return new ActivationDaemonBean.ChildType(this, CONTAINER_ATTR, true);
        }

        @Override
        public void addContainer(String name, IActivationDaemonBean.IChildType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteContainer(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getContainerMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONTAINER_ATTR);
        }
    }

    public static class AbstractChildType
    extends MgmtSubBeanBase implements IAbstractChildType
    {
        public AbstractChildType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IActivationDaemonBean.IScheduleList getSchedules() throws MgmtException
        {
            return new ActivationDaemonBean.ScheduleList(this, SCHEDULES_ATTR, false);
        }

        @Override
        public void setSchedules(IActivationDaemonBean.IScheduleList value) throws MgmtException
        {
            super.setAttribute(SCHEDULES_ATTR, value);
        }

        @Override
        public IActivationDaemonBean.IScheduleList createSchedules() throws MgmtException
        {
            return new ActivationDaemonBean.ScheduleList(this, SCHEDULES_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getSchedulesMetaData() throws MgmtException
        {
            return getAttributeMetaData(SCHEDULES_ATTR);
        }

        @Override
        public long getRetryIntervalSeconds() throws MgmtException
        {
            return getLongAttribute(RETRY_INTERVAL_SECONDS_ATTR);
        }

        @Override
        public void setRetryIntervalSeconds(long value) throws MgmtException
        {
            setLongAttribute(RETRY_INTERVAL_SECONDS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRetryIntervalSecondsMetaData() throws MgmtException
        {
            return getAttributeMetaData(RETRY_INTERVAL_SECONDS_ATTR);
        }

        @Override
        public IMgmtBeanBase getContainerRef() throws MgmtException
        {
            return getReferenceAttribute(CONTAINER_REF_ATTR);
        }

        @Override
        public void setContainerRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(CONTAINER_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getContainerRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONTAINER_REF_ATTR);
        }

        @Override
        public int getRetryTimes() throws MgmtException
        {
            return getIntegerAttribute(RETRY_TIMES_ATTR);
        }

        @Override
        public void setRetryTimes(int value) throws MgmtException
        {
            setIntegerAttribute(RETRY_TIMES_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRetryTimesMetaData() throws MgmtException
        {
            return getAttributeMetaData(RETRY_TIMES_ATTR);
        }
    }

    public static class AbstractScheduleList
    extends MgmtMapBase implements IAbstractScheduleList
    {
        public AbstractScheduleList(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IActivationDaemonBean.IScheduleType getSchedule(String name) throws MgmtException
        {
            return new ActivationDaemonBean.ScheduleType(this, name, false);
        }

        @Override
        public IActivationDaemonBean.IScheduleType createSchedule() throws MgmtException
        {
            return new ActivationDaemonBean.ScheduleType(this, SCHEDULE_ATTR, true);
        }

        @Override
        public void addSchedule(String name, IActivationDaemonBean.IScheduleType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteSchedule(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getScheduleMetaData() throws MgmtException
        {
            return getAttributeMetaData(SCHEDULE_ATTR);
        }
    }

    public static class AbstractScheduleType
    extends MgmtSubBeanBase implements IAbstractScheduleType
    {
        public AbstractScheduleType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getOccursValue() throws MgmtException
        {
            return getStringAttribute(OCCURS_VALUE_ATTR);
        }

        @Override
        public void setOccursValue(String value) throws MgmtException
        {
            setStringAttribute(OCCURS_VALUE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getOccursValueMetaData() throws MgmtException
        {
            return getAttributeMetaData(OCCURS_VALUE_ATTR);
        }

        @Override
        public String getActionType() throws MgmtException
        {
            return getStringAttribute(ACTION_TYPE_ATTR);
        }

        @Override
        public void setActionType(String value) throws MgmtException
        {
            setStringAttribute(ACTION_TYPE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getActionTypeMetaData() throws MgmtException
        {
            return getAttributeMetaData(ACTION_TYPE_ATTR);
        }

        @Override
        public String getOccursType() throws MgmtException
        {
            return getStringAttribute(OCCURS_TYPE_ATTR);
        }

        @Override
        public void setOccursType(String value) throws MgmtException
        {
            setStringAttribute(OCCURS_TYPE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getOccursTypeMetaData() throws MgmtException
        {
            return getAttributeMetaData(OCCURS_TYPE_ATTR);
        }
    }
}
