/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAgentManagerConstants;
import com.sonicsw.mf.mgmtapi.config.impl.AgentManagerBean;

public abstract class AbstractAgentManagerBean
extends MgmtBeanBase implements IAgentManagerConstants, IAgentManagerBean
{
    public AbstractAgentManagerBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public int getMinPollThreads() throws MgmtException
    {
        return getIntegerAttribute(MIN_POLL_THREADS_ATTR);
    }

    @Override
    public void setMinPollThreads(int value) throws MgmtException
    {
        setIntegerAttribute(MIN_POLL_THREADS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMinPollThreadsMetaData() throws MgmtException
    {
        return getAttributeMetaData(MIN_POLL_THREADS_ATTR);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public IAgentManagerBean.IMetricsCollectionType getMetrics() throws MgmtException
    {
        return new AgentManagerBean.MetricsCollectionType(this, METRICS_ATTR, false);
    }

    @Override
    public void setMetrics(IAgentManagerBean.IMetricsCollectionType value) throws MgmtException
    {
        super.setAttribute(METRICS_ATTR, value);
    }

    @Override
    public IAgentManagerBean.IMetricsCollectionType createMetrics() throws MgmtException
    {
        return new AgentManagerBean.MetricsCollectionType(this, METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(METRICS_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public int getMaxPollThreads() throws MgmtException
    {
        return getIntegerAttribute(MAX_POLL_THREADS_ATTR);
    }

    @Override
    public void setMaxPollThreads(int value) throws MgmtException
    {
        setIntegerAttribute(MAX_POLL_THREADS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMaxPollThreadsMetaData() throws MgmtException
    {
        return getAttributeMetaData(MAX_POLL_THREADS_ATTR);
    }

    @Override
    public IAgentManagerBean.IAMReferences getConfigElementReferences() throws MgmtException
    {
        return new AgentManagerBean.AMReferences(this, CONFIG_ELEMENT_REFERENCES_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONFIG_ELEMENT_REFERENCES_ATTR);
    }

    @Override
    public int getFaultDetectionInterval() throws MgmtException
    {
        return getIntegerAttribute(FAULT_DETECTION_INTERVAL_ATTR);
    }

    @Override
    public void setFaultDetectionInterval(int value) throws MgmtException
    {
        setIntegerAttribute(FAULT_DETECTION_INTERVAL_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getFaultDetectionIntervalMetaData() throws MgmtException
    {
        return getAttributeMetaData(FAULT_DETECTION_INTERVAL_ATTR);
    }

    public static class AbstractMetricsCollectionType
    extends MgmtSubBeanBase implements IAbstractMetricsCollectionType
    {
        public AbstractMetricsCollectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getRefreshInterval() throws MgmtException
        {
            return getIntegerAttribute(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public void setRefreshInterval(int value) throws MgmtException
        {
            setIntegerAttribute(REFRESH_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public boolean getRepeatAlertNotifications() throws MgmtException
        {
            return getBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public void setRepeatAlertNotifications(boolean value) throws MgmtException
        {
            setBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException
        {
            return getAttributeMetaData(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public int getCollectionInterval() throws MgmtException
        {
            return getIntegerAttribute(COLLECTION_INTERVAL_ATTR);
        }

        @Override
        public void setCollectionInterval(int value) throws MgmtException
        {
            setIntegerAttribute(COLLECTION_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(COLLECTION_INTERVAL_ATTR);
        }
    }

    public static class AbstractAMReferences
    extends MgmtSubBeanBase implements IAbstractAMReferences
    {
        public AbstractAMReferences(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getBackupAmConfigElementRef() throws MgmtException
        {
            return getReferenceAttribute(BACKUP_AM_CONFIG_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getBackupAmConfigElementRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(BACKUP_AM_CONFIG_ELEMENT_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupAmConfigElementRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(BACKUP_AM_CONFIG_ELEMENT_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupAmConfigElementRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_AM_CONFIG_ELEMENT_REF_ATTR);
        }
    }
}
