/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAuthenticationDomainConstants;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationDomainBean;

public abstract class AbstractAuthenticationDomainBean
extends MgmtBeanBase implements IAuthenticationDomainConstants, IAuthenticationDomainBean
{
    public AbstractAuthenticationDomainBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public boolean getExternal() throws MgmtException
    {
        return getBooleanAttribute(EXTERNAL_ATTR);
    }

    @Override
    public boolean getExternal(boolean defValue) throws MgmtException
    {
        try
        {
            return getBooleanAttribute(EXTERNAL_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setExternal(boolean value) throws MgmtException
    {
        setBooleanAttribute(EXTERNAL_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getExternalMetaData() throws MgmtException
    {
        return getAttributeMetaData(EXTERNAL_ATTR);
    }

    @Override
    public IAuthenticationDomainBean.IGroupMapType getGroupMap() throws MgmtException
    {
        return new AuthenticationDomainBean.GroupMapType(this, GROUP_MAP_ATTR, false);
    }

    @Override
    public void setGroupMap(IAuthenticationDomainBean.IGroupMapType value) throws MgmtException
    {
        super.setAttribute(GROUP_MAP_ATTR, value);
    }

    @Override
    public IAuthenticationDomainBean.IGroupMapType createGroupMap() throws MgmtException
    {
        return new AuthenticationDomainBean.GroupMapType(this, GROUP_MAP_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getGroupMapMetaData() throws MgmtException
    {
        return getAttributeMetaData(GROUP_MAP_ATTR);
    }

    @Override
    public IAuthenticationDomainBean.IConnectionParamMap getAuthSpiConnectionParameters() throws MgmtException
    {
        return new AuthenticationDomainBean.ConnectionParamMap(this, AUTH_SPI_CONNECTION_PARAMETERS_ATTR, false);
    }

    @Override
    public void setAuthSpiConnectionParameters(IAuthenticationDomainBean.IConnectionParamMap value) throws MgmtException
    {
        super.setAttribute(AUTH_SPI_CONNECTION_PARAMETERS_ATTR, value);
    }

    @Override
    public IAuthenticationDomainBean.IConnectionParamMap createAuthSpiConnectionParameters() throws MgmtException
    {
        return new AuthenticationDomainBean.ConnectionParamMap(this, AUTH_SPI_CONNECTION_PARAMETERS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getAuthSpiConnectionParametersMetaData() throws MgmtException
    {
        return getAttributeMetaData(AUTH_SPI_CONNECTION_PARAMETERS_ATTR);
    }

    @Override
    public IMgmtBeanBase getAuthSpi() throws MgmtException
    {
        return getReferenceAttribute(AUTH_SPI_ATTR);
    }

    @Override
    public IMgmtBeanBase getAuthSpi(IMgmtBeanBase defValue) throws MgmtException
    {
        try
        {
            return getReferenceAttribute(AUTH_SPI_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setAuthSpi(IMgmtBeanBase value) throws MgmtException
    {
        setReferenceAttribute(AUTH_SPI_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getAuthSpiMetaData() throws MgmtException
    {
        return getAttributeMetaData(AUTH_SPI_ATTR);
    }

    @Override
    public IMgmtBeanBase getMgmtSpi() throws MgmtException
    {
        return getReferenceAttribute(MGMT_SPI_ATTR);
    }

    @Override
    public IMgmtBeanBase getMgmtSpi(IMgmtBeanBase defValue) throws MgmtException
    {
        try
        {
            return getReferenceAttribute(MGMT_SPI_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setMgmtSpi(IMgmtBeanBase value) throws MgmtException
    {
        setReferenceAttribute(MGMT_SPI_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMgmtSpiMetaData() throws MgmtException
    {
        return getAttributeMetaData(MGMT_SPI_ATTR);
    }

    @Override
    public String getDomainName() throws MgmtException
    {
        return getStringAttribute(DOMAIN_NAME_ATTR);
    }

    @Override
    public void setDomainName(String value) throws MgmtException
    {
        setStringAttribute(DOMAIN_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(DOMAIN_NAME_ATTR);
    }

    @Override
    public IAuthenticationDomainBean.IConnectionParamMap getMgmtSpiConnectionParameters() throws MgmtException
    {
        return new AuthenticationDomainBean.ConnectionParamMap(this, MGMT_SPI_CONNECTION_PARAMETERS_ATTR, false);
    }

    @Override
    public void setMgmtSpiConnectionParameters(IAuthenticationDomainBean.IConnectionParamMap value) throws MgmtException
    {
        super.setAttribute(MGMT_SPI_CONNECTION_PARAMETERS_ATTR, value);
    }

    @Override
    public IAuthenticationDomainBean.IConnectionParamMap createMgmtSpiConnectionParameters() throws MgmtException
    {
        return new AuthenticationDomainBean.ConnectionParamMap(this, MGMT_SPI_CONNECTION_PARAMETERS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMgmtSpiConnectionParametersMetaData() throws MgmtException
    {
        return getAttributeMetaData(MGMT_SPI_CONNECTION_PARAMETERS_ATTR);
    }

    public static class AbstractGroupMapType
    extends MgmtMapBase implements IAbstractGroupMapType
    {
        public AbstractGroupMapType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getInternalGroupName(String name) throws MgmtException
        {
            return (String)super.getAttribute(name);
        }

        @Override
        public void addInternalGroupName(String name, String value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteInternalGroupName(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getInternalGroupNameMetaData() throws MgmtException
        {
            return getAttributeMetaData(INTERNALGROUPNAME_ATTR);
        }
    }

    public static class AbstractConnectionParamMap
    extends MgmtMapBase implements IAbstractConnectionParamMap
    {
        public AbstractConnectionParamMap(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getConnectionItem(String name) throws MgmtException
        {
            return (String)super.getAttribute(name);
        }

        @Override
        public void addConnectionItem(String name, String value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteConnectionItem(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getConnectionItemMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONNECTIONITEM_ATTR);
        }
    }
}
