/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAuthenticationGroupConstants;
import com.sonicsw.mf.mgmtapi.config.impl.AuthenticationGroupBean;

public abstract class AbstractAuthenticationGroupBean
extends MgmtBeanBase implements IAuthenticationGroupConstants, IAuthenticationGroupBean
{
    public AbstractAuthenticationGroupBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getGroupName() throws MgmtException
    {
        return getStringAttribute(GROUP_NAME_ATTR);
    }

    @Override
    public void setGroupName(String value) throws MgmtException
    {
        setStringAttribute(GROUP_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getGroupNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(GROUP_NAME_ATTR);
    }

    @Override
    public IAuthenticationGroupBean.IGroupMembersType getGroupMembers() throws MgmtException
    {
        return new AuthenticationGroupBean.GroupMembersType(this, GROUP_MEMBERS_ATTR, false);
    }

    @Override
    public void setGroupMembers(IAuthenticationGroupBean.IGroupMembersType value) throws MgmtException
    {
        super.setAttribute(GROUP_MEMBERS_ATTR, value);
    }

    @Override
    public IAuthenticationGroupBean.IGroupMembersType createGroupMembers() throws MgmtException
    {
        return new AuthenticationGroupBean.GroupMembersType(this, GROUP_MEMBERS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getGroupMembersMetaData() throws MgmtException
    {
        return getAttributeMetaData(GROUP_MEMBERS_ATTR);
    }

    public static class AbstractGroupMembersType
    extends MgmtMapBase implements IAbstractGroupMembersType
    {
        public AbstractGroupMembersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IAuthenticationGroupBean.IGroupMemberType getMember(String name) throws MgmtException
        {
            return new AuthenticationGroupBean.GroupMemberType(this, name, false);
        }

        @Override
        public IAuthenticationGroupBean.IGroupMemberType createMember() throws MgmtException
        {
            return new AuthenticationGroupBean.GroupMemberType(this, MEMBER_ATTR, true);
        }

        @Override
        public void addMember(String name, IAuthenticationGroupBean.IGroupMemberType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteMember(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getMemberMetaData() throws MgmtException
        {
            return getAttributeMetaData(MEMBER_ATTR);
        }
    }

    public static class AbstractGroupMemberType
    extends MgmtSubBeanBase implements IAbstractGroupMemberType
    {
        public AbstractGroupMemberType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getMemberType() throws MgmtException
        {
            return getStringAttribute(MEMBER_TYPE_ATTR);
        }

        @Override
        public void setMemberType(String value) throws MgmtException
        {
            setStringAttribute(MEMBER_TYPE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getMemberTypeMetaData() throws MgmtException
        {
            return getAttributeMetaData(MEMBER_TYPE_ATTR);
        }

        @Override
        public String getMemberName() throws MgmtException
        {
            return getStringAttribute(MEMBER_NAME_ATTR);
        }

        @Override
        public void setMemberName(String value) throws MgmtException
        {
            setStringAttribute(MEMBER_NAME_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getMemberNameMetaData() throws MgmtException
        {
            return getAttributeMetaData(MEMBER_NAME_ATTR);
        }
    }
}
