/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAuthenticationUserConstants;

public abstract class AbstractAuthenticationUserBean
extends MgmtBeanBase implements IAuthenticationUserConstants, IAuthenticationUserBean
{
    public AbstractAuthenticationUserBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public byte[] getPassword() throws MgmtException
    {
        return getByteArrayAttribute(PASSWORD_ATTR);
    }

    @Override
    public void setPassword(byte[] value) throws MgmtException
    {
        setByteArrayAttribute(PASSWORD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException
    {
        return getAttributeMetaData(PASSWORD_ATTR);
    }

    @Override
    public String getUserName() throws MgmtException
    {
        return getStringAttribute(USER_NAME_ATTR);
    }

    @Override
    public void setUserName(String value) throws MgmtException
    {
        setStringAttribute(USER_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getUserNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(USER_NAME_ATTR);
    }
}
