/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IBackupAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.constants.IBackupAgentManagerConstants;
import com.sonicsw.mf.mgmtapi.config.impl.BackupAgentManagerBean;

public abstract class AbstractBackupAgentManagerBean
extends MgmtBeanBase implements IBackupAgentManagerConstants, IBackupAgentManagerBean
{
    public AbstractBackupAgentManagerBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public IBackupAgentManagerBean.IAMReferences getConfigElementReferences() throws MgmtException
    {
        return new BackupAgentManagerBean.AMReferences(this, CONFIG_ELEMENT_REFERENCES_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONFIG_ELEMENT_REFERENCES_ATTR);
    }

    public static class AbstractAMReferences
    extends MgmtSubBeanBase implements IAbstractAMReferences
    {
        public AbstractAMReferences(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getPrimaryAmConfigElementRef() throws MgmtException
        {
            return getReferenceAttribute(PRIMARY_AM_CONFIG_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getPrimaryAmConfigElementRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(PRIMARY_AM_CONFIG_ELEMENT_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryAmConfigElementRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(PRIMARY_AM_CONFIG_ELEMENT_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryAmConfigElementRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_AM_CONFIG_ELEMENT_REF_ATTR);
        }
    }
}
