/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IBackupDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.constants.IBackupDirectoryServiceConstants;
import com.sonicsw.mf.mgmtapi.config.impl.BackupDirectoryServiceBean;

public abstract class AbstractBackupDirectoryServiceBean
extends MgmtBeanBase implements IBackupDirectoryServiceConstants, IBackupDirectoryServiceBean
{
    public AbstractBackupDirectoryServiceBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public IBackupDirectoryServiceBean.IDsReferencesType getConfigElementReferences() throws MgmtException
    {
        return new BackupDirectoryServiceBean.DsReferencesType(this, CONFIG_ELEMENT_REFERENCES_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONFIG_ELEMENT_REFERENCES_ATTR);
    }

    @Override
    public String getHostDirectory() throws MgmtException
    {
        return getStringAttribute(HOST_DIRECTORY_ATTR);
    }

    @Override
    public void setHostDirectory(String value) throws MgmtException
    {
        setStringAttribute(HOST_DIRECTORY_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getHostDirectoryMetaData() throws MgmtException
    {
        return getAttributeMetaData(HOST_DIRECTORY_ATTR);
    }

    public static class AbstractDsReferencesType
    extends MgmtSubBeanBase implements IAbstractDsReferencesType
    {
        public AbstractDsReferencesType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getPrimaryConfigElementRef() throws MgmtException
        {
            return getReferenceAttribute(PRIMARY_CONFIG_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getPrimaryConfigElementRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(PRIMARY_CONFIG_ELEMENT_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryConfigElementRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(PRIMARY_CONFIG_ELEMENT_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryConfigElementRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_CONFIG_ELEMENT_REF_ATTR);
        }
    }
}
