/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtListBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.ICollectionsMonitorBean;
import com.sonicsw.mf.mgmtapi.config.constants.ICollectionsMonitorConstants;
import com.sonicsw.mf.mgmtapi.config.impl.CollectionsMonitorBean;

public abstract class AbstractCollectionsMonitorBean
extends MgmtBeanBase implements ICollectionsMonitorConstants, ICollectionsMonitorBean
{
    public AbstractCollectionsMonitorBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public boolean getSaveMonitoredNotifications() throws MgmtException
    {
        return getBooleanAttribute(SAVE_MONITORED_NOTIFICATIONS_ATTR);
    }

    @Override
    public void setSaveMonitoredNotifications(boolean value) throws MgmtException
    {
        setBooleanAttribute(SAVE_MONITORED_NOTIFICATIONS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getSaveMonitoredNotificationsMetaData() throws MgmtException
    {
        return getAttributeMetaData(SAVE_MONITORED_NOTIFICATIONS_ATTR);
    }

    @Override
    public int getHistoryDurationHours() throws MgmtException
    {
        return getIntegerAttribute(HISTORY_DURATION_HOURS_ATTR);
    }

    @Override
    public void setHistoryDurationHours(int value) throws MgmtException
    {
        setIntegerAttribute(HISTORY_DURATION_HOURS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getHistoryDurationHoursMetaData() throws MgmtException
    {
        return getAttributeMetaData(HISTORY_DURATION_HOURS_ATTR);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public ICollectionsMonitorBean.IMetricsCollectionType getMetrics() throws MgmtException
    {
        return new CollectionsMonitorBean.MetricsCollectionType(this, METRICS_ATTR, false);
    }

    @Override
    public void setMetrics(ICollectionsMonitorBean.IMetricsCollectionType value) throws MgmtException
    {
        super.setAttribute(METRICS_ATTR, value);
    }

    @Override
    public ICollectionsMonitorBean.IMetricsCollectionType createMetrics() throws MgmtException
    {
        return new CollectionsMonitorBean.MetricsCollectionType(this, METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(METRICS_ATTR);
    }

    @Override
    public ICollectionsMonitorBean.ICollectionList getCollections() throws MgmtException
    {
        return new CollectionsMonitorBean.CollectionList(this, COLLECTIONS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getCollectionsMetaData() throws MgmtException
    {
        return getAttributeMetaData(COLLECTIONS_ATTR);
    }

    @Override
    public boolean getSaveThresholdNotifications() throws MgmtException
    {
        return getBooleanAttribute(SAVE_THRESHOLD_NOTIFICATIONS_ATTR);
    }

    @Override
    public void setSaveThresholdNotifications(boolean value) throws MgmtException
    {
        setBooleanAttribute(SAVE_THRESHOLD_NOTIFICATIONS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getSaveThresholdNotificationsMetaData() throws MgmtException
    {
        return getAttributeMetaData(SAVE_THRESHOLD_NOTIFICATIONS_ATTR);
    }

    @Override
    public ICollectionsMonitorBean.IJdbcStorageType getJdbcHistoryStorage() throws MgmtException
    {
        return new CollectionsMonitorBean.JdbcStorageType(this, JDBC_HISTORY_STORAGE_ATTR, false);
    }

    @Override
    public void setJdbcHistoryStorage(ICollectionsMonitorBean.IJdbcStorageType value) throws MgmtException
    {
        super.setAttribute(JDBC_HISTORY_STORAGE_ATTR, value);
    }

    @Override
    public ICollectionsMonitorBean.IJdbcStorageType createJdbcHistoryStorage() throws MgmtException
    {
        return new CollectionsMonitorBean.JdbcStorageType(this, JDBC_HISTORY_STORAGE_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getJdbcHistoryStorageMetaData() throws MgmtException
    {
        return getAttributeMetaData(JDBC_HISTORY_STORAGE_ATTR);
    }

    @Override
    public long getMaxStorageSize() throws MgmtException
    {
        return getLongAttribute(MAX_STORAGE_SIZE_ATTR);
    }

    @Override
    public void setMaxStorageSize(long value) throws MgmtException
    {
        setLongAttribute(MAX_STORAGE_SIZE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMaxStorageSizeMetaData() throws MgmtException
    {
        return getAttributeMetaData(MAX_STORAGE_SIZE_ATTR);
    }

    @Override
    public ICollectionsMonitorBean.IFsStorageType getFsHistoryStorage() throws MgmtException
    {
        return new CollectionsMonitorBean.FsStorageType(this, FS_HISTORY_STORAGE_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getFsHistoryStorageMetaData() throws MgmtException
    {
        return getAttributeMetaData(FS_HISTORY_STORAGE_ATTR);
    }

    @Override
    public int getNotificationSubscriptionTimeout() throws MgmtException
    {
        return getIntegerAttribute(NOTIFICATION_SUBSCRIPTION_TIMEOUT_ATTR);
    }

    @Override
    public void setNotificationSubscriptionTimeout(int value) throws MgmtException
    {
        setIntegerAttribute(NOTIFICATION_SUBSCRIPTION_TIMEOUT_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getNotificationSubscriptionTimeoutMetaData() throws MgmtException
    {
        return getAttributeMetaData(NOTIFICATION_SUBSCRIPTION_TIMEOUT_ATTR);
    }

    public static class AbstractMetricsCollectionType
     extends MgmtSubBeanBase implements IAbstractMetricsCollectionType
     {
         public AbstractMetricsCollectionType(IMgmtBase parent, String name, boolean isNew)
         throws MgmtException
         {
             super(parent, name, isNew);
         }

         @Override
        public int getRefreshInterval() throws MgmtException
         {
             return getIntegerAttribute(REFRESH_INTERVAL_ATTR);
         }

         @Override
        public void setRefreshInterval(int value) throws MgmtException
         {
             setIntegerAttribute(REFRESH_INTERVAL_ATTR, value);
         }

         @Override
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException
         {
             return getAttributeMetaData(REFRESH_INTERVAL_ATTR);
         }

         @Override
        public boolean getRepeatAlertNotifications() throws MgmtException
         {
             return getBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR);
         }

         @Override
        public void setRepeatAlertNotifications(boolean value) throws MgmtException
         {
             setBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR, value);
         }

         @Override
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException
         {
             return getAttributeMetaData(REPEAT_ALERT_NOTIFICATIONS_ATTR);
         }

         @Override
        public int getCollectionInterval() throws MgmtException
         {
             return getIntegerAttribute(COLLECTION_INTERVAL_ATTR);
         }

         @Override
        public void setCollectionInterval(int value) throws MgmtException
         {
             setIntegerAttribute(COLLECTION_INTERVAL_ATTR, value);
         }

         @Override
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException
         {
             return getAttributeMetaData(COLLECTION_INTERVAL_ATTR);
         }
     }

    public static class AbstractCollectionList
    extends MgmtListBase implements IAbstractCollectionList
    {
        public AbstractCollectionList(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getEntry(int index) throws MgmtException
        {
            return (IMgmtBeanBase)super.getAttribute(Integer.toString(index));
        }

        @Override
        public void addEntry(IMgmtBeanBase value) throws MgmtException
        {
            super.add(value);
        }

        @Override
        public void insertEntry(int index, IMgmtBeanBase value) throws MgmtException
        {
            super.insert(index, value);
        }

        @Override
        public void deleteEntry(int index) throws MgmtException
        {
            super.delete(index);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractJdbcStorageType
    extends MgmtSubBeanBase implements IAbstractJdbcStorageType
    {
        public AbstractJdbcStorageType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getUser() throws MgmtException
        {
            return getStringAttribute(USER_ATTR);
        }

        @Override
        public void setUser(String value) throws MgmtException
        {
            setStringAttribute(USER_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getUserMetaData() throws MgmtException
        {
            return getAttributeMetaData(USER_ATTR);
        }

        @Override
        public String getBlobSqlType() throws MgmtException
        {
            return getStringAttribute(BLOB_SQL_TYPE_ATTR);
        }

        @Override
        public void setBlobSqlType(String value) throws MgmtException
        {
            setStringAttribute(BLOB_SQL_TYPE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBlobSqlTypeMetaData() throws MgmtException
        {
            return getAttributeMetaData(BLOB_SQL_TYPE_ATTR);
        }

        @Override
        public String getDriver() throws MgmtException
        {
            return getStringAttribute(DRIVER_ATTR);
        }

        @Override
        public void setDriver(String value) throws MgmtException
        {
            setStringAttribute(DRIVER_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getDriverMetaData() throws MgmtException
        {
            return getAttributeMetaData(DRIVER_ATTR);
        }

        @Override
        public String getPassword() throws MgmtException
        {
            return getStringAttribute(PASSWORD_ATTR);
        }

        @Override
        public void setPassword(String value) throws MgmtException
        {
            setStringAttribute(PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(PASSWORD_ATTR);
        }

        @Override
        public String getUrl() throws MgmtException
        {
            return getStringAttribute(URL_ATTR);
        }

        @Override
        public void setUrl(String value) throws MgmtException
        {
            setStringAttribute(URL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getUrlMetaData() throws MgmtException
        {
            return getAttributeMetaData(URL_ATTR);
        }

        @Override
        public String getUniqueConstraintError() throws MgmtException
        {
            return getStringAttribute(UNIQUE_CONSTRAINT_ERROR_ATTR);
        }

        @Override
        public void setUniqueConstraintError(String value) throws MgmtException
        {
            setStringAttribute(UNIQUE_CONSTRAINT_ERROR_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getUniqueConstraintErrorMetaData() throws MgmtException
        {
            return getAttributeMetaData(UNIQUE_CONSTRAINT_ERROR_ATTR);
        }

        @Override
        public String getTableNotFoundError() throws MgmtException
        {
            return getStringAttribute(TABLE_NOT_FOUND_ERROR_ATTR);
        }

        @Override
        public void setTableNotFoundError(String value) throws MgmtException
        {
            setStringAttribute(TABLE_NOT_FOUND_ERROR_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getTableNotFoundErrorMetaData() throws MgmtException
        {
            return getAttributeMetaData(TABLE_NOT_FOUND_ERROR_ATTR);
        }
    }

    public static class AbstractFsStorageType
    extends MgmtSubBeanBase implements IAbstractFsStorageType
    {
        public AbstractFsStorageType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getDirectory() throws MgmtException
        {
            return getStringAttribute(DIRECTORY_ATTR);
        }

        @Override
        public void setDirectory(String value) throws MgmtException
        {
            setStringAttribute(DIRECTORY_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getDirectoryMetaData() throws MgmtException
        {
            return getAttributeMetaData(DIRECTORY_ATTR);
        }
    }
}
