/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtListBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.constants.IComponentCollectionConstants;
import com.sonicsw.mf.mgmtapi.config.impl.ComponentCollectionBean;

public abstract class AbstractComponentCollectionBean
extends MgmtBeanBase implements IComponentCollectionConstants, IComponentCollectionBean
{
    public AbstractComponentCollectionBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public IComponentCollectionBean.INotifListType getForwardNotifications() throws MgmtException
    {
        return new ComponentCollectionBean.NotifListType(this, FORWARD_NOTIFICATIONS_ATTR, false);
    }

    @Override
    public void setForwardNotifications(IComponentCollectionBean.INotifListType value) throws MgmtException
    {
        super.setAttribute(FORWARD_NOTIFICATIONS_ATTR, value);
    }

    @Override
    public IComponentCollectionBean.INotifListType createForwardNotifications() throws MgmtException
    {
        return new ComponentCollectionBean.NotifListType(this, FORWARD_NOTIFICATIONS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getForwardNotificationsMetaData() throws MgmtException
    {
        return getAttributeMetaData(FORWARD_NOTIFICATIONS_ATTR);
    }

    @Override
    public IComponentCollectionBean.IComponentsSet getComponents() throws MgmtException
    {
        return new ComponentCollectionBean.ComponentsSet(this, COMPONENTS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getComponentsMetaData() throws MgmtException
    {
        return getAttributeMetaData(COMPONENTS_ATTR);
    }

    @Override
    public int getMetricsRefreshIntervalSeconds() throws MgmtException
    {
        return getIntegerAttribute(METRICS_REFRESH_INTERVAL_SECONDS_ATTR);
    }

    @Override
    public void setMetricsRefreshIntervalSeconds(int value) throws MgmtException
    {
        setIntegerAttribute(METRICS_REFRESH_INTERVAL_SECONDS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMetricsRefreshIntervalSecondsMetaData() throws MgmtException
    {
        return getAttributeMetaData(METRICS_REFRESH_INTERVAL_SECONDS_ATTR);
    }

    @Override
    public IComponentCollectionBean.IMonitorsSet getNotificationMonitors() throws MgmtException
    {
        return new ComponentCollectionBean.MonitorsSet(this, NOTIFICATION_MONITORS_ATTR, false);
    }

    @Override
    public void setNotificationMonitors(IComponentCollectionBean.IMonitorsSet value) throws MgmtException
    {
        super.setAttribute(NOTIFICATION_MONITORS_ATTR, value);
    }

    @Override
    public IComponentCollectionBean.IMonitorsSet createNotificationMonitors() throws MgmtException
    {
        return new ComponentCollectionBean.MonitorsSet(this, NOTIFICATION_MONITORS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getNotificationMonitorsMetaData() throws MgmtException
    {
        return getAttributeMetaData(NOTIFICATION_MONITORS_ATTR);
    }

    @Override
    public IComponentCollectionBean.IMetricListType getMonitorMetrics() throws MgmtException
    {
        return new ComponentCollectionBean.MetricListType(this, MONITOR_METRICS_ATTR, false);
    }

    @Override
    public void setMonitorMetrics(IComponentCollectionBean.IMetricListType value) throws MgmtException
    {
        super.setAttribute(MONITOR_METRICS_ATTR, value);
    }

    @Override
    public IComponentCollectionBean.IMetricListType createMonitorMetrics() throws MgmtException
    {
        return new ComponentCollectionBean.MetricListType(this, MONITOR_METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMonitorMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(MONITOR_METRICS_ATTR);
    }

    public static class AbstractNotifListType
    extends MgmtListBase implements IAbstractNotifListType
    {
        public AbstractNotifListType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getListItem(int index) throws MgmtException
        {
            return (String)super.getAttribute(Integer.toString(index));
        }

        @Override
        public void addListItem(String value) throws MgmtException
        {
            super.add(value);
        }

        @Override
        public void insertListItem(int index, String value) throws MgmtException
        {
            super.insert(index, value);
        }

        @Override
        public void deleteListItem(int index) throws MgmtException
        {
            super.delete(index);
        }

        @Override
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException
        {
            return getAttributeMetaData(LISTITEM_ATTR);
        }
    }

    public static class AbstractComponentsSet
    extends MgmtMapBase implements IAbstractComponentsSet
    {
        public AbstractComponentsSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IComponentCollectionBean.IComponent getEntry(String name) throws MgmtException
        {
            return new ComponentCollectionBean.Component(this, name, false);
        }

        @Override
        public IComponentCollectionBean.IComponent createEntry() throws MgmtException
        {
            return new ComponentCollectionBean.Component(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IComponentCollectionBean.IComponent value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractMonitorsSet
    extends MgmtMapBase implements IAbstractMonitorsSet
    {
        public AbstractMonitorsSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IComponentCollectionBean.IMonitorType getMonitor(String name) throws MgmtException
        {
            return new ComponentCollectionBean.MonitorType(this, name, false);
        }

        @Override
        public IComponentCollectionBean.IMonitorType createMonitor() throws MgmtException
        {
            return new ComponentCollectionBean.MonitorType(this, MONITOR_ATTR, true);
        }

        @Override
        public void addMonitor(String name, IComponentCollectionBean.IMonitorType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteMonitor(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getMonitorMetaData() throws MgmtException
        {
            return getAttributeMetaData(MONITOR_ATTR);
        }
    }

    public static class AbstractMetricListType
    extends MgmtListBase implements IAbstractMetricListType
    {
        public AbstractMetricListType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getListItem(int index) throws MgmtException
        {
            return (String)super.getAttribute(Integer.toString(index));
        }

        @Override
        public void addListItem(String value) throws MgmtException
        {
            super.add(value);
        }

        @Override
        public void insertListItem(int index, String value) throws MgmtException
        {
            super.insert(index, value);
        }

        @Override
        public void deleteListItem(int index) throws MgmtException
        {
            super.delete(index);
        }

        @Override
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException
        {
            return getAttributeMetaData(LISTITEM_ATTR);
        }
    }

    public static class AbstractComponent
    extends MgmtSubBeanBase implements IAbstractComponent
    {
        public AbstractComponent(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getComponentRuntimeId() throws MgmtException
        {
            return getStringAttribute(COMPONENT_RUNTIME_ID_ATTR);
        }

        @Override
        public void setComponentRuntimeId(String value) throws MgmtException
        {
            setStringAttribute(COMPONENT_RUNTIME_ID_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getComponentRuntimeIdMetaData() throws MgmtException
        {
            return getAttributeMetaData(COMPONENT_RUNTIME_ID_ATTR);
        }

        @Override
        public IMgmtBeanBase getConfigRef() throws MgmtException
        {
            return getReferenceAttribute(CONFIG_REF_ATTR);
        }

        @Override
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(CONFIG_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONFIG_REF_ATTR);
        }
    }

    public static class AbstractMonitorType
    extends MgmtSubBeanBase implements IAbstractMonitorType
    {
        public AbstractMonitorType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getIntervalSeconds() throws MgmtException
        {
            return getIntegerAttribute(INTERVAL_SECONDS_ATTR);
        }

        @Override
        public void setIntervalSeconds(int value) throws MgmtException
        {
            setIntegerAttribute(INTERVAL_SECONDS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getIntervalSecondsMetaData() throws MgmtException
        {
            return getAttributeMetaData(INTERVAL_SECONDS_ATTR);
        }

        @Override
        public IComponentCollectionBean.INotifList getMonitorNotifications() throws MgmtException
        {
            return new ComponentCollectionBean.NotifList(this, MONITOR_NOTIFICATIONS_ATTR, false);
        }

        @Override
        public IMgmtAttributeMetaData getMonitorNotificationsMetaData() throws MgmtException
        {
            return getAttributeMetaData(MONITOR_NOTIFICATIONS_ATTR);
        }

        @Override
        public int getLowThreshold() throws MgmtException
        {
            return getIntegerAttribute(LOW_THRESHOLD_ATTR);
        }

        @Override
        public int getLowThreshold(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(LOW_THRESHOLD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setLowThreshold(int value) throws MgmtException
        {
            setIntegerAttribute(LOW_THRESHOLD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getLowThresholdMetaData() throws MgmtException
        {
            return getAttributeMetaData(LOW_THRESHOLD_ATTR);
        }

        @Override
        public int getHighThreshold() throws MgmtException
        {
            return getIntegerAttribute(HIGH_THRESHOLD_ATTR);
        }

        @Override
        public int getHighThreshold(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(HIGH_THRESHOLD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setHighThreshold(int value) throws MgmtException
        {
            setIntegerAttribute(HIGH_THRESHOLD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getHighThresholdMetaData() throws MgmtException
        {
            return getAttributeMetaData(HIGH_THRESHOLD_ATTR);
        }
    }

    public static class AbstractNotifList
    extends MgmtListBase implements IAbstractNotifList
    {
        public AbstractNotifList(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getListItem(int index) throws MgmtException
        {
            return (String)super.getAttribute(Integer.toString(index));
        }

        @Override
        public void addListItem(String value) throws MgmtException
        {
            super.add(value);
        }

        @Override
        public void insertListItem(int index, String value) throws MgmtException
        {
            super.insert(index, value);
        }

        @Override
        public void deleteListItem(int index) throws MgmtException
        {
            super.delete(index);
        }

        @Override
        public IMgmtAttributeMetaData getListItemMetaData() throws MgmtException
        {
            return getAttributeMetaData(LISTITEM_ATTR);
        }
    }
}
