/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;
import com.sonicsw.mf.mgmtapi.config.impl.ContainerBean;

public abstract class AbstractContainerBean
extends MgmtBeanBase implements IContainerConstants, IContainerBean
{
    public AbstractContainerBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public int getMaxThreads() throws MgmtException
    {
        return getIntegerAttribute(MAX_THREADS_ATTR);
    }

    @Override
    public void setMaxThreads(int value) throws MgmtException
    {
        setIntegerAttribute(MAX_THREADS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMaxThreadsMetaData() throws MgmtException
    {
        return getAttributeMetaData(MAX_THREADS_ATTR);
    }

    @Override
    public String getJvmHome() throws MgmtException
    {
        return getStringAttribute(JVM_HOME_ATTR);
    }

    @Override
    public String getJvmHome(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(JVM_HOME_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setJvmHome(String value) throws MgmtException
    {
        setStringAttribute(JVM_HOME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getJvmHomeMetaData() throws MgmtException
    {
        return getAttributeMetaData(JVM_HOME_ATTR);
    }

    @Override
    public IContainerBean.IMonitoringType getMonitoring() throws MgmtException
    {
        return new ContainerBean.MonitoringType(this, MONITORING_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getMonitoringMetaData() throws MgmtException
    {
        return getAttributeMetaData(MONITORING_ATTR);
    }

    @Override
    public IContainerBean.ICacheType getCache() throws MgmtException
    {
        return new ContainerBean.CacheType(this, CACHE_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getCacheMetaData() throws MgmtException
    {
        return getAttributeMetaData(CACHE_ATTR);
    }

    @Override
    public IContainerBean.IComponentsType getComponents() throws MgmtException
    {
        return new ContainerBean.ComponentsType(this, COMPONENTS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getComponentsMetaData() throws MgmtException
    {
        return getAttributeMetaData(COMPONENTS_ATTR);
    }

    @Override
    public boolean getCommandLine() throws MgmtException
    {
        return getBooleanAttribute(COMMAND_LINE_ATTR);
    }

    @Override
    public void setCommandLine(boolean value) throws MgmtException
    {
        setBooleanAttribute(COMMAND_LINE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getCommandLineMetaData() throws MgmtException
    {
        return getAttributeMetaData(COMMAND_LINE_ATTR);
    }

    @Override
    public String getArchiveSearchPath() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_SEARCH_PATH_ATTR);
    }

    @Override
    public void setArchiveSearchPath(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_SEARCH_PATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveSearchPathMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_SEARCH_PATH_ATTR);
    }

    @Override
    public int getTraceMask() throws MgmtException
    {
        return getIntegerAttribute(TRACE_MASK_ATTR);
    }

    @Override
    public int getTraceMask(int defValue) throws MgmtException
    {
        try
        {
            return getIntegerAttribute(TRACE_MASK_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setTraceMask(int value) throws MgmtException
    {
        setIntegerAttribute(TRACE_MASK_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException
    {
        return getAttributeMetaData(TRACE_MASK_ATTR);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getActionalSdkArchiveName() throws MgmtException
    {
        return getStringAttribute(ACTIONAL_SDK_ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setActionalSdkArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ACTIONAL_SDK_ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getActionalSdkArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ACTIONAL_SDK_ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getActionalPlugmakerArchiveName() throws MgmtException
    {
        return getStringAttribute(ACTIONAL_PLUGMAKER_ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setActionalPlugmakerArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ACTIONAL_PLUGMAKER_ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getActionalPlugmakerArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ACTIONAL_PLUGMAKER_ARCHIVE_NAME_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public IContainerBean.IMetricsCollectionType getMetrics() throws MgmtException
    {
        return new ContainerBean.MetricsCollectionType(this, METRICS_ATTR, false);
    }

    @Override
    public void setMetrics(IContainerBean.IMetricsCollectionType value) throws MgmtException
    {
        super.setAttribute(METRICS_ATTR, value);
    }

    @Override
    public IContainerBean.IMetricsCollectionType createMetrics() throws MgmtException
    {
        return new ContainerBean.MetricsCollectionType(this, METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(METRICS_ATTR);
    }

    @Override
    public String getContainerNativeLibraryPath() throws MgmtException
    {
        return getStringAttribute(CONTAINER_NATIVE_LIBRARY_PATH_ATTR);
    }

    @Override
    public String getContainerNativeLibraryPath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CONTAINER_NATIVE_LIBRARY_PATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setContainerNativeLibraryPath(String value) throws MgmtException
    {
        setStringAttribute(CONTAINER_NATIVE_LIBRARY_PATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getContainerNativeLibraryPathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONTAINER_NATIVE_LIBRARY_PATH_ATTR);
    }

    @Override
    public IContainerBean.ISystemPropertiesType getSystemProperties() throws MgmtException
    {
        return new ContainerBean.SystemPropertiesType(this, SYSTEM_PROPERTIES_ATTR, false);
    }

    @Override
    public void setSystemProperties(IContainerBean.ISystemPropertiesType value) throws MgmtException
    {
        super.setAttribute(SYSTEM_PROPERTIES_ATTR, value);
    }

    @Override
    public IContainerBean.ISystemPropertiesType createSystemProperties() throws MgmtException
    {
        return new ContainerBean.SystemPropertiesType(this, SYSTEM_PROPERTIES_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getSystemPropertiesMetaData() throws MgmtException
    {
        return getAttributeMetaData(SYSTEM_PROPERTIES_ATTR);
    }

    @Override
    public IContainerBean.IEnabledMetricsType getEnabledMetrics() throws MgmtException
    {
        return new ContainerBean.EnabledMetricsType(this, ENABLED_METRICS_ATTR, false);
    }

    @Override
    public void setEnabledMetrics(IContainerBean.IEnabledMetricsType value) throws MgmtException
    {
        super.setAttribute(ENABLED_METRICS_ATTR, value);
    }

    @Override
    public IContainerBean.IEnabledMetricsType createEnabledMetrics() throws MgmtException
    {
        return new ContainerBean.EnabledMetricsType(this, ENABLED_METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getEnabledMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(ENABLED_METRICS_ATTR);
    }


    @Override
    public IContainerBean.IEnabledAlertsType getEnabledAlerts() throws MgmtException
    {
        return new ContainerBean.EnabledAlertsType(this, ENABLED_ALERTS_ATTR, false);
    }

    @Override
    public void setEnabledAlerts(IContainerBean.IEnabledAlertsType value) throws MgmtException
    {
        super.setAttribute(ENABLED_ALERTS_ATTR, value);
    }

    @Override
    public IContainerBean.IEnabledAlertsType createEnabledAlerts() throws MgmtException
    {
        return new ContainerBean.EnabledAlertsType(this, ENABLED_ALERTS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getEnabledAlertsMetaData() throws MgmtException
    {
        return getAttributeMetaData(ENABLED_ALERTS_ATTR);
    }

    @Override
    public IContainerBean.IExtensionsType getExtensions() throws MgmtException
    {
        return new ContainerBean.ExtensionsType(this, EXTENSIONS_ATTR, false);
    }

    @Override
    public void setExtensions(IContainerBean.IExtensionsType value) throws MgmtException
    {
        super.setAttribute(EXTENSIONS_ATTR, value);
    }

    @Override
    public IContainerBean.IExtensionsType createExtensions() throws MgmtException
    {
        return new ContainerBean.ExtensionsType(this, EXTENSIONS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getExtensionsMetaData() throws MgmtException
    {
        return getAttributeMetaData(EXTENSIONS_ATTR);
    }

    @Override
    public String getDomainName() throws MgmtException
    {
        return getStringAttribute(DOMAIN_NAME_ATTR);
    }

    @Override
    public void setDomainName(String value) throws MgmtException
    {
        setStringAttribute(DOMAIN_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(DOMAIN_NAME_ATTR);
    }

    @Override
    public long getLogFileSizeThreshold() throws MgmtException
    {
        return getLongAttribute(LOG_FILE_SIZE_THRESHOLD_ATTR);
    }

    @Override
    public void setLogFileSizeThreshold(long value) throws MgmtException
    {
        setLongAttribute(LOG_FILE_SIZE_THRESHOLD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFileSizeThresholdMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_SIZE_THRESHOLD_ATTR);
    }

    @Override
    public long getLogFileRolloverSizeThreshold() throws MgmtException
    {
        return getLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR);
    }

    @Override
    public void setLogFileRolloverSizeThreshold(long value) throws MgmtException
    {
        setLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFileRolloverSizeThresholdMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR);
    }


    public int getLogFileRolloverTimeInterval() throws MgmtException
    {
        return getIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR);
    }

    public void setLogFileRolloverTimeInterval(int value) throws MgmtException
    {
        setIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR, value);
    }

    public IMgmtAttributeMetaData getLogFileRolloverTimeIntervalMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR);
    }

    @Override
    public String getLogFile() throws MgmtException
    {
        return getStringAttribute(LOG_FILE_ATTR);
    }

    @Override
    public String getLogFile(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(LOG_FILE_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setLogFile(String value) throws MgmtException
    {
        setStringAttribute(LOG_FILE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFileMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_ATTR);
    }

    @Override
    public boolean getLogToConsole() throws MgmtException
    {
        return getBooleanAttribute(LOG_TO_CONSOLE_ATTR);
    }

    @Override
    public void setLogToConsole(boolean value) throws MgmtException
    {
        setBooleanAttribute(LOG_TO_CONSOLE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogToConsoleMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_TO_CONSOLE_ATTR);
    }

    @Override
    public String getJvmArguments() throws MgmtException
    {
        return getStringAttribute(JVM_ARGUMENTS_ATTR);
    }

    @Override
    public String getJvmArguments(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(JVM_ARGUMENTS_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setJvmArguments(String value) throws MgmtException
    {
        setStringAttribute(JVM_ARGUMENTS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getJvmArgumentsMetaData() throws MgmtException
    {
        return getAttributeMetaData(JVM_ARGUMENTS_ATTR);
    }

    @Override
    public String getManagementAuditConfig() throws MgmtException
    {
        return getStringAttribute(MANAGEMENT_AUDIT_CONFIG_ATTR);
    }

    @Override
    public String getManagementAuditConfig(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(MANAGEMENT_AUDIT_CONFIG_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setManagementAuditConfig(String value) throws MgmtException
    {
        setStringAttribute(MANAGEMENT_AUDIT_CONFIG_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getManagementAuditConfigMetaData() throws MgmtException
    {
        return getAttributeMetaData(MANAGEMENT_AUDIT_CONFIG_ATTR);
    }

    @Override
    public int getDirectoryServicePingInterval() throws MgmtException
    {
        return getIntegerAttribute(DIRECTORY_SERVICE_PING_INTERVAL_ATTR);
    }

    @Override
    public void setDirectoryServicePingInterval(int value) throws MgmtException
    {
        setIntegerAttribute(DIRECTORY_SERVICE_PING_INTERVAL_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getDirectoryServicePingIntervalMetaData() throws MgmtException
    {
        return getAttributeMetaData(DIRECTORY_SERVICE_PING_INTERVAL_ATTR);
    }

    @Override
    public IContainerBean.ICentralConnectionType getCentralConnection() throws MgmtException
    {
        return new ContainerBean.CentralConnectionType(this, CENTRAL_CONNECTION_ATTR, false);
    }

    @Override
    public void setCentralConnection(IContainerBean.ICentralConnectionType value) throws MgmtException
    {
        super.setAttribute(CENTRAL_CONNECTION_ATTR, value);
    }

    @Override
    public IContainerBean.ICentralConnectionType createCentralConnection() throws MgmtException
    {
        return new ContainerBean.CentralConnectionType(this, CENTRAL_CONNECTION_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getCentralConnectionMetaData() throws MgmtException
    {
        return getAttributeMetaData(CENTRAL_CONNECTION_ATTR);
    }

    @Override
    public IContainerBean.IFaultToleranceType getFaultToleranceParameters() throws MgmtException
    {
        return new ContainerBean.FaultToleranceType(this, FAULT_TOLERANCE_PARAMETERS_ATTR, false);
    }

    @Override
    public void setFaultToleranceParameters(IContainerBean.IFaultToleranceType value) throws MgmtException
    {
        super.setAttribute(FAULT_TOLERANCE_PARAMETERS_ATTR, value);
    }

    @Override
    public IContainerBean.IFaultToleranceType createFaultToleranceParameters() throws MgmtException
    {
        return new ContainerBean.FaultToleranceType(this, FAULT_TOLERANCE_PARAMETERS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getFaultToleranceParametersMetaData() throws MgmtException
    {
        return getAttributeMetaData(FAULT_TOLERANCE_PARAMETERS_ATTR);
    }

    @Override
    public int getMinThreads() throws MgmtException
    {
        return getIntegerAttribute(MIN_THREADS_ATTR);
    }

    @Override
    public void setMinThreads(int value) throws MgmtException
    {
        setIntegerAttribute(MIN_THREADS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMinThreadsMetaData() throws MgmtException
    {
        return getAttributeMetaData(MIN_THREADS_ATTR);
    }

    @Override
    public IContainerBean.IConnectionType getConnection() throws MgmtException
    {
        return new ContainerBean.ConnectionType(this, CONNECTION_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getConnectionMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONNECTION_ATTR);
    }

    @Override
    public boolean getLogToFile() throws MgmtException
    {
        return getBooleanAttribute(LOG_TO_FILE_ATTR);
    }

    @Override
    public void setLogToFile(boolean value) throws MgmtException
    {
        setBooleanAttribute(LOG_TO_FILE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogToFileMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_TO_FILE_ATTR);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getContainerName() throws MgmtException
    {
        return getStringAttribute(CONTAINER_NAME_ATTR);
    }

    @Override
    public void setContainerName(String value) throws MgmtException
    {
        setStringAttribute(CONTAINER_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getContainerNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONTAINER_NAME_ATTR);
    }

    @Override
    public boolean getEnableCentralizedLogging() throws MgmtException
    {
        return getBooleanAttribute(ENABLE_CENTRALIZED_LOGGING_ATTR);
    }

    @Override
    public void setEnableCentralizedLogging(boolean value) throws MgmtException
    {
        setBooleanAttribute(ENABLE_CENTRALIZED_LOGGING_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getEnableCentralizedLoggingMetaData() throws MgmtException
    {
        return getAttributeMetaData(ENABLE_CENTRALIZED_LOGGING_ATTR);
    }

    @Override
    public boolean getActionalLogInterceptor() throws MgmtException
    {
        return getBooleanAttribute(ACTIONAL_LOG_INTERCEPTOR_ATTR);
    }

    @Override
    public boolean getActionalLogInterceptor(boolean defValue) throws MgmtException
    {
        try
        {
            return getBooleanAttribute(ACTIONAL_LOG_INTERCEPTOR_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setActionalLogInterceptor(boolean value) throws MgmtException
    {
        setBooleanAttribute(ACTIONAL_LOG_INTERCEPTOR_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getActionalLogInterceptorMetaData() throws MgmtException
    {
        return getAttributeMetaData(ACTIONAL_LOG_INTERCEPTOR_ATTR);
    }


    @Override
    public boolean getHostsDirectoryService() throws MgmtException
    {
        return getBooleanAttribute(HOSTS_DIRECTORY_SERVICE_ATTR);
    }

    @Override
    public void setHostsDirectoryService(boolean value) throws MgmtException
    {
        setBooleanAttribute(HOSTS_DIRECTORY_SERVICE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getHostsDirectoryServiceMetaData() throws MgmtException
    {
        return getAttributeMetaData(HOSTS_DIRECTORY_SERVICE_ATTR);
    }

    @Override
    public int getNotificationDispatchQueueSize() throws MgmtException
    {
        return getIntegerAttribute(NOTIFICATION_DISPATCH_QUEUE_SIZE_ATTR);
    }

    @Override
    public void setNotificationDispatchQueueSize(int value) throws MgmtException
    {
        setIntegerAttribute(NOTIFICATION_DISPATCH_QUEUE_SIZE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getNotificationDispatchQueueSizeMetaData() throws MgmtException
    {
        return getAttributeMetaData(NOTIFICATION_DISPATCH_QUEUE_SIZE_ATTR);
    }

    public static class AbstractMonitoringType
    extends MgmtSubBeanBase implements IAbstractMonitoringType
    {
        public AbstractMonitoringType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getStatusPollTimeout() throws MgmtException
        {
            return getIntegerAttribute(STATUS_POLL_TIMEOUT_ATTR);
        }

        @Override
        public void setStatusPollTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(STATUS_POLL_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getStatusPollTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(STATUS_POLL_TIMEOUT_ATTR);
        }

        @Override
        public int getStatusPollInterval() throws MgmtException
        {
            return getIntegerAttribute(STATUS_POLL_INTERVAL_ATTR);
        }

        @Override
        public void setStatusPollInterval(int value) throws MgmtException
        {
            setIntegerAttribute(STATUS_POLL_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getStatusPollIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(STATUS_POLL_INTERVAL_ATTR);
        }
    }

    public static class AbstractCacheType
    extends MgmtSubBeanBase implements IAbstractCacheType
    {
        public AbstractCacheType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getPassword() throws MgmtException
        {
            return getStringAttribute(PASSWORD_ATTR);
        }

        @Override
        public String getPassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPassword(String value) throws MgmtException
        {
            setStringAttribute(PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(PASSWORD_ATTR);
        }

        @Override
        public String getCacheDirectory() throws MgmtException
        {
            return getStringAttribute(CACHE_DIRECTORY_ATTR);
        }

        @Override
        public void setCacheDirectory(String value) throws MgmtException
        {
            setStringAttribute(CACHE_DIRECTORY_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCacheDirectoryMetaData() throws MgmtException
        {
            return getAttributeMetaData(CACHE_DIRECTORY_ATTR);
        }

        @Override
        public long getPersistentBlobCacheSize() throws MgmtException
        {
            return getLongAttribute(PERSISTENT_BLOB_CACHE_SIZE_ATTR);
        }

        @Override
        public long getPersistentBlobCacheSize(long defValue) throws MgmtException
        {
            try
            {
                return getLongAttribute(PERSISTENT_BLOB_CACHE_SIZE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPersistentBlobCacheSize(long value) throws MgmtException
        {
            setLongAttribute(PERSISTENT_BLOB_CACHE_SIZE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPersistentBlobCacheSizeMetaData() throws MgmtException
        {
            return getAttributeMetaData(PERSISTENT_BLOB_CACHE_SIZE_ATTR);
        }

        @Override
        public int getMaximumDataMemory() throws MgmtException
        {
            return getIntegerAttribute(MAXIMUM_DATA_MEMORY_ATTR);
        }

        @Override
        public void setMaximumDataMemory(int value) throws MgmtException
        {
            setIntegerAttribute(MAXIMUM_DATA_MEMORY_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getMaximumDataMemoryMetaData() throws MgmtException
        {
            return getAttributeMetaData(MAXIMUM_DATA_MEMORY_ATTR);
        }
    }

    public static class AbstractComponentsType
    extends MgmtMapBase implements IAbstractComponentsType
    {
        public AbstractComponentsType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.IStartupParams getEntry(String name) throws MgmtException
        {
            return new ContainerBean.StartupParams(this, name, false);
        }

        @Override
        public IContainerBean.IStartupParams createEntry() throws MgmtException
        {
            return new ContainerBean.StartupParams(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerBean.IStartupParams value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractMetricsCollectionType
    extends MgmtSubBeanBase implements IAbstractMetricsCollectionType
    {
        public AbstractMetricsCollectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getRefreshInterval() throws MgmtException
        {
            return getIntegerAttribute(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public void setRefreshInterval(int value) throws MgmtException
        {
            setIntegerAttribute(REFRESH_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public boolean getRepeatAlertNotifications() throws MgmtException
        {
            return getBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public void setRepeatAlertNotifications(boolean value) throws MgmtException
        {
            setBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException
        {
            return getAttributeMetaData(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public int getCollectionInterval() throws MgmtException
        {
            return getIntegerAttribute(COLLECTION_INTERVAL_ATTR);
        }

        @Override
        public void setCollectionInterval(int value) throws MgmtException
        {
            setIntegerAttribute(COLLECTION_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(COLLECTION_INTERVAL_ATTR);
        }
    }

    public static class AbstractSystemPropertiesType
    extends MgmtMapBase implements IAbstractSystemPropertiesType
    {
        public AbstractSystemPropertiesType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getEntry(String name) throws MgmtException
        {
            return (String)super.getAttribute(name);
        }

        @Override
        public void addEntry(String name, String value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractEnabledMetricsType
    extends MgmtMapBase implements IAbstractEnabledMetricsType
    {
        public AbstractEnabledMetricsType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getEntry(String name) throws MgmtException
        {
            return (String)super.getAttribute(name);
        }

        @Override
        public void addEntry(String name, String value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractExtensionsType
    extends MgmtMapBase implements IAbstractExtensionsType
    {
        public AbstractExtensionsType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.IExtensionType getEntry(String name) throws MgmtException
        {
            return new ContainerBean.ExtensionType(this, name, false);
        }

        @Override
        public IContainerBean.IExtensionType createEntry() throws MgmtException
        {
            return new ContainerBean.ExtensionType(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerBean.IExtensionType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }


    public static class AbstractCentralConnectionType
    extends MgmtSubBeanBase implements IAbstractCentralConnectionType
    {
        public AbstractCentralConnectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getSocketConnectTimeout() throws MgmtException
        {
            return getIntegerAttribute(SOCKET_CONNECT_TIMEOUT_ATTR);
        }

        @Override
        public void setSocketConnectTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(SOCKET_CONNECT_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getSocketConnectTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(SOCKET_CONNECT_TIMEOUT_ATTR);
        }

        @Override
        public boolean getLoadBalancing() throws MgmtException
        {
            return getBooleanAttribute(LOADBALANCING_ATTR);
        }

        @Override
        public void setLoadBalancing(boolean value) throws MgmtException
        {
            setBooleanAttribute(LOADBALANCING_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getLoadBalancingMetaData() throws MgmtException
        {
            return getAttributeMetaData(LOADBALANCING_ATTR);
        }

        @Override
        public int getRequestTimeout() throws MgmtException
        {
            return getIntegerAttribute(REQUEST_TIMEOUT_ATTR);
        }

        @Override
        public void setRequestTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(REQUEST_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRequestTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(REQUEST_TIMEOUT_ATTR);
        }

        @Override
        public String getConnectionURLs() throws MgmtException
        {
            return getStringAttribute(CONNECTIONURLS_ATTR);
        }

        @Override
        public void setConnectionURLs(String value) throws MgmtException
        {
            setStringAttribute(CONNECTIONURLS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getConnectionURLsMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONNECTIONURLS_ATTR);
        }

        @Override
        public String getDefaultPassword() throws MgmtException
        {
            return getStringAttribute(DEFAULTPASSWORD_ATTR);
        }

        @Override
        public String getDefaultPassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(DEFAULTPASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setDefaultPassword(String value) throws MgmtException
        {
            setStringAttribute(DEFAULTPASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getDefaultPasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(DEFAULTPASSWORD_ATTR);
        }

        @Override
        public String getDefaultUser() throws MgmtException
        {
            return getStringAttribute(DEFAULTUSER_ATTR);
        }

        @Override
        public String getDefaultUser(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(DEFAULTUSER_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setDefaultUser(String value) throws MgmtException
        {
            setStringAttribute(DEFAULTUSER_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getDefaultUserMetaData() throws MgmtException
        {
            return getAttributeMetaData(DEFAULTUSER_ATTR);
        }

        @Override
        public int getConnectTimeout() throws MgmtException
        {
            return getIntegerAttribute(CONNECT_TIMEOUT_ATTR);
        }

        @Override
        public void setConnectTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(CONNECT_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getConnectTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONNECT_TIMEOUT_ATTR);
        }
    }

    public static class AbstractFaultToleranceType
    extends MgmtSubBeanBase implements IAbstractFaultToleranceType
    {
        public AbstractFaultToleranceType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getFaultTolerancePeerRef() throws MgmtException
        {
            return getReferenceAttribute(FAULT_TOLERANCE_PEER_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getFaultTolerancePeerRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(FAULT_TOLERANCE_PEER_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFaultTolerancePeerRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(FAULT_TOLERANCE_PEER_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFaultTolerancePeerRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAULT_TOLERANCE_PEER_REF_ATTR);
        }

        @Override
        public int getFaultDetectionTimeout() throws MgmtException
        {
            return getIntegerAttribute(FAULT_DETECTION_TIMEOUT_ATTR);
        }

        @Override
        public void setFaultDetectionTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(FAULT_DETECTION_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFaultDetectionTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAULT_DETECTION_TIMEOUT_ATTR);
        }

        @Override
        public String getFaultToleranceRole() throws MgmtException
        {
            return getStringAttribute(FAULT_TOLERANCE_ROLE_ATTR);
        }

        @Override
        public void setFaultToleranceRole(String value) throws MgmtException
        {
            setStringAttribute(FAULT_TOLERANCE_ROLE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFaultToleranceRoleMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAULT_TOLERANCE_ROLE_ATTR);
        }

        @Override
        public boolean getStartActive() throws MgmtException
        {
            return getBooleanAttribute(START_ACTIVE_ATTR);
        }

        @Override
        public void setStartActive(boolean value) throws MgmtException
        {
            setBooleanAttribute(START_ACTIVE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getStartActiveMetaData() throws MgmtException
        {
            return getAttributeMetaData(START_ACTIVE_ATTR);
        }

        @Override
        public int getFaultDetectionInterval() throws MgmtException
        {
            return getIntegerAttribute(FAULT_DETECTION_INTERVAL_ATTR);
        }

        @Override
        public void setFaultDetectionInterval(int value) throws MgmtException
        {
            setIntegerAttribute(FAULT_DETECTION_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFaultDetectionIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAULT_DETECTION_INTERVAL_ATTR);
        }
        
        @Override
        public int getFailureDetectionSocketConnectTimeout() throws MgmtException
        {
            return getIntegerAttribute(FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT_ATTR);
        }

        @Override
        public int getFailureDetectionSocketConnectTimeout(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFailureDetectionSocketConnectTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionSocketConnectTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_SOCKET_CONNECT_TIMEOUT_ATTR);
        }
        
        @Override
        public String getFailureDetectionDefaultUser() throws MgmtException
        {
            return getStringAttribute(FAILURE_DETECTION_DEFAULT_USER_ATTR);
        }

        @Override
        public String getFailureDetectionDefaultUser(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(FAILURE_DETECTION_DEFAULT_USER_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFailureDetectionDefaultUser(String value) throws MgmtException
        {
            setStringAttribute(FAILURE_DETECTION_DEFAULT_USER_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionDefaultUserMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_DEFAULT_USER_ATTR);
        }

        @Override
        public String getFailureDetectionConnectionurls() throws MgmtException
        {
            return getStringAttribute(FAILURE_DETECTION_CONNECTIONURLS_ATTR);
        }

        @Override
        public String getFailureDetectionConnectionurls(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(FAILURE_DETECTION_CONNECTIONURLS_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFailureDetectionConnectionurls(String value) throws MgmtException
        {
            setStringAttribute(FAILURE_DETECTION_CONNECTIONURLS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionConnectionurlsMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_CONNECTIONURLS_ATTR);
        }
        
        @Override
        public int getFailureDetectionConnectTimeout() throws MgmtException
        {
            return getIntegerAttribute(FAILURE_DETECTION_CONNECT_TIMEOUT_ATTR);
        }

        @Override
        public int getFailureDetectionConnectTimeout(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(FAILURE_DETECTION_CONNECT_TIMEOUT_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFailureDetectionConnectTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(FAILURE_DETECTION_CONNECT_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionConnectTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_CONNECT_TIMEOUT_ATTR);
        }
        
        @Override
        public String getFailureDetectionDefaultPassword() throws MgmtException
        {
            return getStringAttribute(FAILURE_DETECTION_DEFAULT_PASSWORD_ATTR);
        }

        @Override
        public String getFailureDetectionDefaultPassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(FAILURE_DETECTION_DEFAULT_PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setFailureDetectionDefaultPassword(String value) throws MgmtException
        {
            setStringAttribute(FAILURE_DETECTION_DEFAULT_PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionDefaultPasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_DEFAULT_PASSWORD_ATTR);
        }
        
    }


    /**
     * This has been manually modified to extend AbstractCentralConnectionType instead of MgmtSubBeanBase.
     * This was done as the connection and central connection have same fields
     * except for MANAGEMENT_NODE is missing in central connection.
     */
    public static class AbstractConnectionType
    extends AbstractCentralConnectionType implements IAbstractConnectionType
    {
        public AbstractConnectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getManagementNode() throws MgmtException
        {
            return getStringAttribute(MANAGEMENT_NODE_ATTR);
        }

        @Override
        public String getManagementNode(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(MANAGEMENT_NODE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setManagementNode(String value) throws MgmtException
        {
            setStringAttribute(MANAGEMENT_NODE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getManagementNodeMetaData() throws MgmtException
        {
            return getAttributeMetaData(MANAGEMENT_NODE_ATTR);
        }
    }

    public static class AbstractStartupParams
    extends MgmtSubBeanBase implements IAbstractStartupParams
    {
        public AbstractStartupParams(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.ILibrariesType getNativeLibraries() throws MgmtException
        {
            return new ContainerBean.LibrariesType(this, NATIVE_LIBRARIES_ATTR, false);
        }

        @Override
        public void setNativeLibraries(IContainerBean.ILibrariesType value) throws MgmtException
        {
            super.setAttribute(NATIVE_LIBRARIES_ATTR, value);
        }

        @Override
        public IContainerBean.ILibrariesType createNativeLibraries() throws MgmtException
        {
            return new ContainerBean.LibrariesType(this, NATIVE_LIBRARIES_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getNativeLibrariesMetaData() throws MgmtException
        {
            return getAttributeMetaData(NATIVE_LIBRARIES_ATTR);
        }

        @Override
        public boolean getAutoStart() throws MgmtException
        {
            return getBooleanAttribute(AUTO_START_ATTR);
        }

        @Override
        public void setAutoStart(boolean value) throws MgmtException
        {
            setBooleanAttribute(AUTO_START_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getAutoStartMetaData() throws MgmtException
        {
            return getAttributeMetaData(AUTO_START_ATTR);
        }

        @Override
        public int getTraceMask() throws MgmtException
        {
            return getIntegerAttribute(TRACE_MASK_ATTR);
        }

        @Override
        public void setTraceMask(int value) throws MgmtException
        {
            setIntegerAttribute(TRACE_MASK_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException
        {
            return getAttributeMetaData(TRACE_MASK_ATTR);
        }

        @Override
        public IMgmtBeanBase getConfigRef() throws MgmtException
        {
            return getReferenceAttribute(CONFIG_REF_ATTR);
        }

        @Override
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(CONFIG_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONFIG_REF_ATTR);
        }

        @Override
        public IContainerBean.IDeploymentParametersSet getDeploymentParameters() throws MgmtException
        {
            return new ContainerBean.DeploymentParametersSet(this, DEPLOYMENT_PARAMETERS_ATTR, false);
        }

        @Override
        public void setDeploymentParameters(IContainerBean.IDeploymentParametersSet value) throws MgmtException
        {
            super.setAttribute(DEPLOYMENT_PARAMETERS_ATTR, value);
        }

        @Override
        public IContainerBean.IDeploymentParametersSet createDeploymentParameters() throws MgmtException
        {
            return new ContainerBean.DeploymentParametersSet(this, DEPLOYMENT_PARAMETERS_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getDeploymentParametersMetaData() throws MgmtException
        {
            return getAttributeMetaData(DEPLOYMENT_PARAMETERS_ATTR);
        }


        @Override
        public IContainerBean.IEnabledAlertsType getEnabledAlerts() throws MgmtException
        {
            return new ContainerBean.EnabledAlertsType(this, ENABLED_ALERTS_ATTR, false);
        }

        @Override
        public void setEnabledAlerts(IContainerBean.IEnabledAlertsType value) throws MgmtException
        {
            super.setAttribute(ENABLED_ALERTS_ATTR, value);
        }

        @Override
        public IContainerBean.IEnabledAlertsType createEnabledAlerts() throws MgmtException
        {
            return new ContainerBean.EnabledAlertsType(this, ENABLED_ALERTS_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getEnabledAlertsMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENABLED_ALERTS_ATTR);
        }

        @Override
        public IContainerBean.IEnabledMetricsType getEnabledMetrics() throws MgmtException
        {
            return new ContainerBean.EnabledMetricsType(this, ENABLED_METRICS_ATTR, false);
        }

        @Override
        public void setEnabledMetrics(IContainerBean.IEnabledMetricsType value) throws MgmtException
        {
            super.setAttribute(ENABLED_METRICS_ATTR, value);
        }

        @Override
        public IContainerBean.IEnabledMetricsType createEnabledMetrics() throws MgmtException
        {
            return new ContainerBean.EnabledMetricsType(this, ENABLED_METRICS_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getEnabledMetricsMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENABLED_METRICS_ATTR);
        }

    }

    public static class AbstractEnabledAlertsType
    extends MgmtMapBase implements IAbstractEnabledAlertsType
    {
        public AbstractEnabledAlertsType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.IEnabledAlertParams getEntry(String name) throws MgmtException
        {
            return new ContainerBean.EnabledAlertParams(this, name, false);
        }

        @Override
        public IContainerBean.IEnabledAlertParams createEntry() throws MgmtException
        {
            return new ContainerBean.EnabledAlertParams(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerBean.IEnabledAlertParams value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractEnabledAlertParams
    extends MgmtSubBeanBase implements IAbstractEnabledAlertParams
    {
        public AbstractEnabledAlertParams(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getLowThresholds() throws MgmtException
        {
            return getStringAttribute(LOW_THRESHOLDS_ATTR);
        }

        @Override
        public String getLowThresholds(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(LOW_THRESHOLDS_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setLowThresholds(String value) throws MgmtException
        {
            setStringAttribute(LOW_THRESHOLDS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getLowThresholdsMetaData() throws MgmtException
        {
            return getAttributeMetaData(LOW_THRESHOLDS_ATTR);
        }

        @Override
        public String getHighThresholds() throws MgmtException
        {
            return getStringAttribute(HIGH_THRESHOLDS_ATTR);
        }

        @Override
        public String getHighThresholds(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(HIGH_THRESHOLDS_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setHighThresholds(String value) throws MgmtException
        {
            setStringAttribute(HIGH_THRESHOLDS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getHighThresholdsMetaData() throws MgmtException
        {
            return getAttributeMetaData(HIGH_THRESHOLDS_ATTR);
        }
    }

    public static class AbstractExtensionType
    extends MgmtSubBeanBase implements IAbstractExtensionType
    {
        public AbstractExtensionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public boolean getExtensionActive() throws MgmtException
        {
            return getBooleanAttribute(EXTENSION_ACTIVE_ATTR);
        }

        @Override
        public void setExtensionActive(boolean value) throws MgmtException
        {
            setBooleanAttribute(EXTENSION_ACTIVE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getExtensionActiveMetaData() throws MgmtException
        {
            return getAttributeMetaData(EXTENSION_ACTIVE_ATTR);
        }

        @Override
        public IMgmtBeanBase getExtensionConfigRef() throws MgmtException
        {
            return getReferenceAttribute(EXTENSION_CONFIG_REF_ATTR);
        }

        @Override
        public void setExtensionConfigRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(EXTENSION_CONFIG_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getExtensionConfigRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(EXTENSION_CONFIG_REF_ATTR);
        }
    }

    public static class AbstractLibrariesType
    extends MgmtMapBase implements IAbstractLibrariesType
    {
        public AbstractLibrariesType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.ILibraryParams getEntry(String name) throws MgmtException
        {
            return new ContainerBean.LibraryParams(this, name, false);
        }

        @Override
        public IContainerBean.ILibraryParams createEntry() throws MgmtException
        {
            return new ContainerBean.LibraryParams(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerBean.ILibraryParams value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractDeploymentParametersSet
    extends MgmtMapBase implements IAbstractDeploymentParametersSet
    {
        public AbstractDeploymentParametersSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerBean.IDeploymentParameterType getEntry(String name) throws MgmtException
        {
            return new ContainerBean.DeploymentParameterType(this, name, false);
        }

        @Override
        public IContainerBean.IDeploymentParameterType createEntry() throws MgmtException
        {
            return new ContainerBean.DeploymentParameterType(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerBean.IDeploymentParameterType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }


    public static class AbstractLibraryParams
    extends MgmtSubBeanBase implements IAbstractLibraryParams
    {
        public AbstractLibraryParams(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getNativeLibraryPath() throws MgmtException
        {
            return getStringAttribute(NATIVE_LIBRARY_PATH_ATTR);
        }

        @Override
        public void setNativeLibraryPath(String value) throws MgmtException
        {
            setStringAttribute(NATIVE_LIBRARY_PATH_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getNativeLibraryPathMetaData() throws MgmtException
        {
            return getAttributeMetaData(NATIVE_LIBRARY_PATH_ATTR);
        }
    }

    public static class AbstractDeploymentParameterType
    extends MgmtSubBeanBase implements IAbstractDeploymentParameterType
    {
        public AbstractDeploymentParameterType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getValue() throws MgmtException
        {
            return getStringAttribute(VALUE_ATTR);
        }

        @Override
        public void setValue(String value) throws MgmtException
        {
            setStringAttribute(VALUE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getValueMetaData() throws MgmtException
        {
            return getAttributeMetaData(VALUE_ATTR);
        }
    }
}
