/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IContainerCollectionBean;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerCollectionConstants;
import com.sonicsw.mf.mgmtapi.config.impl.ContainerCollectionBean;

public abstract class AbstractContainerCollectionBean
extends MgmtBeanBase implements IContainerCollectionConstants, IContainerCollectionBean
{
    public AbstractContainerCollectionBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public IContainerCollectionBean.IContainersSet getContainers() throws MgmtException
    {
        return new ContainerCollectionBean.ContainersSet(this, CONTAINERS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getContainersMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONTAINERS_ATTR);
    }

    public static class AbstractContainersSet
    extends MgmtMapBase implements IAbstractContainersSet
    {
        public AbstractContainersSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IContainerCollectionBean.IContainer getEntry(String name) throws MgmtException
        {
            return new ContainerCollectionBean.Container(this, name, false);
        }

        @Override
        public IContainerCollectionBean.IContainer createEntry() throws MgmtException
        {
            return new ContainerCollectionBean.Container(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IContainerCollectionBean.IContainer value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractContainer
    extends MgmtSubBeanBase implements IAbstractContainer
    {
        public AbstractContainer(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getContainerRuntimeId() throws MgmtException
        {
            return getStringAttribute(CONTAINER_RUNTIME_ID_ATTR);
        }

        @Override
        public void setContainerRuntimeId(String value) throws MgmtException
        {
            setStringAttribute(CONTAINER_RUNTIME_ID_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getContainerRuntimeIdMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONTAINER_RUNTIME_ID_ATTR);
        }

        @Override
        public IMgmtBeanBase getConfigRef() throws MgmtException
        {
            return getReferenceAttribute(CONFIG_REF_ATTR);
        }

        @Override
        public void setConfigRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(CONFIG_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getConfigRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(CONFIG_REF_ATTR);
        }
    }
}
