/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.IReplicationConnectionBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.config.constants.IDirectoryServiceConstants;
import com.sonicsw.mf.mgmtapi.config.impl.DirectoryServiceBean;

public abstract class AbstractDirectoryServiceBean
extends MgmtBeanBase implements IDirectoryServiceConstants, IDirectoryServiceBean
{
    public AbstractDirectoryServiceBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public IDirectoryServiceBean.IReplicationParametersType getReplicationParameters() throws MgmtException
    {
        return new DirectoryServiceBean.ReplicationParametersType(this, REPLICATION_PARAMETERS_ATTR, false);
    }

    @Override
    public void setReplicationParameters(IDirectoryServiceBean.IReplicationParametersType value) throws MgmtException
    {
        super.setAttribute(REPLICATION_PARAMETERS_ATTR, value);
    }

    @Override
    public IDirectoryServiceBean.IReplicationParametersType createReplicationParameters() throws MgmtException
    {
        return new DirectoryServiceBean.ReplicationParametersType(this, REPLICATION_PARAMETERS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getReplicationParametersMetaData() throws MgmtException
    {
        return getAttributeMetaData(REPLICATION_PARAMETERS_ATTR);
    }

    @Override
    public IDirectoryServiceBean.IDsReferencesType getConfigElementReferences() throws MgmtException
    {
        return new DirectoryServiceBean.DsReferencesType(this, CONFIG_ELEMENT_REFERENCES_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getConfigElementReferencesMetaData() throws MgmtException
    {
        return getAttributeMetaData(CONFIG_ELEMENT_REFERENCES_ATTR);
    }

    @Override
    public String getHostDirectory() throws MgmtException
    {
        return getStringAttribute(HOST_DIRECTORY_ATTR);
    }

    @Override
    public void setHostDirectory(String value) throws MgmtException
    {
        setStringAttribute(HOST_DIRECTORY_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getHostDirectoryMetaData() throws MgmtException
    {
        return getAttributeMetaData(HOST_DIRECTORY_ATTR);
    }

    @Override
    public IDirectoryServiceBean.IStorageType getFileSystemStorage() throws MgmtException
    {
        return new DirectoryServiceBean.StorageType(this, FILE_SYSTEM_STORAGE_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getFileSystemStorageMetaData() throws MgmtException
    {
        return getAttributeMetaData(FILE_SYSTEM_STORAGE_ATTR);
    }

    @Override
    public int getTraceMask() throws MgmtException
    {
        return getIntegerAttribute(TRACE_MASK_ATTR);
    }

    @Override
    public int getTraceMask(int defValue) throws MgmtException
    {
        try
        {
            return getIntegerAttribute(TRACE_MASK_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setTraceMask(int value) throws MgmtException
    {
        setIntegerAttribute(TRACE_MASK_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getTraceMaskMetaData() throws MgmtException
    {
        return getAttributeMetaData(TRACE_MASK_ATTR);
    }

    @Override
    public String getDomainName() throws MgmtException
    {
        return getStringAttribute(DOMAIN_NAME_ATTR);
    }

    @Override
    public void setDomainName(String value) throws MgmtException
    {
        setStringAttribute(DOMAIN_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getDomainNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(DOMAIN_NAME_ATTR);
    }

    public static class AbstractReplicationParametersType
    extends MgmtSubBeanBase implements IAbstractReplicationParametersType
    {
        public AbstractReplicationParametersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public boolean getDualActiveResolution() throws MgmtException
        {
            return getBooleanAttribute(DUAL_ACTIVE_RESOLUTION_ATTR);
        }

        @Override
        public void setDualActiveResolution(boolean value) throws MgmtException
        {
            setBooleanAttribute(DUAL_ACTIVE_RESOLUTION_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getDualActiveResolutionMetaData() throws MgmtException
        {
            return getAttributeMetaData(DUAL_ACTIVE_RESOLUTION_ATTR);
        }

        @Override
        public int getPingInterval() throws MgmtException
        {
            return getIntegerAttribute(PING_INTERVAL_ATTR);
        }

        @Override
        public void setPingInterval(int value) throws MgmtException
        {
            setIntegerAttribute(PING_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPingIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(PING_INTERVAL_ATTR);
        }

        @Override
        public int getFailureDetectionTimeout() throws MgmtException
        {
            return getIntegerAttribute(FAILURE_DETECTION_TIMEOUT_ATTR);
        }

        @Override
        public void setFailureDetectionTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(FAILURE_DETECTION_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getFailureDetectionTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(FAILURE_DETECTION_TIMEOUT_ATTR);
        }

        @Override
        public int getMaxReplicationLogSize() throws MgmtException
        {
            return getIntegerAttribute(MAX_REPLICATION_LOG_SIZE_ATTR);
        }

        @Override
        public void setMaxReplicationLogSize(int value) throws MgmtException
        {
            setIntegerAttribute(MAX_REPLICATION_LOG_SIZE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getMaxReplicationLogSizeMetaData() throws MgmtException
        {
            return getAttributeMetaData(MAX_REPLICATION_LOG_SIZE_ATTR);
        }

        @Override
        public int getReplicationTimeout() throws MgmtException
        {
            return getIntegerAttribute(REPLICATION_TIMEOUT_ATTR);
        }

        @Override
        public void setReplicationTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(REPLICATION_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getReplicationTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(REPLICATION_TIMEOUT_ATTR);
        }

        @Override
        public boolean getBackupFailoverReadOnly() throws MgmtException
        {
            return getBooleanAttribute(BACKUP_FAILOVER_READ_ONLY_ATTR);
        }

        @Override
        public void setBackupFailoverReadOnly(boolean value) throws MgmtException
        {
            setBooleanAttribute(BACKUP_FAILOVER_READ_ONLY_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupFailoverReadOnlyMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_FAILOVER_READ_ONLY_ATTR);
        }

        @Override
        public IDirectoryServiceBean.ISslParametersType getSslParameters() throws MgmtException
        {
            return new DirectoryServiceBean.SslParametersType(this, SSL_PARAMETERS_ATTR, false);
        }

        @Override
        public void setSslParameters(IDirectoryServiceBean.ISslParametersType value) throws MgmtException
        {
            super.setAttribute(SSL_PARAMETERS_ATTR, value);
        }

        @Override
        public IDirectoryServiceBean.ISslParametersType createSslParameters() throws MgmtException
        {
            return new DirectoryServiceBean.SslParametersType(this, SSL_PARAMETERS_ATTR, true);
        }

        @Override
        public IMgmtAttributeMetaData getSslParametersMetaData() throws MgmtException
        {
            return getAttributeMetaData(SSL_PARAMETERS_ATTR);
        }

        @Override
        public int getRetryInterval() throws MgmtException
        {
            return getIntegerAttribute(RETRY_INTERVAL_ATTR);
        }

        @Override
        public void setRetryInterval(int value) throws MgmtException
        {
            setIntegerAttribute(RETRY_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRetryIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(RETRY_INTERVAL_ATTR);
        }
    }

    public static class AbstractDsReferencesType
    extends MgmtSubBeanBase implements IAbstractDsReferencesType
    {
        private IMgmtBase parent = null;
        public AbstractDsReferencesType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
            this.parent = parent;
        }

        @Override
        public IMgmtBeanBase getBackupConfigElementRef() throws MgmtException
        {
            return getReferenceAttribute(BACKUP_CONFIG_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getBackupConfigElementRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(BACKUP_CONFIG_ELEMENT_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupConfigElementRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(BACKUP_CONFIG_ELEMENT_REF_ATTR, value);

            MFMgmtBeanFactory mfBeanFactory = (MFMgmtBeanFactory) parent.getMgmtBeanFactory();

            //Creating the replication connection and setting the reference to the Primary Directory Service.
            String dsPath = parent.getConfigBeanName();
            dsPath = dsPath.substring(0,dsPath.lastIndexOf("/"));
            IReplicationConnectionBean reppConnBean = mfBeanFactory.createReplicationConnectionBean(dsPath);

            ((AbstractDirectoryServiceBean)parent).getConfigElementReferences().setReplicationConnectionsElementRef(reppConnBean);

//            //Creating the Replication and SSL Paramenters
            AbstractDirectoryServiceBean dsBean = (AbstractDirectoryServiceBean) parent;
            IDirectoryServiceBean.IReplicationParametersType reppConnType = dsBean.createReplicationParameters();
            IDirectoryServiceBean.ISslParametersType sslParams = reppConnType.createSslParameters();
            reppConnType.setSslParameters(sslParams);
            dsBean.setReplicationParameters(reppConnType);
        }

        @Override
        public IMgmtAttributeMetaData getBackupConfigElementRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_CONFIG_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getReplicationConnectionsElementRef() throws MgmtException
        {
            return getReferenceAttribute(REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
        }

        @Override
        public IMgmtBeanBase getReplicationConnectionsElementRef(IMgmtBeanBase defValue) throws MgmtException
        {
            try
            {
                return getReferenceAttribute(REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setReplicationConnectionsElementRef(IMgmtBeanBase value) throws MgmtException
        {
            setReferenceAttribute(REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getReplicationConnectionsElementRefMetaData() throws MgmtException
        {
            return getAttributeMetaData(REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
        }
    }

    public static class AbstractStorageType
    extends MgmtSubBeanBase implements IAbstractStorageType
    {
        public AbstractStorageType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getPassword() throws MgmtException
        {
            return getStringAttribute(PASSWORD_ATTR);
        }

        @Override
        public String getPassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPassword(String value) throws MgmtException
        {
            setStringAttribute(PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(PASSWORD_ATTR);
        }
    }

    public static class AbstractSslParametersType
    extends MgmtSubBeanBase implements IAbstractSslParametersType
    {
        public AbstractSslParametersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public String getBackupKeyStorePassword() throws MgmtException
        {
            return getStringAttribute(BACKUP_KEY_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getBackupKeyStorePassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(BACKUP_KEY_STORE_PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupKeyStorePassword(String value) throws MgmtException
        {
            setStringAttribute(BACKUP_KEY_STORE_PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupKeyStorePasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_KEY_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getPrimaryTrustStorePassword() throws MgmtException
        {
            return getStringAttribute(PRIMARY_TRUST_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getPrimaryTrustStorePassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PRIMARY_TRUST_STORE_PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryTrustStorePassword(String value) throws MgmtException
        {
            setStringAttribute(PRIMARY_TRUST_STORE_PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryTrustStorePasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_TRUST_STORE_PASSWORD_ATTR);
        }

        @Override
        public int getHandshakeTimeout() throws MgmtException
        {
            return getIntegerAttribute(HANDSHAKE_TIMEOUT_ATTR);
        }

        @Override
        public int getHandshakeTimeout(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(HANDSHAKE_TIMEOUT_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setHandshakeTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(HANDSHAKE_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getHandshakeTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(HANDSHAKE_TIMEOUT_ATTR);
        }

        @Override
        public String getPrimaryKeyStorePassword() throws MgmtException
        {
            return getStringAttribute(PRIMARY_KEY_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getPrimaryKeyStorePassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PRIMARY_KEY_STORE_PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryKeyStorePassword(String value) throws MgmtException
        {
            setStringAttribute(PRIMARY_KEY_STORE_PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryKeyStorePasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_KEY_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getPrimaryKeyStoreFile() throws MgmtException
        {
            return getStringAttribute(PRIMARY_KEY_STORE_FILE_ATTR);
        }

        @Override
        public String getPrimaryKeyStoreFile(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PRIMARY_KEY_STORE_FILE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryKeyStoreFile(String value) throws MgmtException
        {
            setStringAttribute(PRIMARY_KEY_STORE_FILE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryKeyStoreFileMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_KEY_STORE_FILE_ATTR);
        }

        @Override
        public String getBackupTrustStorePassword() throws MgmtException
        {
            return getStringAttribute(BACKUP_TRUST_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getBackupTrustStorePassword(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(BACKUP_TRUST_STORE_PASSWORD_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupTrustStorePassword(String value) throws MgmtException
        {
            setStringAttribute(BACKUP_TRUST_STORE_PASSWORD_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupTrustStorePasswordMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_TRUST_STORE_PASSWORD_ATTR);
        }

        @Override
        public String getBackupTrustStoreFile() throws MgmtException
        {
            return getStringAttribute(BACKUP_TRUST_STORE_FILE_ATTR);
        }

        @Override
        public String getBackupTrustStoreFile(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(BACKUP_TRUST_STORE_FILE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupTrustStoreFile(String value) throws MgmtException
        {
            setStringAttribute(BACKUP_TRUST_STORE_FILE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupTrustStoreFileMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_TRUST_STORE_FILE_ATTR);
        }

        @Override
        public String getBackupKeyStoreFile() throws MgmtException
        {
            return getStringAttribute(BACKUP_KEY_STORE_FILE_ATTR);
        }

        @Override
        public String getBackupKeyStoreFile(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(BACKUP_KEY_STORE_FILE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setBackupKeyStoreFile(String value) throws MgmtException
        {
            setStringAttribute(BACKUP_KEY_STORE_FILE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupKeyStoreFileMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_KEY_STORE_FILE_ATTR);
        }

        @Override
        public int getCloseTimeout() throws MgmtException
        {
            return getIntegerAttribute(CLOSE_TIMEOUT_ATTR);
        }

        @Override
        public int getCloseTimeout(int defValue) throws MgmtException
        {
            try
            {
                return getIntegerAttribute(CLOSE_TIMEOUT_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setCloseTimeout(int value) throws MgmtException
        {
            setIntegerAttribute(CLOSE_TIMEOUT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCloseTimeoutMetaData() throws MgmtException
        {
            return getAttributeMetaData(CLOSE_TIMEOUT_ATTR);
        }

        @Override
        public String getCipherSuite() throws MgmtException
        {
            return getStringAttribute(CIPHER_SUITE_ATTR);
        }

        @Override
        public String getCipherSuite(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(CIPHER_SUITE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setCipherSuite(String value) throws MgmtException
        {
            setStringAttribute(CIPHER_SUITE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCipherSuiteMetaData() throws MgmtException
        {
            return getAttributeMetaData(CIPHER_SUITE_ATTR);
        }

        @Override
        public String getPrimaryTrustStoreFile() throws MgmtException
        {
            return getStringAttribute(PRIMARY_TRUST_STORE_FILE_ATTR);
        }

        @Override
        public String getPrimaryTrustStoreFile(String defValue) throws MgmtException
        {
            try
            {
                return getStringAttribute(PRIMARY_TRUST_STORE_FILE_ATTR);
            }
            catch(AttributeNotFoundException e)
            {
                return defValue;
            }
        }

        @Override
        public void setPrimaryTrustStoreFile(String value) throws MgmtException
        {
            setStringAttribute(PRIMARY_TRUST_STORE_FILE_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryTrustStoreFileMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_TRUST_STORE_FILE_ATTR);
        }
    }
}
