/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;

import com.sonicsw.mf.mgmtapi.config.IDomainBean;
import com.sonicsw.mf.mgmtapi.config.constants.IDomainConstants;

public abstract class AbstractDomainBean
extends MgmtBeanBase implements IDomainConstants, IDomainBean
{
    public AbstractDomainBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public boolean getAuditConfigureEvents() throws MgmtException
    {
        return getBooleanAttribute(AUDIT_CONFIGURE_EVENTS_ATTR);
    }

    @Override
    public void setAuditConfigureEvents(boolean value) throws MgmtException
    {
        setBooleanAttribute(AUDIT_CONFIGURE_EVENTS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getAuditConfigureEventsMetaData() throws MgmtException
    {
        return getAttributeMetaData(AUDIT_CONFIGURE_EVENTS_ATTR);
    }

    @Override
    public long getLogFileRolloverSizeThreshold() throws MgmtException
    {
        return getLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR);
    }

    @Override
    public void setLogFileRolloverSizeThreshold(long value) throws MgmtException
    {
        setLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFileRolloverSizeThresholdMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_ROLLOVER_SIZE_THRESHOLD_ATTR);
    }

    public int getLogFileRolloverTimeInterval() throws MgmtException
    {
        return getIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR);
    }

    public void setLogFileRolloverTimeInterval(int value) throws MgmtException
    {
        setIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR, value);
    }

    public IMgmtAttributeMetaData getLogFileRolloverTimeIntervalMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_ROLLOVER_TIME_INTERVAL_ATTR);
    }

    @Override
    public boolean getForceCentralizedLogging() throws MgmtException
    {
        return getBooleanAttribute(FORCE_CENTRALIZED_LOGGING_ATTR);
    }

    @Override
    public void setForceCentralizedLogging(boolean value) throws MgmtException
    {
        setBooleanAttribute(FORCE_CENTRALIZED_LOGGING_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getForceCentralizedLoggingMetaData() throws MgmtException
    {
        return getAttributeMetaData(FORCE_CENTRALIZED_LOGGING_ATTR);
    }

    @Override
    public boolean getEnableCentralizedAudit() throws MgmtException
    {
        return getBooleanAttribute(ENABLE_CENTRALIZED_AUDIT_ATTR);
    }

    @Override
    public void setEnableCentralizedAudit(boolean value) throws MgmtException
    {
        setBooleanAttribute(ENABLE_CENTRALIZED_AUDIT_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getEnableCentralizedAuditMetaData() throws MgmtException
    {
        return getAttributeMetaData(ENABLE_CENTRALIZED_AUDIT_ATTR);
    }

    @Override
    public String getCentralizedLogFile() throws MgmtException
    {
        return getStringAttribute(CENTRALIZED_LOG_FILE_ATTR);
    }

    @Override
    public String getCentralizedLogFile(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CENTRALIZED_LOG_FILE_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setCentralizedLogFile(String value) throws MgmtException
    {
        setStringAttribute(CENTRALIZED_LOG_FILE_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getCentralizedLogFileMetaData() throws MgmtException
    {
        return getAttributeMetaData(CENTRALIZED_LOG_FILE_ATTR);
    }

    @Override
    public String getDefaultManagementAuditConfig() throws MgmtException
    {
        return getStringAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG_ATTR);
    }

    @Override
    public void setDefaultManagementAuditConfig(String value) throws MgmtException
    {
        setStringAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getDefaultManagementAuditConfigMetaData() throws MgmtException
    {
        return getAttributeMetaData(DEFAULT_MANAGEMENT_AUDIT_CONFIG_ATTR);
    }

    @Override
    public IMgmtBeanBase getAuthenticationDomain() throws MgmtException
    {
        return getReferenceAttribute(AUTHENTICATION_DOMAIN_ATTR);
    }

    @Override
    public IMgmtBeanBase getAuthenticationDomain(IMgmtBeanBase defValue) throws MgmtException
    {
        try
        {
            return getReferenceAttribute(AUTHENTICATION_DOMAIN_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setAuthenticationDomain(IMgmtBeanBase value) throws MgmtException
    {
        setReferenceAttribute(AUTHENTICATION_DOMAIN_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getAuthenticationDomainMetaData() throws MgmtException
    {
        return getAttributeMetaData(AUTHENTICATION_DOMAIN_ATTR);
    }

    @Override
    public boolean getAuditManageEvents() throws MgmtException
    {
        return getBooleanAttribute(AUDIT_MANAGE_EVENTS_ATTR);
    }

    @Override
    public void setAuditManageEvents(boolean value) throws MgmtException
    {
        setBooleanAttribute(AUDIT_MANAGE_EVENTS_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getAuditManageEventsMetaData() throws MgmtException
    {
        return getAttributeMetaData(AUDIT_MANAGE_EVENTS_ATTR);
    }

    @Override
    public long getLogFileSizeThreshold() throws MgmtException
    {
        return getLongAttribute(LOG_FILE_SIZE_THRESHOLD_ATTR);
    }

    @Override
    public void setLogFileSizeThreshold(long value) throws MgmtException
    {
        setLongAttribute(LOG_FILE_SIZE_THRESHOLD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFileSizeThresholdMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FILE_SIZE_THRESHOLD_ATTR);
    }
}
