// Copyright (c) 2011 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.AttributeNotFoundException;
import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.ILoggerBean;
import com.sonicsw.mf.mgmtapi.config.constants.ILoggerConstants;
import com.sonicsw.mf.mgmtapi.config.impl.LoggerBean;

public abstract class AbstractLoggerBean
extends MgmtBeanBase implements ILoggerConstants, ILoggerBean
{
    public AbstractLoggerBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public String getClassname() throws MgmtException
    {
        return getStringAttribute(CLASSNAME_ATTR);
    }

    @Override
    public IMgmtAttributeMetaData getClassnameMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSNAME_ATTR);
    }

    @Override
    public String getArchiveName() throws MgmtException
    {
        return getStringAttribute(ARCHIVE_NAME_ATTR);
    }

    @Override
    public void setArchiveName(String value) throws MgmtException
    {
        setStringAttribute(ARCHIVE_NAME_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getArchiveNameMetaData() throws MgmtException
    {
        return getAttributeMetaData(ARCHIVE_NAME_ATTR);
    }

    @Override
    public int getMaxLookbackPeriod() throws MgmtException
    {
        return getIntegerAttribute(MAX_LOOKBACK_PERIOD_ATTR);
    }

    @Override
    public void setMaxLookbackPeriod(int value) throws MgmtException
    {
        setIntegerAttribute(MAX_LOOKBACK_PERIOD_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getMaxLookbackPeriodMetaData() throws MgmtException
    {
        return getAttributeMetaData(MAX_LOOKBACK_PERIOD_ATTR);
    }

    @Override
    public ILoggerBean.IMetricsCollectionType getMetrics() throws MgmtException
    {
        return new LoggerBean.MetricsCollectionType(this, METRICS_ATTR, false);
    }

    @Override
    public void setMetrics(ILoggerBean.IMetricsCollectionType value) throws MgmtException
    {
        super.setAttribute(METRICS_ATTR, value);
    }

    @Override
    public ILoggerBean.IMetricsCollectionType createMetrics() throws MgmtException
    {
        return new LoggerBean.MetricsCollectionType(this, METRICS_ATTR, true);
    }

    @Override
    public IMgmtAttributeMetaData getMetricsMetaData() throws MgmtException
    {
        return getAttributeMetaData(METRICS_ATTR);
    }

    @Override
    public String getClasspath() throws MgmtException
    {
        return getStringAttribute(CLASSPATH_ATTR);
    }

    @Override
    public String getClasspath(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(CLASSPATH_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setClasspath(String value) throws MgmtException
    {
        setStringAttribute(CLASSPATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getClasspathMetaData() throws MgmtException
    {
        return getAttributeMetaData(CLASSPATH_ATTR);
    }

    @Override
    public String getCollectionsMonitorRuntimeId() throws MgmtException
    {
        return getStringAttribute(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR);
    }

    @Override
    public void setCollectionsMonitorRuntimeId(String value) throws MgmtException
    {
        setStringAttribute(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getCollectionsMonitorRuntimeIdMetaData() throws MgmtException
    {
        return getAttributeMetaData(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR);
    }

    @Override
    public ILoggerBean.IComponentCollectionsType getComponentCollections() throws MgmtException
    {
        return new LoggerBean.ComponentCollectionsType(this, COMPONENT_COLLECTIONS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getComponentCollectionsMetaData() throws MgmtException
    {
        return getAttributeMetaData(COMPONENT_COLLECTIONS_ATTR);
    }

    @Override
    public String getLog4jConfigurationFilePath() throws MgmtException
    {
        return getStringAttribute(LOG4J_CONFIGURATION_FILE_PATH_ATTR);
    }

    @Override
    public void setLog4jConfigurationFilePath(String value) throws MgmtException
    {
        setStringAttribute(LOG4J_CONFIGURATION_FILE_PATH_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLog4jConfigurationFilePathMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG4J_CONFIGURATION_FILE_PATH_ATTR);
    }

    @Override
    public String getL0gTextDelimiter() throws MgmtException
    {
        return getStringAttribute(L0G_TEXT_DELIMITER_ATTR);
    }

    @Override
    public String getL0gTextDelimiter(String defValue) throws MgmtException
    {
        try
        {
            return getStringAttribute(L0G_TEXT_DELIMITER_ATTR);
        }
        catch(AttributeNotFoundException e)
        {
            return defValue;
        }
    }

    @Override
    public void setL0gTextDelimiter(String value) throws MgmtException
    {
        setStringAttribute(L0G_TEXT_DELIMITER_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getL0gTextDelimiterMetaData() throws MgmtException
    {
        return getAttributeMetaData(L0G_TEXT_DELIMITER_ATTR);
    }

    @Override
    public int getCollectionsMonitorPollInterval() throws MgmtException
    {
        return getIntegerAttribute(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR);
    }

    @Override
    public void setCollectionsMonitorPollInterval(int value) throws MgmtException
    {
        setIntegerAttribute(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getCollectionsMonitorPollIntervalMetaData() throws MgmtException
    {
        return getAttributeMetaData(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR);
    }

    @Override
    public String getLogFormat() throws MgmtException
    {
        return getStringAttribute(LOG_FORMAT_ATTR);
    }

    @Override
    public void setLogFormat(String value) throws MgmtException
    {
        setStringAttribute(LOG_FORMAT_ATTR, value);
    }

    @Override
    public IMgmtAttributeMetaData getLogFormatMetaData() throws MgmtException
    {
        return getAttributeMetaData(LOG_FORMAT_ATTR);
    }

    public static class AbstractMetricsCollectionType
    extends MgmtSubBeanBase implements IAbstractMetricsCollectionType
    {
        public AbstractMetricsCollectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getRefreshInterval() throws MgmtException
        {
            return getIntegerAttribute(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public void setRefreshInterval(int value) throws MgmtException
        {
            setIntegerAttribute(REFRESH_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRefreshIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(REFRESH_INTERVAL_ATTR);
        }

        @Override
        public boolean getRepeatAlertNotifications() throws MgmtException
        {
            return getBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public void setRepeatAlertNotifications(boolean value) throws MgmtException
        {
            setBooleanAttribute(REPEAT_ALERT_NOTIFICATIONS_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getRepeatAlertNotificationsMetaData() throws MgmtException
        {
            return getAttributeMetaData(REPEAT_ALERT_NOTIFICATIONS_ATTR);
        }

        @Override
        public int getCollectionInterval() throws MgmtException
        {
            return getIntegerAttribute(COLLECTION_INTERVAL_ATTR);
        }

        @Override
        public void setCollectionInterval(int value) throws MgmtException
        {
            setIntegerAttribute(COLLECTION_INTERVAL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getCollectionIntervalMetaData() throws MgmtException
        {
            return getAttributeMetaData(COLLECTION_INTERVAL_ATTR);
        }
    }

    public static class AbstractComponentCollectionsType
    extends MgmtMapBase implements IAbstractComponentCollectionsType
    {
        public AbstractComponentCollectionsType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IMgmtBeanBase getEntry(String name) throws MgmtException
        {
            return (IMgmtBeanBase)super.getAttribute(name);
        }

        @Override
        public void addEntry(String name, IMgmtBeanBase value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }
}
