/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.gen.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtSubBeanBase;

import com.sonicsw.mf.mgmtapi.config.IReplicationConnectionBean;
import com.sonicsw.mf.mgmtapi.config.constants.IReplicationConnectionConstants;
import com.sonicsw.mf.mgmtapi.config.impl.ReplicationConnectionBean;

public abstract class AbstractReplicationConnectionBean
extends MgmtBeanBase implements IReplicationConnectionConstants, IReplicationConnectionBean
{
    public AbstractReplicationConnectionBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public IReplicationConnectionBean.IReplicationConnectionSetType getReplicationConnections() throws MgmtException
    {
        return new ReplicationConnectionBean.ReplicationConnectionSetType(this, REPLICATION_CONNECTIONS_ATTR, false);
    }

    @Override
    public IMgmtAttributeMetaData getReplicationConnectionsMetaData() throws MgmtException
    {
        return getAttributeMetaData(REPLICATION_CONNECTIONS_ATTR);
    }

    public static class AbstractReplicationConnectionSetType
    extends MgmtMapBase implements IAbstractReplicationConnectionSetType
    {
        public AbstractReplicationConnectionSetType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public IReplicationConnectionBean.IReplicationConnectionType getEntry(String name) throws MgmtException
        {
            return new ReplicationConnectionBean.ReplicationConnectionType(this, name, false);
        }

        @Override
        public IReplicationConnectionBean.IReplicationConnectionType createEntry() throws MgmtException
        {
            return new ReplicationConnectionBean.ReplicationConnectionType(this, ENTRY_ATTR, true);
        }

        @Override
        public void addEntry(String name, IReplicationConnectionBean.IReplicationConnectionType value) throws MgmtException
        {
            super.add(name, value);
        }

        @Override
        public void deleteEntry(String name) throws MgmtException
        {
            super.delete(name);
        }

        @Override
        public IMgmtAttributeMetaData getEntryMetaData() throws MgmtException
        {
            return getAttributeMetaData(ENTRY_ATTR);
        }
    }

    public static class AbstractReplicationConnectionType
    extends MgmtSubBeanBase implements IAbstractReplicationConnectionType
    {
        public AbstractReplicationConnectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        @Override
        public int getWeight() throws MgmtException
        {
            return getIntegerAttribute(WEIGHT_ATTR);
        }

        @Override
        public void setWeight(int value) throws MgmtException
        {
            setIntegerAttribute(WEIGHT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getWeightMetaData() throws MgmtException
        {
            return getAttributeMetaData(WEIGHT_ATTR);
        }

        @Override
        public String getBackupAddr() throws MgmtException
        {
            return getStringAttribute(BACKUP_ADDR_ATTR);
        }

        @Override
        public void setBackupAddr(String value) throws MgmtException
        {
            setStringAttribute(BACKUP_ADDR_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupAddrMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_ADDR_ATTR);
        }

        @Override
        public int getBackupPort() throws MgmtException
        {
            return getIntegerAttribute(BACKUP_PORT_ATTR);
        }

        @Override
        public void setBackupPort(int value) throws MgmtException
        {
            setIntegerAttribute(BACKUP_PORT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getBackupPortMetaData() throws MgmtException
        {
            return getAttributeMetaData(BACKUP_PORT_ATTR);
        }

        @Override
        public String getPrimaryAddr() throws MgmtException
        {
            return getStringAttribute(PRIMARY_ADDR_ATTR);
        }

        @Override
        public void setPrimaryAddr(String value) throws MgmtException
        {
            setStringAttribute(PRIMARY_ADDR_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryAddrMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_ADDR_ATTR);
        }

        @Override
        public String getProtocol() throws MgmtException
        {
            return getStringAttribute(PROTOCOL_ATTR);
        }

        @Override
        public void setProtocol(String value) throws MgmtException
        {
            setStringAttribute(PROTOCOL_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getProtocolMetaData() throws MgmtException
        {
            return getAttributeMetaData(PROTOCOL_ATTR);
        }

        @Override
        public String getName() throws MgmtException
        {
            return getStringAttribute(NAME_ATTR);
        }

        @Override
        public void setName(String value) throws MgmtException
        {
            setStringAttribute(NAME_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getNameMetaData() throws MgmtException
        {
            return getAttributeMetaData(NAME_ATTR);
        }

        @Override
        public int getPrimaryPort() throws MgmtException
        {
            return getIntegerAttribute(PRIMARY_PORT_ATTR);
        }

        @Override
        public void setPrimaryPort(int value) throws MgmtException
        {
            setIntegerAttribute(PRIMARY_PORT_ATTR, value);
        }

        @Override
        public IMgmtAttributeMetaData getPrimaryPortMetaData() throws MgmtException
        {
            return getAttributeMetaData(PRIMARY_PORT_ATTR);
        }
    }
}
