/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationDomainBean;

public class AuthenticationDomainBean
extends AbstractAuthenticationDomainBean implements IAuthenticationDomainBean
{
    private boolean m_external = false;

    private final static String[] mandatoryGroups = new String[]
    {
        "Administrators",
        "PUBLIC",
        "TxnAdministrators",
        "$ISYS-BROKERS"
    };

    public AuthenticationDomainBean(MgmtBeanFactory factory)
    throws MgmtException
    {
        super(factory);
    }

    @Override
    public void createBean(String viewName, String type, String cVersion, String pVersion)
    throws MgmtException
    {
        super.createBean(viewName + "/" + ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX,
                         type,
                         cVersion,
                         pVersion,
                         false);

        setDomainName(viewName.substring(viewName.lastIndexOf('/') + 1));
    }

    @Override
    public void loadBean(String viewName, String type) throws MgmtException
    {
        super.loadBean(viewName + "/" + ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX, type);
    }

    @Override
    protected void deleteBean() throws Exception
    {
        getMgmtBeanFactory().getConfigServer().removeConfigElement(getConfigBean().getName());

        String path = getConfigBean().getName();
        path = path.substring(0, path.lastIndexOf("/"));
        getMgmtBeanFactory().getConfigServer().deleteFolder(path);
    }

    @Override
    public void saveBean() throws Exception
    {
        super.saveBean();

        if (isNewBean())
        {
            setFolderElementAttributes();

            for (int i = 0; i < mandatoryGroups.length; i++)
            {
                IAuthenticationGroupBean group = createGroupBean();

                group.setGroupName(mandatoryGroups[i]);

                if(mandatoryGroups[i].equals("Administrators") || mandatoryGroups[i].equals("PUBLIC"))
                {
                    IAuthenticationGroupBean.IGroupMembersType members = group.createGroupMembers();
                    IAuthenticationGroupBean.IGroupMemberType member = members.createMember();
                    member.setMemberName("Administrator");
                    member.setMemberType("user");
                    members.add("Administrator", member);
                    group.setGroupMembers(members);
                }
                getMgmtBeanFactory().saveBean(group);
            }

            IAuthenticationUserBean user = createUserBean();

            user.setUserName("Administrator");
            user.setPassword("Administrator");

            getMgmtBeanFactory().saveBean(user);
        }

    }
    
    /*
     *  Overrides super, for right now we disable it for complex type. 
     */
    @Override
    public IMgmtBeanBase clone(String viewName)
    throws MgmtException
    {
       throw new MgmtException("Illegal operation");
    }
    
    @Override
    public List getUserBeans()
    throws MgmtException
    {
        String beanName = getConfigBean().getName();
        int    index    = beanName.lastIndexOf('/');
        String userName = beanName.substring(0, index + 1) + IMFDirectories.MF_USERS_DIR;

        return getMgmtBeanFactory().loadBeansInDirectory(userName);
    }

    @Override
    public IAuthenticationUserBean getUserBean(String name)
    throws MgmtException
    {
        IAuthenticationUserBean user = null;
        List users = getUserBeans();

        for(Iterator i = users.iterator(); i.hasNext();)
        {
            user = (IAuthenticationUserBean)i.next();

            if(user.getUserName().equals(name))
            {
                return user;
            }
        }
        throw new MgmtException("User " + name + " doesn't exist.");
    }

    @Override
    public List getGroupBeans()
    throws MgmtException
    {
        String beanName = getConfigBean().getName();
        int    index    = beanName.lastIndexOf('/');
        String userName = beanName.substring(0, index + 1) + IMFDirectories.MF_GROUPS_DIR;

        return getMgmtBeanFactory().loadBeansInDirectory(userName);
    }

    @Override
    public IAuthenticationGroupBean getGroupBean(String name)
    throws MgmtException
    {
        IAuthenticationGroupBean group = null;
        List groups = getGroupBeans();

        for(Iterator i = groups.iterator(); i.hasNext();)
        {
            group = (IAuthenticationGroupBean)i.next();
            if(group.getGroupName().equals(name))
            {
                return group;
            }
        }
        throw new MgmtException("Group " + name + " doesn't exist.");
    }

    @Override
    public IAuthenticationUserBean createUserBean()
    throws MgmtException
    {
        return createUserBean(getMgmtBeanFactory().getConfigServer());
    }

    @Override
    public IAuthenticationUserBean createUserBean(String userName, String password)
    throws MgmtException
    {
        IAuthenticationUserBean user = createUserBean(getMgmtBeanFactory().getConfigServer());

        user.setUserName(userName);
        user.setPassword(password);

        return user;
    }

    @Override
    public IAuthenticationUserBean createUserBean(String userName, byte[] password)
    throws MgmtException
    {
        IAuthenticationUserBean user = createUserBean(getMgmtBeanFactory().getConfigServer());

        user.setUserName(userName);
        user.setPassword(password);

        return user;
    }

    @Override
    protected void setFolderElementAttributes() throws MgmtException
    {
        try
        {
            String path = getConfigBean().getName();
            path = path.substring(0, path.lastIndexOf("/"));

            HashMap map = new HashMap();
            map.put(ConfigServerUtility.TYPE,            getProperty(TYPE_PROPERTY));
            map.put(ConfigServerUtility.CONFIG_VERSION,  getProperty(C_VERSION_PROPERTY));
            map.put(ConfigServerUtility.PRODUCT_VERSION, getProperty(P_VERSION_PROPERTY));

            getMgmtBeanFactory().setFolderMetaAttributes(path, map);
        }
        catch(Throwable e)
        {
            throw new MgmtException("Failed to set folder element attributes- " + e.getMessage(), e);
        }
    }

    private IAuthenticationUserBean createUserBean(IConfigServer server)
    throws MgmtException
    {
        AuthenticationUserBean bean = new AuthenticationUserBean(getMgmtBeanFactory());

        // Now work out the location !!!!
        String beanName = getConfigBean().getName();
        int    index    = beanName.lastIndexOf(IMFDirectories.MF_DIR_SEPARATOR);
        String pattern  = beanName.substring(0, index + 1) + IMFDirectories.MF_USERS_DIR;

        // We don't want to set metaAttributes on this bean
        bean.createBean(createUniqueName(pattern, false),
                        AuthenticationUserBean.DS_TYPE,
                        AuthenticationUserBean.DS_C_VERSION,
                        AuthenticationUserBean.DS_P_VERSION,
                        false);

        return bean;
    }

    @Override
    public void deleteUserBean(IAuthenticationUserBean bean)
    throws MgmtException
    {
        getMgmtBeanFactory().deleteBean(bean);

        // delete this user from its groups
        List groupsToModify = getGroupBeans();
        Iterator groupsIterator = groupsToModify.iterator();

        while (groupsIterator.hasNext())
        {
            IAuthenticationGroupBean group = (IAuthenticationGroupBean)groupsIterator.next();

            try
            {
                IAuthenticationGroupBean.IGroupMembersType groupMembers = group.getGroupMembers();
                IAuthenticationGroupBean.IGroupMemberType thisUser = groupMembers.getMember(bean.getUserName());

                if (thisUser != null)
                {
                    groupMembers.deleteMember(bean.getUserName());
                }
            }
            catch (MgmtException e) {} // the user doesn't exist or the group has no members
        }
    }

    @Override
    public IAuthenticationGroupBean createGroupBean()
    throws MgmtException
    {
        return createGroupBean(getMgmtBeanFactory().getConfigServer());
    }

    private IAuthenticationGroupBean createGroupBean(IConfigServer server)
    throws MgmtException
    {
        AuthenticationGroupBean bean = new AuthenticationGroupBean(getMgmtBeanFactory());

        // Now work out the location !!!!
        String beanName = getConfigBean().getName();
        int    index    = beanName.lastIndexOf(IMFDirectories.MF_DIR_SEPARATOR);
        String pattern  = beanName.substring(0, index + 1) + IMFDirectories.MF_GROUPS_DIR;

        // We don't want to set metaAttributes on this bean
        bean.createBean(createUniqueName(pattern, false),
                        AuthenticationGroupBean.DS_TYPE,
                        AuthenticationGroupBean.DS_C_VERSION,
                        AuthenticationGroupBean.DS_P_VERSION,
                        false);

        return bean;
    }

    @Override
    public void deleteGroupBean(IAuthenticationGroupBean bean)
    throws MgmtException
    {
        getMgmtBeanFactory().deleteBean(bean);
    }

    @Override
    public void setExternal(boolean value)
    throws MgmtException
    {
       m_external = value;

       super.setExternal(value);
    }

    @Override
    public boolean isExternal()
    {
         return m_external;
    }

    public static class ConnectionParamMap
    extends AbstractConnectionParamMap implements IConnectionParamMap
    {
        public ConnectionParamMap(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class GroupMapType
    extends AbstractGroupMapType implements IGroupMapType
    {
        public GroupMapType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }
}

