/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.util.ConfigHelper;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAuthenticationUserConstants;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationGroupBean;


public class AuthenticationGroupBean extends AbstractAuthenticationGroupBean
                                     implements IAuthenticationGroupBean
{
    public AuthenticationGroupBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public void setGroupName(String value) throws MgmtException
    {
       try
       {
          IConfigBean bean = this.getConfigBean();

          String path = bean.getName();
          int index   = path.lastIndexOf('/') + 1;

          path = path.substring(0, index);
          bean.setName(path + value);

          super.setGroupName(value);
       }
       catch(Throwable e)
       {
          throw new MgmtException("Failed setGroupName - " + e.getMessage(), e);
       }
    }

    @Override
    protected void saveBean() throws Exception
    {
        // Check to see if the group is unique
        if(isNewBean())
        {
            String beanName = getConfigBean().getName();
            int    index    = beanName.lastIndexOf('/');
            String path     = beanName.substring(0, index);

            if(getMgmtBeanFactory().doesConfigurationNameExist(getGroupName(), path))
            {
                throw new MgmtException("The specified group name already exist");
            }

            try
            {
                IConfigBean groupBean = getConfigBean();
                String      groupName = getGroupName();

                String id         = groupBean.getName();
                String domainPath = id.substring(0, id.lastIndexOf(IMFDirectories.MF_GROUPS_DIR));
                String usersPath  = domainPath + IMFDirectories.MF_USERS_DIR + IMFDirectories.MF_DIR_SEPARATOR;

                if (!ConfigHelper.isAttrValueUniqueWithinFolder(getConfigBean().getConfigServer(),
                                                                usersPath,
                                                                IAuthenticationUserConstants.USER_NAME_ATTR,
                                                                groupName))
                {
                    throw new MgmtException("The specified group name '" + groupName + "' already exists - clashes with existing user name");
                }
            }
            catch (MgmtException e)
            {
                throw e;
            }
            catch (Exception e)
            {
                throw new MgmtException("Failed to verify group name uniqueness: " + e.getMessage(), e);
            }
        }

        super.saveBean();
    }

    @Override
    public void addMember(String memberName, String memberType)
        throws MgmtException
    {
        IGroupMembersType members = null;

        // There may be no group members (they are optional). Instead of
        // returning null, the method for some reason throws a MgmtException
        // which we must catch...before creating an empty members structure.
        try
        {
            members = getGroupMembers();
        }
        catch (Exception e)
        {
            setGroupMembers(createGroupMembers());

            // Have to do it this way because of the way underlying Config
            // Layer structures are cloned on a set
            //
            members = getGroupMembers();
        }

        IGroupMemberType  newType = members.createMember();

        newType.setMemberName(memberName);
        newType.setMemberType(memberType);

        members.addMember(memberName, newType);
    }

    public static class GroupMembersType
    extends AbstractGroupMembersType implements IGroupMembersType
    {
        public GroupMembersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class GroupMemberType
    extends AbstractGroupMemberType implements IGroupMemberType
    {
        public GroupMemberType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }
}
