/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.util.ConfigHelper;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.constants.IAuthenticationGroupConstants;
import com.sonicsw.mf.mgmtapi.config.gen.AbstractMFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractAuthenticationUserBean;

public class AuthenticationUserBean
extends AbstractAuthenticationUserBean implements IAuthenticationUserBean
{
    public AuthenticationUserBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    protected void saveBean() throws Exception
    {
        if (isNewBean())
        {
            String beanName = getConfigBean().getName();
            int    index    = beanName.lastIndexOf('/');
            String path     = beanName.substring(0, index);

            if(getMgmtBeanFactory().doesConfigurationNameExist(getUserName(), path))
            {
                throw new MgmtException("The specified user name already exist");
            }

            try
            {
                IConfigBean userBean = getConfigBean();
                String      userName = getUserName();

                String id         = userBean.getName();
                String domainPath = id.substring(0, id.lastIndexOf(IMFDirectories.MF_USERS_DIR));
                String groupsPath = domainPath + IMFDirectories.MF_GROUPS_DIR + IMFDirectories.MF_DIR_SEPARATOR;

                if (!ConfigHelper.isAttrValueUniqueWithinFolder(getConfigBean().getConfigServer(),
                                                                groupsPath,
                                                                IAuthenticationGroupConstants.GROUP_NAME_ATTR,
                                                                userName))
                {
                    throw new MgmtException("The specified user name '" + userName + "' already exist - clashes with existing group name");
                }
            }
            catch (MgmtException e)
            {
                throw e;
            }
            catch (Exception e)
            {
                throw new MgmtException("Failed to verify user name uniqueness: " + e.getMessage(), e);
            }
        }

        propagateBean();
        super.saveBean();
    }

    private void propagateBean() throws MgmtException
    {
        // add the user to the PUBLIC group - if  the PUBLIC group is not there, this will generate an
        // exception and the user bean will not get saved

        if (isNewBean())
        {
            String beanName   = getConfigBean().getName();
            int    index      = beanName.lastIndexOf("/_MFUsers");
            String domainPath = beanName.substring(0, index);

            IAuthenticationDomainBean domainBean  = ((AbstractMFMgmtBeanFactory)getMgmtBeanFactory()).getAuthenticationDomainBean(domainPath);
            IAuthenticationGroupBean  publicGroup = null;

            //IL (yak!)
            //It dictates to the ConfigAPI user the following rule: create new domain
            //alwas save first, then add user, otherwise user will not be added
            //to the public group
            try
            {
                publicGroup = domainBean.getGroupBean("PUBLIC");
            }
            catch(MgmtException e) //could happen with new domain that is not saved
            {
                return;
            }

            IAuthenticationGroupBean.IGroupMembersType publicMembers = publicGroup.getGroupMembers();

            IAuthenticationGroupBean.IGroupMemberType userInPublic = publicMembers.createMember();

            userInPublic.setMemberName(getUserName());
            userInPublic.setMemberType("user");

            publicMembers.addMember(getUserName(), userInPublic);

            getMgmtBeanFactory().saveBean(publicGroup);
        }

    }


    @Override
    public void setUserName(String value) throws MgmtException
    {
        try
        {
            IConfigBean bean = getConfigBean();

            String path  = bean.getName();
            int    index = path.lastIndexOf('/') + 1;

            path = path.substring(0, index);
            bean.setName(path + value);

            super.setUserName(value);
        }
        catch (Throwable e)
        {
            throw new MgmtException("Failed setUserName - " + e.getMessage(), e);
        }
    }

    @Override
    public void setPassword(String value) throws MgmtException
    {
        try
        {
            setByteArrayAttribute("PASSWORD", doSHA(value));
        }
        catch(Throwable e)
        {
            throw new MgmtException("Failed to hash password " + e.getMessage(), e);
        }
    }

    private byte[] doSHA(String in) throws Exception
    {
        // Use SHA to generate the digest.
        Class c = Class.forName("progress.message.crypto.SHA");

        progress.message.zclient.ISHA sha = (progress.message.zclient.ISHA)c.newInstance();

        sha.add(in);

        return sha.digest();
    }


}
