/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractComponentCollectionBean;

public class ComponentCollectionBean
extends AbstractComponentCollectionBean implements IComponentCollectionBean
{
    public ComponentCollectionBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    protected void saveBean() throws Exception
    {
        IComponentCollectionBean.IMonitorsSet monitors = null;
        boolean isFailure = false;
        
        try
        {
            monitors = getNotificationMonitors();
            List list = monitors.getKeyNames();
            for (Iterator it = list.iterator(); it.hasNext();)
            {
                IComponentCollectionBean.IMonitorType monitor = monitors.getMonitor((String)it.next());
                
                if(monitor != null)
                {
                    IComponentCollectionBean.INotifList notifs = monitor.getMonitorNotifications();
                    if (notifs.getCount() == 0)
                    {
                        isFailure = true;
                        throw new Exception("Monitor error: Notification list can't be empty. At least one notification required.");
                       
                    }
                }
            }
        }
        catch(Exception ex)
        {  
            if (isFailure)
            {
                throw new Exception(ex.getMessage());
            } 
                
            //otherwise ignore it
        } 
        
        super.saveBean();

    }
    
    public static class NotifListType
    extends AbstractNotifListType implements INotifListType
    {
        public NotifListType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class ComponentsSet
    extends AbstractComponentsSet implements IComponentsSet
    {
        public ComponentsSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class MonitorsSet
    extends AbstractMonitorsSet implements IMonitorsSet
    {
        public MonitorsSet(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class MetricListType
    extends AbstractMetricListType implements IMetricListType
    {
        public MetricListType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class Component
    extends AbstractComponent implements IComponent
    {
        public Component(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class MonitorType
    extends AbstractMonitorType implements IMonitorType
    {
        public MonitorType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class NotifList
    extends AbstractNotifList implements INotifList
    {
        public NotifList(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }
}
