/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.ConfigServerUtility;

import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractDirectoryServiceBean;

public class DirectoryServiceBean
extends AbstractDirectoryServiceBean implements IDirectoryServiceBean
{
    public DirectoryServiceBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    public static class ReplicationParametersType
    extends AbstractReplicationParametersType implements IReplicationParametersType
    {
        public ReplicationParametersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class DsReferencesType
    extends AbstractDsReferencesType implements IDsReferencesType
    {
        public DsReferencesType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class StorageType
    extends AbstractStorageType implements IStorageType
    {
        public StorageType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }
    @Override
    public void loadBean(String viewName, String type)
    throws MgmtException
    {
        super.loadBean(viewName + "/" + ConfigServerUtility.DEFAULT_SUFFIX, type);
    }

    @Override
    public void createBean(String viewPath, String type, String cVersion, String pVersion, boolean setAttributes) throws MgmtException {
        super.createBean(viewPath+ "/" + ConfigServerUtility.DEFAULT_SUFFIX, type, cVersion, pVersion, setAttributes);
        createFolderElement();
    }

    public static class SslParametersType
    extends AbstractSslParametersType implements ISslParametersType
    {
        public SslParametersType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }
    /**
     * Generate the data for a DS bootfile
     * @return the boot file data
     * @throws MgmtException Thrown if there is a problem generating the bootfile.
     */
	@Override
    public String generateBootFile() throws MgmtException {
		 try
	        {
	            return getMgmtBeanFactory().exportDSBootConfiguration(this);
}
	        catch(Exception e)
	        {
	            throw new MgmtException("Failed to generate boot file", e);
	        }
	}
}
