/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.util.URLUtil;

import com.sonicsw.mf.mgmtapi.config.IReplicationConnectionBean;
import com.sonicsw.mf.mgmtapi.config.gen.impl.AbstractReplicationConnectionBean;

public class ReplicationConnectionBean
extends AbstractReplicationConnectionBean implements IReplicationConnectionBean
{
    public ReplicationConnectionBean(MgmtBeanFactory factory)
    {
        super(factory);
    }

    @Override
    public void createBean(String viewPath, String type, String cVersion, String pVersion, boolean setAttributes) throws MgmtException {
        super.createBean(viewPath+"/Replication Connections", type, cVersion, pVersion, setAttributes);
    }

    @Override
    public void loadBean(String viewPath, String type) throws MgmtException {
        super.loadBean(viewPath+"/Replication Connections", type);
    }

    public static class ReplicationConnectionSetType
    extends AbstractReplicationConnectionSetType implements IReplicationConnectionSetType
    {
        public ReplicationConnectionSetType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }
    }

    public static class ReplicationConnectionType
    extends AbstractReplicationConnectionType implements IReplicationConnectionType
    {
        public ReplicationConnectionType(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
        {
            super(parent, name, isNew);
        }

        // If a wrapped IPv6 address is given then it's unwrapped before being stored
        @Override
        public void setBackupAddr(String value)
        throws MgmtException
        {
            super.setBackupAddr(URLUtil.unwrapIPv6Address(value));
        }

        // If a wrapped IPv6 address is given then it's unwrapped before being stored
        @Override
        public void setPrimaryAddr(String value)
        throws MgmtException
        {
            super.setPrimaryAddr(URLUtil.unwrapIPv6Address(value));
        }
    }
}
