package com.sonicsw.mf.mgmtapi.config.test;

import java.util.Iterator;
import java.util.List;

import com.sonicsw.mf.mgmtapi.config.IAuthenticationDomainBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationGroupBean;
import com.sonicsw.mf.mgmtapi.config.IAuthenticationUserBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;

public class AuthenticationTest
{
    public AuthenticationTest()
    {
    }

    public static void main(String[] args)
    {
        MFMgmtBeanFactory factory = new MFMgmtBeanFactory();

        try
        {
            factory.connect("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");

            System.out.println("Test getAuthenticationDomainBeanNames()");

            // List all the existing Authentication Domains
            List names = factory.getAuthenticationDomainBeanNames();

            for(Iterator iter = names.iterator(); iter.hasNext();)
            {
                System.out.println((String)iter.next());
            }

            System.out.println("Test getAuthenticationDomainBean()");

            IAuthenticationDomainBean domain = factory.getAuthenticationDomainBean("/Security/Default Authentication");

            if(domain == null)
            {
               System.out.println("Failed to load bean '/Security/Default Authentication'");
               System.exit(0);
            }

            System.out.println("    Domain name = " + domain.getDomainName());


            System.out.println("Test createUserBean()");

            IAuthenticationUserBean newUser = domain.createUserBean("NewUser", "NewPassword");
            factory.saveBean(newUser);

            IAuthenticationGroupBean newGroup = domain.createGroupBean();
            newGroup.setGroupName("NewGroup");
            newGroup.addMember("NewUser", "user");
            factory.saveBean(newGroup);
            factory.saveAuthenticationDomainBean(domain);
            factory.commit();

            System.out.println("Test getUserBeans()");

            List list = domain.getUserBeans();

            for(Iterator iter = list.iterator(); iter.hasNext();)
            {
                IAuthenticationUserBean user = (IAuthenticationUserBean)iter.next();

                System.out.println("Username = " + user.getUserName());
                System.out.println("Password = " + user.getPassword());
            }



            System.out.println("Test getGroupsBeans()");

            list = domain.getGroupBeans();
            for(Iterator iter = list.iterator(); iter.hasNext();)
            {
                IAuthenticationGroupBean group = (IAuthenticationGroupBean)iter.next();
                System.out.println("GroupName = " + group.getGroupName());
            }

            IAuthenticationGroupBean.IGroupMembersType members = domain.getGroupBean("PUBLIC").getGroupMembers();
            names = members.getKeyNames();

            if (!names.contains("NewUser"))
            {
                System.out.println("ERROR: user <New USer> not added to the PUBLIC group");
            }


            factory.createFolder("/Testing");

            IAuthenticationDomainBean newDomain =
                factory.createAuthenticationDomainBean("/Testing/NewDomain");

            factory.saveAuthenticationDomainBean(newDomain);
            factory.commit();

            //do cleanup
            List beans = domain.getUserBeans();
            for(Iterator iter = beans.iterator(); iter.hasNext();)
            {
                IAuthenticationUserBean user = (IAuthenticationUserBean)iter.next();

                if (user.getUserName().equals("NewUser"))
                {
                    domain.deleteUserBean(user);
                    break;
                }
            }

            beans = domain.getGroupBeans();
            for(Iterator iter = beans.iterator(); iter.hasNext();)
            {
                IAuthenticationGroupBean group = (IAuthenticationGroupBean)iter.next();

                if (group.getGroupName().equals("NewGroup"))
                {
                    domain.deleteGroupBean(group);
                    break;
                }
            }

            factory.deleteAuthenticationDomainBean(newDomain);
            factory.deleteFolder("/Testing");
            factory.commit();


        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }

        System.exit(0);
    }

    /*
    public static void testAddUser(MFMgmtBeanFactory factory) throws Exception
    {
        IAuthenticationDomainBean domain = null;

        try
        {
            domain = factory.createAuthenticationDomainBean("/TestDomain");
            factory.saveAuthenticationDomainBean(domain);
            IAuthenticationUserBean newUser = domain.createUserBean();
            newUser.setUserName("mari");
            newUser.setPassword("davila");
            factory.saveBean(newUser);
            System.out.println("Successfully created a new domain and new user");
        }
        catch (Exception e)
        {
            throw new Exception("ERROR: Unable to create new user in new authentication domain: " + e.getMessage());
        }
        // test that the user ended up in the PUBLIC group

        IAuthenticationGroupBean publicGroup;
        IAuthenticationGroupBean.IGroupMembersType publicMembers;
        try
        {
            publicGroup = domain.getGroupBean("PUBLIC");
            publicMembers = publicGroup.getGroupMembers();
            IAuthenticationGroupBean.IGroupMemberType userInPublic = publicMembers.getMember("mari");
            if (userInPublic != null)
                System.out.println("User mari was correctly added to the PUBLIC group");
        }
        catch (MgmtException e)
        {
            throw new Exception("ERROR: was not able to verify that user mari ended up in the PUBLIC group: " + e.getMessage());
        }
        // CLEANUP
    }
    */

    // run this after testCreateUser

    /*
    public static void testDeleteUser(MFMgmtBeanFactory factory) throws Exception
    {

        IAuthenticationDomainBean domain = null;
        try
        {
            domain = factory.getAuthenticationDomainBean("/TestDomain");
            domain.deleteUserBean(domain.getUserBean("mari"));
            System.out.println("Successfully deleted user mari");
        }
        catch (Exception e)
        {
            throw new Exception("ERROR: Unable to delete user: " + e.getMessage());
        }
        // test that the user ended up in the PUBLIC group

        IAuthenticationGroupBean publicGroup;
        IAuthenticationGroupBean.IGroupMembersType publicMembers;
        try
        {
            publicGroup = domain.getGroupBean("PUBLIC");
            publicMembers = publicGroup.getGroupMembers();
            IAuthenticationGroupBean.IGroupMemberType userInPublic = publicMembers.getMember("mari");
            if (userInPublic != null)
                System.out.println("ERROR: User mari was found in PUBLIC after deletion");
            else
                System.out.println("User mari was correctly deleted from PUBLIC");
        }
        catch (MgmtException e)
        {
            throw new Exception("User mari was correctly deleted from PUBLIC " + e.getMessage());
        }
        // CLEANUP
    }
    */

    /*
    public static void testDeleteAuthDomain(MFMgmtBeanFactory factory) throws Exception
    {
        IAuthenticationDomainBean domain = null;

        try
        {
            domain = factory.getAuthenticationDomainBean("/TestDomain");
            factory.deleteAuthenticationDomainBean(domain);
            System.out.println("Successfully deleted new domain ");
        }
        catch (Exception e)
        {
            throw new Exception("ERROR: Unable to delete new authentication domain: " + e.getMessage());
        }
    }
    */
}