package com.sonicsw.mf.mgmtapi.config.test;

import java.util.HashMap;
import java.util.Iterator;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;

public class ComponentCollectionTest
{
    public ComponentCollectionTest()
    {
    }

    public static void main(String[] args)
    {
        try
        {
            // Need to change to MQ factory but we use MF here to avoid
            // complicated build dependencies...if an MQ (or other) config
            // is found its gonna barf unless u use the MQ factory.
            //
            //com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory factory = new com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory();
            MFMgmtBeanFactory factory = new MFMgmtBeanFactory();

            factory.connect("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
            IComponentCollectionBean temp = null;

            // Check if component collection exist
            try
            {
                temp = factory.getComponentCollectionBean("/MyCompCollection");
            }
            catch(MgmtException e){} //ignore it

            if (temp != null)
            {
                factory.deleteComponentCollectionBean(temp); //delete existed comp collection
            }

            //Get components deployed to the container

            HashMap deployedComps = factory.getDeployedComponents("/Containers/Container1");

            IComponentCollectionBean collection = factory.createComponentCollectionBean("/MyCompCollection");
            IComponentCollectionBean.IComponentsSet components = collection.getComponents();

            Iterator i = deployedComps.keySet().iterator();

            while(i.hasNext())
            {
                String runtimeID = (String)i.next();
                IComponentCollectionBean.IComponent entry = components.createEntry();
                entry.setComponentRuntimeId(runtimeID);
                entry.setConfigRef((IMgmtBeanBase)deployedComps.get(runtimeID));
                components.addEntry(runtimeID, entry);
                System.out.println("Added to collection: " + runtimeID);
            }



            IComponentCollectionBean.IMonitorsSet    sets           = null;
            IComponentCollectionBean.INotifListType  forwNotifTypes = null;
            IComponentCollectionBean.IMetricListType metrics        = null;


            try
            {
                forwNotifTypes = collection.getForwardNotifications(); //could be an exception list is optional
            }
            catch(MgmtException e)
            {
                forwNotifTypes = collection.createForwardNotifications();
                forwNotifTypes.addListItem("system.state.Offline");
                forwNotifTypes.addListItem("system.state.Online");
                collection.setForwardNotifications(forwNotifTypes);
                System.out.println("Added forwarded notifications types:");
                System.out.println("    " + collection.getForwardNotifications().getListItem(0));
                System.out.println("    " + collection.getForwardNotifications().getListItem(1));
            }

            try
            {
                metrics = collection.getMonitorMetrics(); //could be an exception attribute is optional
            }
            catch(MgmtException e)
            {
                metrics = collection.createMonitorMetrics();
                metrics.addListItem("broker.connections.count");
                collection.setMonitorMetrics(metrics);
                System.out.println("Added metrics: ");
                System.out.println("    " + collection.getMonitorMetrics().getListItem(0));
            }

            try
            {
                sets = collection.getNotificationMonitors(); //could be an exception sett is optional
            }
            catch(MgmtException e)
            {
                sets = collection.createNotificationMonitors();

                IComponentCollectionBean.IMonitorType monitor =  sets.createMonitor();
//                monitor.setHighThreshold(100);
//                monitor.setLowThreshold(10);
                monitor.setIntervalSeconds(60);

                IComponentCollectionBean.INotifList notifs = monitor.getMonitorNotifications();
                notifs.addListItem("application.connection.Rejected");

                IComponentCollectionBean.IMonitorType monitor2 =  sets.createMonitor();
                monitor2.setHighThreshold(100);
                monitor2.setLowThreshold(10);
                monitor2.setIntervalSeconds(60);

                sets.addMonitor("monitor1", monitor);
                sets.addMonitor("monitor2", monitor2);

                collection.setNotificationMonitors(sets);

                System.out.println("Added monitor1: ");
//                System.out.println("    HighThreshold:  " + collection.getNotificationMonitors().getMonitor("monitor1").getHighThreshold());
//                System.out.println("    LowThreshold:   " + collection.getNotificationMonitors().getMonitor("monitor1").getLowThreshold());
                System.out.println("    Interval(secs): " + collection.getNotificationMonitors().getMonitor("monitor1").getIntervalSeconds());
                System.out.println("    Notications:    " + collection.getNotificationMonitors().getMonitor("monitor1").getMonitorNotifications().getListItem(0));

                System.out.println("Added monitor2: ");
                System.out.println("    HighThreshold:  " + collection.getNotificationMonitors().getMonitor("monitor2").getHighThreshold());
                System.out.println("    LowThreshold:   " + collection.getNotificationMonitors().getMonitor("monitor2").getLowThreshold());
                System.out.println("    Interval(secs): " + collection.getNotificationMonitors().getMonitor("monitor2").getIntervalSeconds());
                System.out.println("    Notications:    " + collection.getNotificationMonitors().getMonitor("monitor2").getMonitorNotifications().getListItem(0));
            }

            factory.saveComponentCollectionBean(collection);
            factory.commit();

            //Negative test
            try
            {
                IComponentCollectionBean collection1 = factory.getComponentCollectionBean("/MyCompCollection");
                IComponentCollectionBean.IComponentsSet set = collection1.getComponents();
                IComponentCollectionBean.IComponent comp = set.getEntry("Domain1.Container1:ID=AGENT MANAGER");
                collection1.getComponents().addEntry("Domain1.Container1:ID=AGENT", comp ); //should throw exception
            }
            catch(MgmtException e)
            {
                System.out.println("Expected error: " + e.getMessage());
            }

            factory.disconnect();
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }
}

