/*
 * Created on Mar 23, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.sonicsw.mf.mgmtapi.config.test;

import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;

/**
 * @author irene
 *
 * Test Container FT 
 */
public class ContainerFT_Test 
{
    public static void main(String[] args)
    {
        try
        {
            MFMgmtBeanFactory factory = new MFMgmtBeanFactory();

            factory.connect("Domain1", "localhost:2506", "Administrator", "Administrator"); //c:\\sonicmq501-803\\ds.xml

            //first do cleanup
            IContainerBean temp = null;
            try
            {
                temp = factory.getContainerBean("/Test/PrimaryContainer");
                factory.deleteContainerBean(temp);
                factory.commit();
            }
            catch(Exception e){} //expected if container doesn't exist
            
            IContainerBean primary;
            IContainerBean backup;

            try
            {
               factory.createFolder("/Test");
            }
            catch(Exception e)
            {
               System.out.println("Expected if folder exists:   " + e.getMessage() );
            }

            primary = factory.createContainerBean("/Test/PrimaryContainer");
            factory.saveContainerBean(primary);
            factory.commit();

            primary = factory.getContainerBean("/Test/PrimaryContainer");
            backup = primary.createBackupContainer("/Test/BackupContainer");
            
            factory.saveContainerBean(primary); //will save both primary and created backup
            
            //Commit changes to DS
            factory.commit();
            
            //Lets see what we created
            primary = factory.getContainerBean("/Test/PrimaryContainer");
            backup = factory.getContainerBean("/Test/BackupContainer");
            
            System.out.println("Primary container info:");
            System.out.println("    FT role: " + primary.getFaultToleranceParameters().getFaultToleranceRole());
            System.out.println("    FT peer: "  + primary.getFaultToleranceParameters().getFaultTolerancePeerRef());
            System.out.println("    FT interval: " + primary.getFaultToleranceParameters().getFaultDetectionInterval());
            System.out.println("    FT timeout: " + primary.getFaultToleranceParameters().getFaultDetectionTimeout());
            
            //Verify that illegal components can't be deployed
            IContainerBean.IComponentsType pComponents = primary.getComponents();
            IContainerBean.IStartupParams ds_entry = pComponents.createEntry();
            ds_entry.setAutoStart(false);
            ds_entry.setConfigRef(factory.getDirectoryServiceBean("/Framework Components/DIRECTORY SERVICE"));
            
            try
            {
                pComponents.addEntry("My DS", ds_entry);
            }
            catch (Exception e)
            {
                System.out.println("Expected error: " + e.getMessage());
            }
            
            //Verify that user can't reset FT Role using Config API
            try
            {
               primary.getFaultToleranceParameters().setFaultToleranceRole("");
            }
            catch(Exception e)
            {
                System.out.println("Expected error: " + e.getMessage());
            }
            
            System.out.println("Backup container info:");
            System.out.println("    FT role: " + backup.getFaultToleranceParameters().getFaultToleranceRole());
            System.out.println("    FT peer: "  + backup.getFaultToleranceParameters().getFaultTolerancePeerRef());
            System.out.println("    FT interval: " + backup.getFaultToleranceParameters().getFaultDetectionInterval());
            System.out.println("    FT timeout: " + backup.getFaultToleranceParameters().getFaultDetectionTimeout());
            
            //Verify that illegal components can't be deployed
            IContainerBean.IComponentsType bComponents = backup.getComponents();
            IContainerBean.IStartupParams am_entry = bComponents.createEntry();
            am_entry.setAutoStart(false);
            am_entry.setConfigRef(factory.getAgentManagerBean("/Framework Components/AGENT MANAGER"));
            
            try
            {
                bComponents.addEntry("My AM", am_entry);
            }
            catch (Exception e)
            {
                System.out.println("Expected error: " + e.getMessage());
            }
            
            //Verify that user can't reset FT Role using Config API
            try
            {
                backup.getFaultToleranceParameters().setFaultToleranceRole("");
            }
            catch(Exception e)
            {
                System.out.println("Expected error: " + e.getMessage());
            }
            
            factory.deleteContainerBean(backup);
            
            System.out.println("Backup container deleted, lets check primary role -" +
                    "it should be reset to an empty string;indicates that container 'Not Fault Tolerant'");
            primary = factory.getContainerBean("/Test/PrimaryContainer");
            System.out.println("Primary container info:");
            System.out.println("    FT role: " + primary.getFaultToleranceParameters().getFaultToleranceRole()); 
            factory.disconnect();
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

}
