package com.sonicsw.mf.mgmtapi.config.test;

import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IDirectoryServiceBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;


public class DeploymentTest
{

  public DeploymentTest()
  {
  }

  public static void main(String[] args)
    {
        try
        {
            MFMgmtBeanFactory factory = new MFMgmtBeanFactory();

            factory.connect("Domain1", "c:\\irene_FS\\vobs_mgmt\\mgmt20\\ds.xml", "", ""); //c:\\sonicmq501-803\\ds.xml

            IContainerBean container1;

            try
            {
               factory.createFolder("/Test");
            }
            catch(Exception e)
            {
               System.out.println("Expected if folder exists:   " + e.getMessage() );
            }

            try
            {
                container1 = factory.getContainerBean("/Test/Test1");

            }
            catch(Exception e)
            {
                container1 = factory.createContainerBean("/Test/Test1");
                factory.saveContainerBean(container1);
            }

            IAgentManagerBean manager;
            try
            {
                manager = factory.getAgentManagerBean("/Test/TestAgentManager");
            }
            catch(Exception e)
            {
                manager = factory.createAgentManagerBean("/Test/TestAgentManager");
                factory.saveAgentManagerBean(manager);
            }
            IDirectoryServiceBean ds;

            try
            {
                ds = factory.getDirectoryServiceBean("/Test/TestDirectoryService");
            }
            catch(Exception e)
            {
                ds = factory.createDirectoryServiceBean("/Test/TestDirectoryService");
                factory.saveDirectoryServiceBean(ds);
            }


            IContainerBean container = factory.getContainerBean("/Test/Test1");

            IContainerBean.IComponentsType components = container.getComponents();

            IContainerBean.IStartupParams entry = components.createEntry();
            entry.setAutoStart(false);
            entry.setConfigRef(manager);
            try
            {
                components.addEntry("MyAgent", entry);
            }catch(MgmtException e) { System.out.println("Expected error - AgentManager can be deployed only with \"AGENT MANAGER\" name." );}

            components.addEntry("AGENT MANAGER", entry);

            IContainerBean.IStartupParams entryDS = components.createEntry();
            entryDS.setAutoStart(false);
            entryDS.setConfigRef(ds);
            components.addEntry("DIRECTORY SERVICE", entryDS);

            factory.saveContainerBean(container);

            container = factory.getContainerBean("/Test/Test1");

            //Verify what we saved

            if(container == null)
            {
                System.out.println("Failed to load container bean");
            }
            else
            {
                //Verify that we can't deploy MF_AGENT_MANAGER twice
                try
                {
                    IAgentManagerBean defaultAM = factory.getAgentManagerBean("/Framework Components/AGENT MANAGER");
                    components = container.getComponents();

                    entry = components.createEntry();
                    entry.setAutoStart(false);
                    entry.setConfigRef(defaultAM);
                }
                catch(MgmtException e) { System.out.println("Expected error: " + e.getMessage()); }

                System.out.println("Classname = " + container.getClassname());
                System.out.println("ContainerName = " + container.getContainerName());
                System.out.println("DomainName = " + container.getDomainName());
                System.out.println("CommandLine = " + container.getCommandLine());
                System.out.println("LogToFile = " + container.getLogToFile());

                components = container.getComponents();

                List cNames = components.getKeyNames();

                for(Iterator iter = cNames.iterator(); iter.hasNext(); )
                {
                    String name = (String)iter.next();

                    IContainerBean.IStartupParams startup = components.getEntry(name);

                    IMgmtBeanBase base = startup.getConfigRef();

                    if(base == null)
                    {
                        System.out.println("Bean for " + name + " not found");
                    }
                    else if(base instanceof IAgentManagerBean)
                    {
                        IAgentManagerBean am = (IAgentManagerBean)base;

                        System.out.println(name + " - classname = " + am.getClassname());
                    }
                }

                boolean log = container.getLogToFile();

                container.setLogToFile(!log);

                factory.saveContainerBean(container);

            }
            factory.disconnect();
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

}