package com.sonicsw.mf.mgmtapi.config.test;

import java.util.Properties;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.util.ConfigHelper;

import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.ILoggerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;

public class LoggerBeanTest
{
    private static String TEST_PATH = "/Test";
    private static String LOGGER_VIEW_PATH = TEST_PATH + "/Logger";
    private static String CONTAINER_VIEW_PATH = TEST_PATH + "/Container";
    private static String COLLECTION_VIEW_PATH = TEST_PATH + "/Collection";
    
    private MgmtBeanFactory m_domain;
    
    private LoggerBeanTest(MgmtBeanFactory domain)
    {
        m_domain = domain;
    }
    
    protected MgmtBeanFactory getDomain()
    {
        return m_domain;
    }
    
    public void init(Properties args)
    throws Exception
    {
        System.out.println("Connecting");
        
        String domain   = args.getProperty("DOMAIN");
        String url      = args.getProperty("URL");
        String username = args.getProperty("USERNAME");
        String password = args.getProperty("PASSWORD");
        
        getDomain().connect(domain, url, username, password);

        System.out.println("Connected");
        
        createFolder(TEST_PATH);
    }
    
    public void cleanup()
    throws Exception
    {
        System.out.println("DONE");

        getDomain().disconnect();
        
        m_domain = null;
    }
    
    private void removeContainerBean(String viewPath)
    throws Exception
    {
        IContainerBean bean = null;
        
        try
        {
            bean = ((MFMgmtBeanFactory)getDomain()).getContainerBean(viewPath);
        }
        catch (Exception e)
        {
        }
        
        if (bean != null)
        {
            ((MFMgmtBeanFactory)getDomain()).deleteContainerBean(bean);
        }
    }
    
    private void removeLoggerBean(String viewPath)
    throws Exception
    {
        ILoggerBean bean = null;
        
        try
        {
            bean = ((MFMgmtBeanFactory)getDomain()).getLoggerBean(viewPath);
        }
        catch (Exception e)
        {
        }
        
        if (bean != null)
        {
            ((MFMgmtBeanFactory)getDomain()).deleteLoggerBean(bean);
        }
    }
    
    private void removeCollectionBean(String viewPath)
    throws Exception
    {
        IComponentCollectionBean bean = null;
        
        try
        {
            bean = ((MFMgmtBeanFactory)getDomain()).getComponentCollectionBean(viewPath);
        }
        catch (Exception e)
        {
        }
        
        if (bean != null)
        {
            ((MFMgmtBeanFactory)getDomain()).deleteComponentCollectionBean(bean);
        }
    }
    
    private void createFolder(String path)
    throws MgmtException
    {
        try
        {
            getDomain().listFolders(path + "/");
        }
        catch (MgmtException e)
        {
            System.out.println("Creating '" + path + "' folder");
            getDomain().createFolder(path);
        }
    }
    
    private void createCollection(String path)
    throws Exception
    {
        removeCollectionBean(path);  // Remove old collection configuration (if present)
        
        System.out.println("Creating test collection configuration");
        
        IComponentCollectionBean collection = ((MFMgmtBeanFactory)getDomain()).createComponentCollectionBean(path);

        ((MFMgmtBeanFactory)getDomain()).saveComponentCollectionBean(collection);
        getDomain().commit();
    }
    
    private void createLogger(String path)
    throws Exception
    {
        removeLoggerBean(path);  // Remove old logger component (if present)
        
        System.out.println("Creating test logger configuration");
        ILoggerBean logger = ((MFMgmtBeanFactory)getDomain()).createLoggerBean(path);
//        ILoggerBean.IProductInformationType productInfo = logger.getProductInformation();
//        productInfo.setControlNumber("p9gd9bpyjc8edq3");

        // set the collection monitor's runtime id here...obtain this using the Runtime API ?
        logger.setCollectionsMonitorRuntimeId("<CM runtimeID>");
        logger.setLog4jConfigurationFilePath("a valid configuration file path");

        logger.getComponentCollections().addEntry("foo", ((MFMgmtBeanFactory)getDomain()).getComponentCollectionBean(COLLECTION_VIEW_PATH));
        
        ((MFMgmtBeanFactory)getDomain()).saveLoggerBean(logger);
        getDomain().commit();
    }
  
    private void createContainer(String path)
    throws Exception
    {
        removeContainerBean(path);  // Remove old container (if present)
        
        System.out.println("Creating test container configuration");
        IContainerBean container = ((MFMgmtBeanFactory)getDomain()).createContainerBean(path);

        ((MFMgmtBeanFactory)getDomain()).saveContainerBean(container);
        getDomain().commit();
    }
    
    private void deployToContainer(String containerPath, String componentPath, String componentRuntimeId)
    throws Exception
    {
        System.out.println("Deploying '" + componentPath + "' to Container '" + containerPath + "' as '" + componentRuntimeId + "'");

        IContainerBean container = ((MFMgmtBeanFactory)getDomain()).getContainerBean(containerPath);
        IMgmtBeanBase  component = ((MFMgmtBeanFactory)getDomain()).getBean(componentPath);

        IContainerBean.IComponentsType components = container.getComponents();

        IContainerBean.IStartupParams entry = components.createEntry();
        
        entry.setAutoStart(false);
        entry.setConfigRef(component);
        
        components.addEntry(componentRuntimeId, entry);
        
        ((MFMgmtBeanFactory)getDomain()).saveContainerBean(container);
        getDomain().commit();
    }
    
    public static void main(String[] args)
    {
        MFMgmtBeanFactory domain = new MFMgmtBeanFactory();

        LoggerBeanTest test = new LoggerBeanTest(domain);
        
        try
        {
            Properties cArgs = new Properties();
            cArgs.setProperty("DOMAIN",   "Domain1");
            cArgs.setProperty("URL",      "localhost:2506");
            cArgs.setProperty("USERNAME", "Administrator");
            cArgs.setProperty("PASSWORD", "Administrator");         //NOSONAR Actual password is not setting.
            
            test.init(cArgs);

            test.createCollection(COLLECTION_VIEW_PATH);
            //Should really be creating a Collection Monitor component here!!!
            test.createLogger(LOGGER_VIEW_PATH);
            test.createContainer(CONTAINER_VIEW_PATH);
            test.deployToContainer(CONTAINER_VIEW_PATH, LOGGER_VIEW_PATH, "Test Logger");
        }
        catch(Exception e)
        {
            ConfigHelper.printExceptionInfo(e);
        }
        finally
        {
            try { test.cleanup(); } catch (Exception e) { e.printStackTrace(); }
        }
    }
}
