package com.sonicsw.mf.mgmtapi.config.test;

import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;

import com.sonicsw.mf.mgmtapi.config.IAgentManagerBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;

public class MFDomainTest
{
    public static void main(String[] args)
    {
        try
        {
            MFMgmtBeanFactory factory = new MFMgmtBeanFactory();

            factory.connect("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");

            List names = factory.getContainerBeanNames();

            for(Iterator iter = names.iterator(); iter.hasNext(); )
            {
                String name = (String)iter.next();
                IContainerBean container = factory.getContainerBean(name);
                System.out.println("Container=" + name);
            }

            IContainerBean container1;

            try
            {
               factory.createFolder("/Test");
            }
            catch(Exception e)
            {
               System.out.println("Expected if folder exists:   " + e.getMessage() );
            }

            try
            {
                container1 = factory.getContainerBean("/Test/Test1");

                if(container1 != null)
                {
                    factory.deleteContainerBean(container1);
                }
            }
            catch(Exception e)
            {
            }

            container1 = factory.createContainerBean("/Test/Test1");
            factory.saveContainerBean(container1);

            IContainerBean container2;

            try
            {
                container2 = factory.getContainerBean("/Test/Test2");

                if(container2 != null)
                {
                    factory.deleteContainerBean(container2);
                }
            }
            catch(Exception e)
            {
            }

            container2 = factory.createContainerBean("/Test/Test2");

            factory.saveBeans(new IContainerBean[] { container1, container2 });

            //Verify what we saved

            IContainerBean container = factory.getContainerBean("/Test/Test1");

            if(container == null)
            {
                System.out.println("Failed to load container bean");
            }
            else
            {
                System.out.println("Classname = " + container.getClassname());
                System.out.println("ContainerName = " + container.getContainerName());
                System.out.println("DomainName = " + container.getDomainName());
                System.out.println("CommandLine = " + container.getCommandLine());
                System.out.println("LogToFile = " + container.getLogToFile());

                IContainerBean.IComponentsType components = container.getComponents();

                List cNames = components.getKeyNames();

                for(Iterator iter = cNames.iterator(); iter.hasNext(); )
                {
                    String name = (String)iter.next();

                    IContainerBean.IStartupParams startup = components.getEntry(name);

                    IMgmtBeanBase base = startup.getConfigRef();

                    if(base == null)
                    {
                        System.out.println("Bean for " + name + " not found");
                    }
                    else if(base instanceof IAgentManagerBean)
                    {
                        IAgentManagerBean am = (IAgentManagerBean)base;

                        System.out.println(name + " - classname = " + am.getClassname());
                    }
                }

                boolean log = container.getLogToFile();

                container.setLogToFile(!log);

                factory.saveContainerBean(container);

            }
            factory.disconnect();
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }
}