// This file has been generated for component class com.sonicsw.mf.framework.daemon.ActivationDaemon (100)
// Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of an ActivationDaemon.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createActivationDaemonProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html">ActivationDaemon Notifications</a>,
 *   </dd>
 * </dl>
 */
public interface IActivationDaemonProxy
{
    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification system.state.Activate.
     * <p>
     * Description: Child container (re)launch complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Activate"><code>system.state.Activate</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ACTIVATE_NOTIFICATION_ID = "system.state.Activate";

    /**
     * Notification type constant for the notification system.state.Deactivate.
     * <p>
     * Description: Child container shutdown complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Deactivate"><code>system.state.Deactivate</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_DEACTIVATE_NOTIFICATION_ID = "system.state.Deactivate";

    /**
     * Notification type constant for the notification system.state.Failure.
     * <p>
     * Description: Child container process has died.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Failure"><code>system.state.Failure</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_FAILURE_NOTIFICATION_ID = "system.state.Failure";

    /**
     * Notification type constant for the notification system.state.Offline.
     * <p>
     * Description: Component stop complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_OFFLINE_NOTIFICATION_ID = "system.state.Offline";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of an ActivationDaemon component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by an ActivationDaemon are:
     * <ul>
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of an ActivationDaemon component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by an ActivationDaemon are:
     * <ul>
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - child container exec
     * <li>32 - child container stdout
     * <li>64 - child container stderr
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - child container exec
     * <li>32 - child container stdout
     * <li>64 - child container stderr
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the activate operation.
     * <p>
     * (Re)Activates a child container according to the schedule and activation rules defined for the container.
     * <p>
     * Impact: ACTION
     *
     * @param id Runtime identity of the container to activate (e.g. "Domain1.Container1")
     */
    public void activate(java.lang.String id);

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the deactivate operation.
     * <p>
     * Shuts down an active child container and disables the child from being re-launched due to the activation schedule and rules defined for the container.
     * <p>
     * Impact: ACTION
     *
     * @param id Runtime identity of the container to deactivate (e.g. "Domain1.Container1")
     */
    public void deactivate(java.lang.String id);

    /**
     * Invokes the getChildStates operation.
     * <p>
     * Gets the runtime state for all of the child containers managemed by this daemon.
     * <p>
     * Impact: INFO
     */
    public com.sonicsw.mf.common.runtime.IChildContainerState[] getChildStates();

    /**
     * Invokes the launch operation.
     * <p>
     * Dynamically launches the specified child container.
     * <p>
     * Impact: ACTION
     *
     * @param configID The configuration identity of the container to launch.
     */
    public void launch(java.lang.String configID);

    /**
     * Invokes the reload operation.
     * <p>
     * Asynchronously reload the component and restart the component if it was previously online.
     * <p>
     * Impact: ACTION
     */
    public void reload();

    /**
     * Invokes the start operation.
     * <p>
     * Start providing service.
     * <p>
     * Impact: ACTION
     * @see #stop()
     */
    public void start();

    /**
     * Invokes the stop operation.
     * <p>
     * Stop providing service.
     * <p>
     * Impact: ACTION
     * @see #start()
     */
    public void stop();

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * An ActivationDaemon component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Activate"><code>system.state.Activate</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Deactivate"><code>system.state.Deactivate</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Failure"><code>system.state.Failure</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/ActivationDaemonNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
