// This file has been generated for component class com.sonicsw.mf.framework.manager.AgentManager (105)
// Copyright (c) 2002-2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of an AgentManager.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createAgentManagerProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <p>
 * <b>Note:</b> The Agent Manager receives and forwards all system state notifications published by all deployed components.
 * Subscriptions to such notifications are allowed even though the Agent Manager does not describe those notifications in it's MBeanInfo.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html">AgentManager Notifications</a>,
 *     <a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html">AgentManager Metrics</a>
 *   </dd>
 * </dl>
 */
public interface IAgentManagerProxy
{
    //
    // Useful constants
    //

    /**
     * The well known global component identity for this singleton component.
     */
    public static final String GLOBAL_ID = "AGENT MANAGER";

    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification system.alert.system.pollthreads.CurrentPoolSize.
     * <p>
     * Description: Alert for metric system.pollthreads.CurrentPoolSize
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AMNotifications.html#system.alert.system.pollthreads.CurrentPoolSize"><code>system.alert.system.pollthreads.CurrentPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_NOTIFICATION_ID = "system.alert.system.pollthreads.CurrentPoolSize";

    /**
     * Notification type constant for the notification system.alert.system.pollthreads.PoolWaits.
     * <p>
     * Description: Alert for metric system.pollthreads.PoolWaits
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AMNotifications.html#system.alert.system.pollthreads.PoolWaits"><code>system.alert.system.pollthreads.PoolWaits</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_POLLTHREADS_POOLWAITS_NOTIFICATION_ID = "system.alert.system.pollthreads.PoolWaits";

    /**
     * Notification type constant for the notification system.log.Failure.
     * <p>
     * Description: Failure to write to the centralized log file.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.log.Failure"><code>system.log.Failure</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_LOG_FAILURE_NOTIFICATION_ID = "system.log.Failure";

    /**
     * Notification type constant for the notification system.log.Threshold.
     * <p>
     * Description: The size of the current centralized log has reached or exceeded (by a 10% increment) the configured threshold.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.log.Threshold"><code>system.log.Threshold</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_LOG_THRESHOLD_NOTIFICATION_ID = "system.log.Threshold";

    /**
     * Notification type constant for the notification system.state.Failover.
     * <p>
     * Description: Standby service has failed over to become the active service.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_FAILOVER_NOTIFICATION_ID = "system.state.Failover";

    /**
     * Notification type constant for the notification system.state.Offline.
     * <p>
     * Description: Component stop complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_OFFLINE_NOTIFICATION_ID = "system.state.Offline";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    /**
     * Notification type constant for the notification system.state.Startup.
     * <p>
     * Description: Agent/Container startup completed.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Startup"><code>system.state.Startup</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_STARTUP_NOTIFICATION_ID = "system.state.Startup";

    /**
     * Notification type constant for the notification system.state.Unreachable.
     * <p>
     * Description: Container unreachable.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Unreachable"><code>system.state.Unreachable</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_UNREACHABLE_NOTIFICATION_ID = "system.state.Unreachable";

    //
    // Metric indentity constants
    //

    /**
     * Metric identity constant for the metric system.pollthreads.CurrentPoolSize.
     * <p>
     * Description: Size of thread pool used to poll for container(s) state.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.CurrentPoolSize"><code>system.pollthreads.CurrentPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "pollthreads",
        "CurrentPoolSize"
    });

    /**
     * Metric identity constant for the metric system.pollthreads.MaxPoolSize.
     * <p>
     * Description: Maximum size of thread pool used to poll for container(s) state since last metrics reset.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.MaxPoolSize"><code>system.pollthreads.MaxPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "pollthreads",
        "MaxPoolSize"
    });

    /**
     * Metric identity constant for the metric system.pollthreads.PoolWaits.
     * <p>
     * Description: Number of times requests for container state had to wait because a pooled thread was not immediately available to service a poll request. Evaluated over the last 30 minutes.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.PoolWaits"><code>system.pollthreads.PoolWaits</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "pollthreads",
        "PoolWaits"
    });

    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of an AgentManager component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by an AgentManager are:
     * <ul>
     * <li><a href="#getAllowFailover()"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getFaultToleranceRole()"><code>FaultToleranceRole</code></a> (java.lang.String)
     * <li><a href="#getFaultTolerantState()"><code>FaultTolerantState</code></a> (java.lang.Short)
     * <li><a href="#getFaultTolerantStateString()"><code>FaultTolerantStateString</code></a> (java.lang.String)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getLogFile()"><code>LogFile</code></a> (java.lang.String)
     * <li><a href="#getLogFileRolloverSizeThreshold()"><code>LogFileRolloverSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#getLogFileRolloverTimeInterval()"><code>LogFileRolloverTimeInterval</code></a> (java.lang.Integer)
     * <li><a href="#getLogFileSize()"><code>LogFileSize</code></a> (java.lang.Long)
     * <li><a href="#getLogFileSizeThreshold()"><code>LogFileSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#getMaxPollingThreads()"><code>MaxPollingThreads</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsCollectionInterval()"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsRefreshInterval()"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMinPollingThreads()"><code>MinPollingThreads</code></a> (java.lang.Integer)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getRepeatMetricAlerts()"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(javax.management.AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of an AgentManager component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by an AgentManager are:
     * <ul>
     * <li><a href="#setAllowFailover(java.lang.Boolean)"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#setLogFile(java.lang.String)"><code>LogFile</code></a> (java.lang.String)
     * <li><a href="#setLogFileRolloverSizeThreshold(java.lang.Long)"><code>LogFileRolloverSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#setLogFileSizeThreshold(java.lang.Long)"><code>LogFileSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#setLogFileRolloverTimeInterval(java.lang.Integer)"><code>LogFileRolloverTimeInterval</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsCollectionInterval(java.lang.Integer)"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsRefreshInterval(java.lang.Integer)"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#setRepeatMetricAlerts(java.lang.Boolean)"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(java.lang.String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the AllowFailover attribute.
     *
     * @return When this Agent Manager is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #setAllowFailover(java.lang.Boolean)
     */
    public java.lang.Boolean getAllowFailover();

    /**
     * Sets the value of the AllowFailover attribute.
     *
     * @param value When this Agent Manager is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #getAllowFailover()
     */
    public void setAllowFailover(java.lang.Boolean value);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the FaultToleranceRole attribute.
     *
     * @return The fault tolerant role of the AM (primary or backup) or null if not fault tolerant.
     */
    public java.lang.String getFaultToleranceRole();

    /**
     * Gets the value of the FaultTolerantState attribute.
     *
     * @return The current fault tolerant state of this Agent Manager.
     */
    public java.lang.Short getFaultTolerantState();

    /**
     * Gets the value of the FaultTolerantStateString attribute.
     *
     * @return The description of the current fault tolerant state of this Agent Manager.
     */
    public java.lang.String getFaultTolerantStateString();

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the LogFile attribute.
     *
     * @return The directory pathname of the centralized log file. Defaults to {<domain>.log} in the container's working directory.
     *
     * @see #setLogFile(java.lang.String)
     */
    public java.lang.String getLogFile();

    /**
     * Sets the value of the LogFile attribute.
     *
     * @param value The directory pathname of the centralized log file. Defaults to {<domain>.log} in the container's working directory.
     *
     * @see #getLogFile()
     */
    public void setLogFile(java.lang.String value);

    /**
     * Gets the value of the LogFileRolloverSizeThreshold attribute.
     *
     * @return If the current centralized log file size equals or exceeds this threshold at midnight, then the Agent Manager will roll over the old contents to an archive file and create a new empty centralized log file.
     *
     * @see #setLogFileRolloverSizeThreshold(java.lang.Long)
     */
    public java.lang.Long getLogFileRolloverSizeThreshold();

    /**
     * Sets the value of the LogFileRolloverSizeThreshold attribute.
     *
     * @param value If the current centralized log file size equals or exceeds this threshold at midnight, then the Agent Manager will roll over the old contents to an archive file and create a new empty centralized log file.
     *
     * @see #getLogFileRolloverSizeThreshold()
     */
    public void setLogFileRolloverSizeThreshold(java.lang.Long value);

    /**
     * Gets the value of the LogFileRolloverTimeInterval attribute in minutes.
     *
     * @return This log file rollover time interval attribute is used to configure the next schedule time in minutes for the log file rollover to happen.
     *
     * @see #setLogFileRolloverTimeInterval(java.lang.Integer)
     */
    public java.lang.Integer getLogFileRolloverTimeInterval();

    /**
     * Sets the value of the LogFileRolloverTimeInterval attribute in minutes.
     *
     * @param value This log file rollover time interval attribute is used to configure the next schedule time in minutes for the log file rollover to happen.
     *
     * @see #getLogFileRolloverTimeInterval()
     */
    public void setLogFileRolloverTimeInterval(java.lang.Integer value);

    /**
     * Gets the value of the LogFileSize attribute.
     *
     * @return The number of bytes written to the centralized log file. This value gets reset to 0 when the log is cleared or archived.
     */
    public java.lang.Long getLogFileSize();

    /**
     * Gets the value of the LogFileSizeThreshold attribute.
     *
     * @return Once size of the the centralized log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent Manager will send a warning notification.
     *
     * @see #setLogFileSizeThreshold(java.lang.Long)
     */
    public java.lang.Long getLogFileSizeThreshold();

    /**
     * Sets the value of the LogFileSizeThreshold attribute.
     *
     * @param value Once size of the the centralized log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent Manager will send a warning notification.
     *
     * @see #getLogFileSizeThreshold()
     */
    public void setLogFileSizeThreshold(java.lang.Long value);

    /**
     * Gets the value of the MaxPollingThreads attribute.
     *
     * @return The maximum number of threads that the Agent Manager can create to poll containers for their state.
     */
    public java.lang.Integer getMaxPollingThreads();

    /**
     * Gets the value of the MetricsCollectionInterval attribute.
     *
     * @return Metrics collection interval (in minutes)
     *
     * @see #setMetricsCollectionInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsCollectionInterval();

    /**
     * Sets the value of the MetricsCollectionInterval attribute.
     *
     * @param value Metrics collection interval (in minutes)
     *
     * @see #getMetricsCollectionInterval()
     */
    public void setMetricsCollectionInterval(java.lang.Integer value);

    /**
     * Gets the value of the MetricsRefreshInterval attribute.
     *
     * @return Metrics refresh interval (in seconds)
     *
     * @see #setMetricsRefreshInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsRefreshInterval();

    /**
     * Sets the value of the MetricsRefreshInterval attribute.
     *
     * @param value Metrics refresh interval (in seconds)
     *
     * @see #getMetricsRefreshInterval()
     */
    public void setMetricsRefreshInterval(java.lang.Integer value);

    /**
     * Gets the value of the MinPollingThreads attribute.
     *
     * @return The minimum number of threads that the Agent Manager will cache for reuse to poll containers for their state.
     */
    public java.lang.Integer getMinPollingThreads();

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the RepeatMetricAlerts attribute.
     *
     * @return Repeat metric alert notifications.
     *
     * @see #setRepeatMetricAlerts(java.lang.Boolean)
     */
    public java.lang.Boolean getRepeatMetricAlerts();

    /**
     * Sets the value of the RepeatMetricAlerts attribute.
     *
     * @param value Repeat metric alert notifications.
     *
     * @see #getRepeatMetricAlerts()
     */
    public void setRepeatMetricAlerts(java.lang.Boolean value);

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - status polling
     * <li>32 - container unreachable
     * <li>64 - forwarded notifications
     * <li>128 - fault detection
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - status polling
     * <li>32 - container unreachable
     * <li>64 - forwarded notifications
     * <li>128 - fault detection
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the clearLogFile operation.
     * <p>
     * Clear the centralized log file.
     * <p>
     * Impact: ACTION
     */
    public void clearLogFile();

    /**
     * Invokes the disableAlerts operation.
     * <p>
     * Disable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.CurrentPoolSize"><code>system.pollthreads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.PoolWaits"><code>system.pollthreads.PoolWaits</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to disable.
     *
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void disableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the disableMetrics operation.
     * <p>
     * Disable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.CurrentPoolSize"><code>system.pollthreads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.MaxPoolSize"><code>system.pollthreads.MaxPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.PoolWaits"><code>system.pollthreads.PoolWaits</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the enableAlerts operation.
     * <p>
     * Enable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.CurrentPoolSize"><code>system.pollthreads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.PoolWaits"><code>system.pollthreads.PoolWaits</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to enable.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void enableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the enableMetrics operation.
     * <p>
     * Enable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.CurrentPoolSize"><code>system.pollthreads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.MaxPoolSize"><code>system.pollthreads.MaxPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerMetrics.html#system.pollthreads.PoolWaits"><code>system.pollthreads.PoolWaits</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getActiveMetrics operation.
     * <p>
     * Gets the the list of metrics currently active in this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getCollectiveState operation.
     * <p>
     * Gets the runtime state of the given collection as recorded by the Agent Manager.
     * <p>
     * Impact: INFO
     *
     * @param configID The configuration ID of the collection for which the status is being sought. Returns an array of IContainerState or IComponentState instances that describe the state of the given collection. If an item in the collection no longer represents a known runtime identity then no runtime status will be provided in the returned array.
     */
    public com.sonicsw.mf.common.runtime.IState[] getCollectiveState(java.lang.String configID);

    /**
     * Invokes the getCollectiveState operation.
     * <p>
     * Gets the runtime state of the whole domain as recorded by the Agent Manager. Returns an array of IContainerState instances.
     * <p>
     * Impact: INFO
     */
    public com.sonicsw.mf.common.runtime.IState[] getCollectiveState();

    /**
     * Invokes the getCollectiveState operation.
     * <p>
     * Gets the runtime state for the given list of containers as recorded by the Agent Manager. Returns an array of IContainerState instances.
     * <p>
     * Impact: INFO
     *
     * @param runtimeIds The list of the containers runtime identities for which the status is being sought.
     */
    public com.sonicsw.mf.common.runtime.IState[] getCollectiveState(java.lang.String[] runtimeIds);

    /**
     * Invokes the getEnabledAlerts operation.
     * <p>
     * Get all metric threshold alerts enabled by this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     */
    public com.sonicsw.mf.common.metrics.IAlert[] getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getEnabledMetrics operation.
     * <p>
     * Get the list of metric patterns that have been enabled for this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getLogExtract operation.
     * <p>
     * Reads the requested bytes from the centralized log file and returns them as a String.
     * <p>
     * Impact: INFO
     *
     * @param fromPosition The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions.
     * @param readLength The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.
     */
    public java.lang.String getLogExtract(java.lang.Long fromPosition, java.lang.Long readLength);

    /**
     * Invokes the getLogExtractAndLogFileSize operation.
     * <p>
     * Reads the requested bytes from the centralized log file and returns them as a String encapsulated with the current log size. The current log size is the size of the current log file plus the sum of all available prior versions. When evaluating log output to be read, the current log file and previous versions (due to rollover activity) will be effectively viewed as a single file.
     * <p>
     * Impact: INFO
     *
     * @param fromPosition The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions.
     * @param readLength The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.
     */
    public javax.management.openmbean.CompositeData getLogExtractAndLogFileSize(java.lang.Long fromPosition, java.lang.Long readLength);

    /**
     * Invokes the getMetricsData operation.
     * <p>
     * Gets metric values for a given set of metrics. If a requested metric was not enabled or is otherwise unknown, then no data for that metric will be included in the results.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of active metrics, either individual metrics or instances.
     * @param returnTriggeredAlerts If true, each metric returned should include a list of triggered (exceeded) alerts for these metrics.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricsData getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids, java.lang.Boolean returnTriggeredAlerts);

    /**
     * Invokes the getMetricsInfo operation.
     * <p>
     * Gets the meta-data for all metrics supported by this component.
     * <p>
     * Impact: INFO
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricInfo[] getMetricsInfo();

    /**
     * Invokes the invoke operation.
     * <p>
     * Invokes an operation on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. The return object is an aggregation of return values and/or exceptions wrapped in a <a href="../../common/runtime/ICollectiveOpStatus.html">ICollectiveOpStatus</a>. Returns null if asynchronous execution is requested.
     * <p>
     * Impact: ACTION/INFO
     *
     * @param configID The path to the component collection configuration (either storage or logical).
     * @param operationName The name of the operation to invoke on each of the containers/components in the collection.
     * @param operationParams The parameters to the operation.
     * @param operationSignature The signature of the operation.
     * @param sync If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result.
     * @param timeout The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.
     */
    public java.lang.Object invoke(java.lang.String configID, java.lang.String operationName, java.lang.Object[] operationParams, java.lang.String[] operationSignature, java.lang.Boolean sync, java.lang.Long timeout);

    /**
     * Invokes the reload operation.
     * <p>
     * Asynchronously reload the component and restart the component if it was previously online.
     * <p>
     * Impact: ACTION
     */
    public void reload();

    /**
     * Invokes the resetMetrics operation.
     * <p>
     * Reset all metrics to their initial state.
     * <p>
     * Impact: ACTION
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     */
    public void resetMetrics();

    /**
     * Invokes the saveLogFile operation.
     * <p>
     * Saves the contents of the centralized log file to the given file name.
     * <p>
     * Impact: ACTION
     *
     * @param filename A valid filename (including path) to save the centralized log file to.
     */
    public void saveLogFile(java.lang.String filename);

    /**
     * Invokes the setAttribute operation.
     * <p>
     * Sets an attribute on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. Returns null if asynchronous execution is requested.
     * <p>
     * Impact: ACTION
     *
     * @param configID The path to the component collection configuration (either storage or logical).
     * @param attributeName The name of the attribute.
     * @param attributeValue The value of the attribute.
     * @param sync If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result.
     * @param timeout The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.
     */
    public com.sonicsw.mf.common.runtime.ICollectiveOpStatus setAttribute(java.lang.String configID, java.lang.String attributeName, java.lang.Object attributeValue, java.lang.Boolean sync, java.lang.Long timeout);

    /**
     * Invokes the setAttributes operation.
     * <p>
     * Sets attributes on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. Returns null if asynchronous execution is requested.
     * <p>
     * Impact: ACTION
     *
     * @param configID The path to the component collection configuration (either storage or logical).
     * @param attributeNames The names of the attributes.
     * @param attributeValues The values of the attributes.
     * @param sync If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result.
     * @param timeout The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.
     */
    public com.sonicsw.mf.common.runtime.ICollectiveOpStatus setAttributes(java.lang.String configID, java.lang.String[] attributeNames, java.lang.Object[] attributeValues, java.lang.Boolean sync, java.lang.Long timeout);

    /**
     * Invokes the start operation.
     * <p>
     * Start providing service.
     * <p>
     * Impact: ACTION
     * @see #stop()
     */
    public void start();

    /**
     * Invokes the stop operation.
     * <p>
     * Stop providing service.
     * <p>
     * Impact: ACTION
     * @see #start()
     */
    public void stop();

    /**
     * Invokes the suspendActiveRole operation.
     * <p>
     * Relinquish the current active role to the the standby. For an active AM, this operation attempts to relinquish the active role to the current standby. The active AM will wait up to the given number of seconds for a standby to takeover the active role; if a standby does not takeover the active role in this period, the AM will continue its active role.
     * <p>
     * Impact: ACTION
     *
     * @param seconds The minimum time the active role will be suspended.
     */
    public void suspendActiveRole(java.lang.Integer seconds);

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * An AgentManager component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.alert.system.pollthreads.CurrentPoolSize"><code>system.alert.system.pollthreads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.alert.system.pollthreads.PoolWaits"><code>system.alert.system.pollthreads.PoolWaits</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.log.Failure"><code>system.log.Failure</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.log.Threshold"><code>system.log.Threshold</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Startup"><code>system.state.Startup</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentManagerNotifications.html#system.state.Unreachable"><code>system.state.Unreachable</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
