// This file has been generated for component class com.sonicsw.mf.framework.agent.Agent (105)
// Copyright (c) 2002-2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of an Agent.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createAgentProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/AgentNotifications.html">Agent Notifications</a>,
 *     <a href="../../../../../../mgmt_monitoring/AgentMetrics.html">Agent Metrics</a>
 *   </dd>
 * </dl>
 */
public interface IAgentProxy
{
    //
    // Useful constants
    //

    /**
     * The well known component identity for this component.
     */
    public static final String ID = "AGENT";

    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification system.alert.system.memory.CurrentUsage.
     * <p>
     * Description: Alert for metric system.memory.CurrentUsage
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.memory.CurrentUsage"><code>system.alert.system.memory.CurrentUsage</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_MEMORY_CURRENTUSAGE_NOTIFICATION_ID = "system.alert.system.memory.CurrentUsage";

    /**
     * Notification type constant for the notification system.alert.system.notifications.AwaitingDispatch.
     * <p>
     * Description: Alert for metric system.notifications.AwaitingDispatch
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ANotifications.html#system.alert.system.notifications.AwaitingDispatch"><code>system.alert.system.notifications.AwaitingDispatch</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_NOTIFICATION_ID = "system.alert.system.notifications.AwaitingDispatch";

    /**
     * Notification type constant for the notification system.alert.system.threads.CurrentPoolSize.
     * <p>
     * Description: Alert for metric system.threads.CurrentPoolSize
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ANotifications.html#system.alert.system.threads.CurrentPoolSize"><code>system.alert.system.threads.CurrentPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_THREADS_CURRENTPOOLSIZE_NOTIFICATION_ID = "system.alert.system.threads.CurrentPoolSize";

    /**
     * Notification type constant for the notification system.alert.system.threads.CurrentTotal.
     * <p>
     * Description: Alert for metric system.threads.CurrentTotal
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ANotifications.html#system.alert.system.threads.CurrentTotal"><code>system.alert.system.threads.CurrentTotal</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_THREADS_CURRENTTOTAL_NOTIFICATION_ID = "system.alert.system.threads.CurrentTotal";

    /**
     * Notification type constant for the notification system.alert.system.threads.PoolWaits.
     * <p>
     * Description: Alert for metric system.threads.PoolWaits
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/ANotifications.html#system.alert.system.threads.PoolWaits"><code>system.alert.system.threads.PoolWaits</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_ALERT_SYSTEM_THREADS_POOLWAITS_NOTIFICATION_ID = "system.alert.system.threads.PoolWaits";

    /**
     * Notification type constant for the notification system.log.Failure.
     * <p>
     * Description: Failure to write to the container log file.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.Failure"><code>system.log.Failure</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_LOG_FAILURE_NOTIFICATION_ID = "system.log.Failure";

    /**
     * Notification type constant for the notification system.log.LogMessage.
     * <p>
     * Description: Message has been logged to the container log. Note: The following will not generate this notification: initial container startup messages, final container shutdown messages, trace messages.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.LogMessage"><code>system.log.LogMessage</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_LOG_LOGMESSAGE_NOTIFICATION_ID = "system.log.LogMessage";

    /**
     * Notification type constant for the notification system.log.Threshold.
     * <p>
     * Description: The size of the current container log has reached or exceeded (by a 10% increment) the configured threshold.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.Threshold"><code>system.log.Threshold</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_LOG_THRESHOLD_NOTIFICATION_ID = "system.log.Threshold";

    /**
     * Notification type constant for the notification system.security.ManagePermissionDenied.
     * <p>
     * Description: User has been denied permission to perform a management task.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.security.ManagePermissionDenied"><code>system.security.ManagePermissionDenied</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_SECURITY_MANAGEPERMISSIONDENIED_NOTIFICATION_ID = "system.security.ManagePermissionDenied";

    /**
     * Notification type constant for the notification system.state.ContainerState.
     * <p>
     * Description: Update of container state
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.ContainerState"><code>system.state.ContainerState</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_CONTAINERSTATE_NOTIFICATION_ID = "system.state.ContainerState";

    /**
     * Notification type constant for the notification system.state.Failover.
     * <p>
     * Description: Standby container has failed over to become the active container.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_FAILOVER_NOTIFICATION_ID = "system.state.Failover";

    /**
     * Notification type constant for the notification system.state.Load.
     * <p>
     * Description: Component load completed.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Load"><code>system.state.Load</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_LOAD_NOTIFICATION_ID = "system.state.Load";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    /**
     * Notification type constant for the notification system.state.Shutdown.
     * <p>
     * Description: Agent/Container shutdown initiated.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Shutdown"><code>system.state.Shutdown</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_SHUTDOWN_NOTIFICATION_ID = "system.state.Shutdown";

    /**
     * Notification type constant for the notification system.state.Unload.
     * <p>
     * Description: Component unload completed.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Unload"><code>system.state.Unload</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_UNLOAD_NOTIFICATION_ID = "system.state.Unload";

    //
    // Metric indentity constants
    //

    /**
     * Metric identity constant for the metric system.memory.CurrentUsage.
     * <p>
     * Description: Heap space used by the container and its hosted components.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.CurrentUsage"><code>system.memory.CurrentUsage</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "memory",
        "CurrentUsage"
    });

    /**
     * Metric identity constant for the metric system.memory.MaxUsage.
     * <p>
     * Description: Maximum heap space used by the container and its hosted components since last metrics reset.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.MaxUsage"><code>system.memory.MaxUsage</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_MEMORY_MAXUSAGE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "memory",
        "MaxUsage"
    });

    /**
     * Metric identity constant for the metric system.notifications.AwaitingDispatch.
     * <p>
     * Description: The number of management notifications awaiting dispatch.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.AwaitingDispatch"><code>system.notifications.AwaitingDispatch</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "notifications",
        "AwaitingDispatch"
    });

    /**
     * Metric identity constant for the metric system.notifications.Dropped.
     * <p>
     * Description: Number of times a management notification was dropped before dispatch to listeners. Evaluated over the last 30 minutes.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.Dropped"><code>system.notifications.Dropped</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "notifications",
        "Dropped"
    });

    /**
     * Metric identity constant for the metric system.notifications.MaxAwaitingDispatch.
     * <p>
     * Description: The maximum number of management notifications awaiting dispatch since last metrics reset.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.MaxAwaitingDispatch"><code>system.notifications.MaxAwaitingDispatch</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "notifications",
        "MaxAwaitingDispatch"
    });

    /**
     * Metric identity constant for the metric system.threads.CurrentPoolSize.
     * <p>
     * Description: Size of thread pool used to service transient management tasks.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentPoolSize"><code>system.threads.CurrentPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "threads",
        "CurrentPoolSize"
    });

    /**
     * Metric identity constant for the metric system.threads.CurrentTotal.
     * <p>
     * Description: Total number of threads used by the container and its hosted components.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentTotal"><code>system.threads.CurrentTotal</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "threads",
        "CurrentTotal"
    });

    /**
     * Metric identity constant for the metric system.threads.MaxPoolSize.
     * <p>
     * Description: Maximum size of thread pool used to service transient management tasks since last metrics reset.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.MaxPoolSize"><code>system.threads.MaxPoolSize</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "threads",
        "MaxPoolSize"
    });

    /**
     * Metric identity constant for the metric system.threads.PoolWaits.
     * <p>
     * Description: Number of times transient management tasks had to wait because a pooled thread was not immediately available to service such tasks. Evaluated over the last 30 minutes.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.PoolWaits"><code>system.threads.PoolWaits</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity SYSTEM_THREADS_POOLWAITS_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "system",
        "threads",
        "PoolWaits"
    });

    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of an Agent component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by an Agent are:
     * <ul>
     * <li><a href="#getAllowFailover()"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getCommandLine()"><code>CommandLine</code></a> (java.lang.Boolean)
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getFaultToleranceRole()"><code>FaultToleranceRole</code></a> (java.lang.String)
     * <li><a href="#getFaultTolerantState()"><code>FaultTolerantState</code></a> (java.lang.Short)
     * <li><a href="#getFaultTolerantStateString()"><code>FaultTolerantStateString</code></a> (java.lang.String)
     * <li><a href="#getHostname()"><code>Hostname</code></a> (java.lang.String)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getLogFile()"><code>LogFile</code></a> (java.lang.String)
     * <li><a href="#getLogFileRolloverSizeThreshold()"><code>LogFileRolloverSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#getLogFileRolloverTimeInterval()"><code>LogFileRolloverTimeInterval</code></a> (java.lang.Integer)
     * <li><a href="#getLogFileSize()"><code>LogFileSize</code></a> (java.lang.Long)
     * <li><a href="#getLogFileSizeThreshold()"><code>LogFileSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#getLogToConsole()"><code>LogToConsole</code></a> (java.lang.Boolean)
     * <li><a href="#getLogToFile()"><code>LogToFile</code></a> (java.lang.Boolean)
     * <li><a href="#getMaxThreads()"><code>MaxThreads</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsCollectionInterval()"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsRefreshInterval()"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMinThreads()"><code>MinThreads</code></a> (java.lang.Integer)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getRepeatMetricAlerts()"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(javax.management.AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of an Agent component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by an Agent are:
     * <ul>
     * <li><a href="#setAllowFailover(java.lang.Boolean)"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#setCommandLine(java.lang.Boolean)"><code>CommandLine</code></a> (java.lang.Boolean)
     * <li><a href="#setLogFile(java.lang.String)"><code>LogFile</code></a> (java.lang.String)
     * <li><a href="#setLogFileRolloverSizeThreshold(java.lang.Long)"><code>LogFileRolloverSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#setLogFileRolloverTimeInterval(java.lang.Integer)"><code>LogFileRolloverTimeInterval</code></a> (java.lang.Integer)
     * <li><a href="#setLogFileSizeThreshold(java.lang.Long)"><code>LogFileSizeThreshold</code></a> (java.lang.Long)
     * <li><a href="#setLogToConsole(java.lang.Boolean)"><code>LogToConsole</code></a> (java.lang.Boolean)
     * <li><a href="#setLogToFile(java.lang.Boolean)"><code>LogToFile</code></a> (java.lang.Boolean)
     * <li><a href="#setMetricsCollectionInterval(java.lang.Integer)"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsRefreshInterval(java.lang.Integer)"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#setRepeatMetricAlerts(java.lang.Boolean)"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(java.lang.String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the AllowFailover attribute.
     *
     * @return When this container is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #setAllowFailover(java.lang.Boolean)
     */
    public java.lang.Boolean getAllowFailover();

    /**
     * Sets the value of the AllowFailover attribute.
     *
     * @param value When this container is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #getAllowFailover()
     */
    public void setAllowFailover(java.lang.Boolean value);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the CommandLine attribute.
     *
     * @return Flag indicating if a local command line interface is enabled.
     *
     * @see #setCommandLine(java.lang.Boolean)
     */
    public java.lang.Boolean getCommandLine();

    /**
     * Sets the value of the CommandLine attribute.
     *
     * @param value Flag indicating if a local command line interface is enabled.
     *
     * @see #getCommandLine()
     */
    public void setCommandLine(java.lang.Boolean value);

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the FaultToleranceRole attribute.
     *
     * @return The fault tolerant role of the container (primary or backup) or null if not fault tolerant.
     */
    public java.lang.String getFaultToleranceRole();

    /**
     * Gets the value of the FaultTolerantState attribute.
     *
     * @return The current fault tolerant state of this container.
     */
    public java.lang.Short getFaultTolerantState();

    /**
     * Gets the value of the FaultTolerantStateString attribute.
     *
     * @return The description of the current fault tolerant state of this container.
     */
    public java.lang.String getFaultTolerantStateString();

    /**
     * Gets the value of the Hostname attribute.
     *
     * @return The hostname for the container host machine.
     */
    public java.lang.String getHostname();

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the LogFile attribute.
     *
     * @return The directory pathname of the container log file. Defaults to {<domain>.<container>.log} in the container's working directory.
     *
     * @see #setLogFile(java.lang.String)
     */
    public java.lang.String getLogFile();

    /**
     * Sets the value of the LogFile attribute.
     *
     * @param value The directory pathname of the container log file. Defaults to {<domain>.<container>.log} in the container's working directory.
     *
     * @see #getLogFile()
     */
    public void setLogFile(java.lang.String value);

    /**
     * Gets the value of the LogFileRolloverSizeThreshold attribute.
     *
     * @return If the current log file size equals or exceeds this threshold at midnight, then the container will roll over the old contents to an archive file and create a new empty container log file.
     *
     * @see #setLogFileRolloverSizeThreshold(java.lang.Long)
     */
    public java.lang.Long getLogFileRolloverSizeThreshold();

    /**
     * Sets the value of the LogFileRolloverSizeThreshold attribute.
     *
     * @param value If the current log file size equals or exceeds this threshold at midnight, then the container will roll over the old contents to an archive file and create a new empty container log file.
     *
     * @see #getLogFileRolloverSizeThreshold()
     */
    public void setLogFileRolloverSizeThreshold(java.lang.Long value);


    /**
     * Gets the value of the LogFileRolloverTimeInterval attribute in minutes.
     *
     * @return This log file rollover time interval attribute is used to configure the next schedule time in minutes for the log file rollover to happen.
     *
     * @see #setLogFileRolloverTimeInterval(java.lang.Integer)
     */
    public java.lang.Integer getLogFileRolloverTimeInterval();

    /**
     * Sets the value of the LogFileRolloverTimeInterval attribute in minutes.
     *
     * @param value This log file rollover time interval attribute is used to configure the next schedule time in minutes for the log file rollover to happen.
     *
     * @see #getLogFileRolloverTimeInterval()
     */
    public void setLogFileRolloverTimeInterval(java.lang.Integer minutes);

    /**
     * Gets the value of the LogFileSize attribute.
     *
     * @return The number of bytes written to the container log file. This value gets reset to 0 when the log is cleared or archived.
     */
    public java.lang.Long getLogFileSize();

    /**
     * Gets the value of the LogFileSizeThreshold attribute.
     *
     * @return Once the size of the container log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent will send a warning notification.
     *
     * @see #setLogFileSizeThreshold(java.lang.Long)
     */
    public java.lang.Long getLogFileSizeThreshold();

    /**
     * Sets the value of the LogFileSizeThreshold attribute.
     *
     * @param value Once the size of the container log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent will send a warning notification.
     *
     * @see #getLogFileSizeThreshold()
     */
    public void setLogFileSizeThreshold(java.lang.Long value);

    /**
     * Gets the value of the LogToConsole attribute.
     *
     * @return Flag indicating if messages logged via the framework should be sent to the container console.
     *
     * @see #setLogToConsole(java.lang.Boolean)
     */
    public java.lang.Boolean getLogToConsole();

    /**
     * Sets the value of the LogToConsole attribute.
     *
     * @param value Flag indicating if messages logged via the framework should be sent to the container console.
     *
     * @see #getLogToConsole()
     */
    public void setLogToConsole(java.lang.Boolean value);

    /**
     * Gets the value of the LogToFile attribute.
     *
     * @return Flag indicating if messages logged via the framework should be sent to the log file.
     *
     * @see #setLogToFile(java.lang.Boolean)
     */
    public java.lang.Boolean getLogToFile();

    /**
     * Sets the value of the LogToFile attribute.
     *
     * @param value Flag indicating if messages logged via the framework should be sent to the log file.
     *
     * @see #getLogToFile()
     */
    public void setLogToFile(java.lang.Boolean value);

    /**
     * Gets the value of the MaxThreads attribute.
     *
     * @return The maximum number of threads that the container can create to service transient management tasks.
     */
    public java.lang.Integer getMaxThreads();

    /**
     * Gets the value of the MetricsCollectionInterval attribute.
     *
     * @return Metrics collection interval (in minutes)
     *
     * @see #setMetricsCollectionInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsCollectionInterval();

    /**
     * Sets the value of the MetricsCollectionInterval attribute.
     *
     * @param value Metrics collection interval (in minutes)
     *
     * @see #getMetricsCollectionInterval()
     */
    public void setMetricsCollectionInterval(java.lang.Integer value);

    /**
     * Gets the value of the MetricsRefreshInterval attribute.
     *
     * @return Metrics refresh interval (in seconds)
     *
     * @see #setMetricsRefreshInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsRefreshInterval();

    /**
     * Sets the value of the MetricsRefreshInterval attribute.
     *
     * @param value Metrics refresh interval (in seconds)
     *
     * @see #getMetricsRefreshInterval()
     */
    public void setMetricsRefreshInterval(java.lang.Integer value);

    /**
     * Gets the value of the MinThreads attribute.
     *
     * @return The minimum number of threads that the container will cache for reuse to service transient management tasks.
     */
    public java.lang.Integer getMinThreads();

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the RepeatMetricAlerts attribute.
     *
     * @return Repeat metric alert notifications.
     *
     * @see #setRepeatMetricAlerts(java.lang.Boolean)
     */
    public java.lang.Boolean getRepeatMetricAlerts();

    /**
     * Sets the value of the RepeatMetricAlerts attribute.
     *
     * @param value Repeat metric alert notifications.
     *
     * @see #getRepeatMetricAlerts()
     */
    public void setRepeatMetricAlerts(java.lang.Boolean value);

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - request/reply
     * <li>32 - request/reply failures
     * <li>64 - connection failures
     * <li>128 - connection state changes
     * <li>256 - notification subscription expirations
     * <li>512 - configuration cache
     * <li>1024 - class loading failures
     * <li>2048 - container FT
     * <li>4096 - container launch
     * <li>8192 - permission denied
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - request/reply
     * <li>32 - request/reply failures
     * <li>64 - connection failures
     * <li>128 - connection state changes
     * <li>256 - notification subscription expirations
     * <li>512 - configuration cache
     * <li>1024 - class loading failures
     * <li>2048 - container FT
     * <li>4096 - container launch
     * <li>8192 - permission denied
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the clearLogFile operation.
     * <p>
     * Clear the log file.
     * <p>
     * Impact: ACTION
     */
    public void clearLogFile();

    /**
     * Invokes the diagnose operation.
     * <p>
     * Execute diagnostics instructions
     * <p>
     * Impact: INFO
     *
     * @param instructions One or more diagnostic instructions - an instruction per line
     */
    public java.lang.String diagnose(java.lang.String instructions);

    /**
     * Invokes the disableAlerts operation.
     * <p>
     * Disable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.CurrentUsage"><code>system.memory.CurrentUsage</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to disable.
     *
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void disableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the disableMetrics operation.
     * <p>
     * Disable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.CurrentUsage"><code>system.memory.CurrentUsage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.MaxUsage"><code>system.memory.MaxUsage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.AwaitingDispatch"><code>system.notifications.AwaitingDispatch</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.Dropped"><code>system.notifications.Dropped</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.MaxAwaitingDispatch"><code>system.notifications.MaxAwaitingDispatch</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentPoolSize"><code>system.threads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentTotal"><code>system.threads.CurrentTotal</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.MaxPoolSize"><code>system.threads.MaxPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.PoolWaits"><code>system.threads.PoolWaits</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the enableAlerts operation.
     * <p>
     * Enable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.CurrentUsage"><code>system.memory.CurrentUsage</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to enable.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void enableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the enableMetrics operation.
     * <p>
     * Enable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.CurrentUsage"><code>system.memory.CurrentUsage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.memory.MaxUsage"><code>system.memory.MaxUsage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.AwaitingDispatch"><code>system.notifications.AwaitingDispatch</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.Dropped"><code>system.notifications.Dropped</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.notifications.MaxAwaitingDispatch"><code>system.notifications.MaxAwaitingDispatch</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentPoolSize"><code>system.threads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.CurrentTotal"><code>system.threads.CurrentTotal</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.MaxPoolSize"><code>system.threads.MaxPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentMetrics.html#system.threads.PoolWaits"><code>system.threads.PoolWaits</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getActiveMetrics operation.
     * <p>
     * Gets the the list of metrics currently active in this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getContainerState operation.
     * <p>
     * Gets the execution state of the container and its hosted components.
     * <p>
     * Impact: INFO
     */
    public com.sonicsw.mf.common.runtime.IContainerState getContainerState();

    /**
     * Invokes the getEnabledAlerts operation.
     * <p>
     * Get all metric threshold alerts enabled by this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     */
    public com.sonicsw.mf.common.metrics.IAlert[] getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getEnabledMetrics operation.
     * <p>
     * Get the list of metric patterns that have been enabled for this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getLogExtract operation.
     * <p>
     * Reads the requested bytes from the log file and returns them as a String.
     * <p>
     * Impact: INFO
     *
     * @param fromPosition The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions.
     * @param readLength The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.
     */
    public java.lang.String getLogExtract(java.lang.Long fromPosition, java.lang.Long readLength);

    /**
     * Invokes the getLogExtractAndLogFileSize operation.
     * <p>
     * Reads the requested bytes from the log file and returns them as a String encapsulated with the current log size. The current log size is the size of the current log file plus the sum of all available prior versions. When evaluating log output to be read, the current log file and previous versions (due to rollover activity) will be effectively viewed as a single file.
     * <p>
     * Impact: INFO
     *
     * @param fromPosition The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions.
     * @param readLength The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.
     */
    public javax.management.openmbean.CompositeData getLogExtractAndLogFileSize(java.lang.Long fromPosition, java.lang.Long readLength);

    /**
     * Invokes the getMetricsData operation.
     * <p>
     * Gets metric values for a given set of metrics. If a requested metric was not enabled or is otherwise unknown, then no data for that metric will be included in the results.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of active metrics, either individual metrics or instances.
     * @param returnTriggeredAlerts If true, each metric returned should include a list of triggered (exceeded) alerts for these metrics.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricsData getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids, java.lang.Boolean returnTriggeredAlerts);

    /**
     * Invokes the getMetricsInfo operation.
     * <p>
     * Gets the meta-data for all metrics supported by this component.
     * <p>
     * Impact: INFO
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricInfo[] getMetricsInfo();

    /**
     * Invokes the ping operation.
     * <p>
     * Checks the container for accessibility. Returns the given string.
     * <p>
     * Impact: INFO
     *
     * @param pingMessage Any string.
     */
    public java.lang.String ping(java.lang.String pingMessage);

    /**
     * Invokes the reloadComponent operation.
     * <p>
     * Asynchronously reload the given component ID.
     * <p>
     * Impact: ACTION
     *
     * @param id The runtime identity of the component within the container to be reloaded.
     */
    public void reloadComponent(java.lang.String id);

    /**
     * Invokes the resetMetrics operation.
     * <p>
     * Reset all metrics to their initial state.
     * <p>
     * Impact: ACTION
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     */
    public void resetMetrics();

    /**
     * Invokes the restart operation.
     * <p>
     * Restart the Agent/Container (requires support from parent shell/process).
     * <p>
     * Impact: ACTION
     */
    public void restart();

    /**
     * Invokes the cleanRestart operation.
     * <p>
     * Restart the Agent/Container after deleting all the files in the working directory of the container (other than scripts, container.ini and the log) (requires support from parent shell/process).
     * <p>
     * Impact: ACTION
     */
    public void cleanRestart();

    /**
     * Invokes the saveLogFile operation.
     * <p>
     * Saves the contents of the log file to the given file name.
     * <p>
     * Impact: ACTION
     *
     * @param filename A valid filename (including path) to save the log file to.
     */
    public void saveLogFile(java.lang.String filename);

    /**
     * Invokes the shutdown operation.
     * <p>
     * Shutdown the Agent/Container.
     * <p>
     * Impact: ACTION
     */
    public void shutdown();

    /**
     * Invokes the suspendActiveRole operation.
     * <p>
     * Relinquish the current active role to the the standby. For an active container, this operation attempts to relinquish the active role to the current standby. The active container will wait up to the given number of seconds for a standby to takeover the active role; if a standby does not takeover the active role in this period, the container will continue its active role.
     * <p>
     * Impact: ACTION
     *
     * @param seconds The minimum time the active role will be suspended.
     */
    public void suspendActiveRole(java.lang.Integer seconds);

    /**
     * Invokes the getJVMProperties operation.
     * <p>
     * Returns the JVM's system properties.
     * <p>
     * Impact: INFO
     *
     * @return the JVM's system properties.
     */
    public java.util.Properties getJVMProperties();

    /**
     * Invokes the downloadArchives operation.
     * <p>
     * Makes sure all the latest versions of archives used by components of this container are cached in the container's cache.
     * <p>
     * Impact: ACTION
     *
     */
    public void downloadArchives();

    /**
     * Invokes the downloadArchives operation.
     * <p>
     * Makes sure all the latest versions of archives used by components of this container are cached in the container's cache.
     * <p>
     * Impact: ACTION
     *
     * @param archivesRootDSpath The Directory Service path of the root of the archives - the "sonicfs://" prefix can be omitted. Example: "/Archives".
     * @param archivesVersion The version of the archive(s). Example: "8.0".
     */
    public void downloadArchives(String archivesRootDSpath, String archivesVersion);

    /**
     * Invokes the downloadFile operation.
     * <p>
     * Makes sure the latest version of the specified Directory Service file is cached in the container's cache.
     * <p>
     * Impact: ACTION
     *
     * @param dsFilePath The Directory Service path of the file.
     */
    public void downloadFile(String dsFilePath);

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * An Agent component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.memory.CurrentUsage"><code>system.alert.system.memory.CurrentUsage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.notifications.AwaitingDispatch"><code>system.alert.system.notifications.AwaitingDispatch</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.threads.CurrentPoolSize"><code>system.alert.system.threads.CurrentPoolSize</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.threads.CurrentTotal"><code>system.alert.system.threads.CurrentTotal</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.alert.system.threads.PoolWaits"><code>system.alert.system.threads.PoolWaits</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.Failure"><code>system.log.Failure</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.LogMessage"><code>system.log.LogMessage</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.log.Threshold"><code>system.log.Threshold</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.security.ManagePermissionDenied"><code>system.security.ManagePermissionDenied</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.ContainerState"><code>system.state.ContainerState</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Load"><code>system.state.Load</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Shutdown"><code>system.state.Shutdown</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/AgentNotifications.html#system.state.Unload"><code>system.state.Unload</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
