// This file has been generated for component class com.sonicsw.mf.framework.monitor.CollectionsMonitor (105)
// Copyright (c) 2002-2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of a CollectionsMonitor.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createCollectionsMonitorProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html">CollectionsMonitor Notifications</a>,
 *     <a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html">CollectionsMonitor Metrics</a>
 *   </dd>
 * </dl>
 */
public interface ICollectionsMonitorProxy
{
    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification application.alert.storage.metrics.StoredPerMinute.
     * <p>
     * Description: Alert for metric storage.metrics.StoredPerMinute
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.storage.metrics.StoredPerMinute"><code>application.alert.storage.metrics.StoredPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_STORAGE_METRICS_STOREDPERMINUTE_NOTIFICATION_ID = "application.alert.storage.metrics.StoredPerMinute";

    /**
     * Notification type constant for the notification application.alert.storage.notifications.StoredPerMinute.
     * <p>
     * Description: Alert for metric storage.notifications.StoredPerMinute
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.storage.notifications.StoredPerMinute"><code>application.alert.storage.notifications.StoredPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_STORAGE_NOTIFICATIONS_STOREDPERMINUTE_NOTIFICATION_ID = "application.alert.storage.notifications.StoredPerMinute";

    /**
     * Notification type constant for the notification application.alert.monitor.metrics.AverageMetricLatency.
     * <p>
     * Description: Alert for metric monitor.metrics.AverageMetricLatency
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.monitor.metrics.AverageMetricLatency"><code>application.alert.monitor.metrics.AverageMetricLatency</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_MONITOR_NOTIFICATIONS_AVERAGEMETRICLATENCY_NOTIFICATION_ID = "application.alert.storage.notifications.AverageMetricLatency";

    /**
     * Notification type constant for the notification application.alert.monitor.metrics.MaxMetricLatency.
     * <p>
     * Description: Alert for metric monitor.metrics.MaxMetricLatency
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.monitor.metrics.MaxMetricLatency"><code>application.alert.monitor.metrics.MaxMetricLatency</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_MONITOR_NOTIFICATIONS_MAXMETRICLATENCY_NOTIFICATION_ID = "application.alert.storage.notifications.MaxMetricLatency";

    /**
     * Notification type constant for the notification application.alert.monitor.metrics.MetricsPerSecond.
     * <p>
     * Description: Alert for metric monitor.metrics.MetricsPerSecond
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.monitor.metrics.MetricsPerSecond"><code>application.alert.monitor.metrics.MetricsPerSecond</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_MONITOR_NOTIFICATIONS_METRICSPERSECOND_NOTIFICATION_ID = "application.alert.storage.notifications.MetricsPerSecond";

    /**
     * Notification type constant for the notification application.alert.monitor.notification.NotificationsPerSecond.
     * <p>
     * Description: Alert for metric monitor.notification.NotificationsPerSecond
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.monitor.notification.NotificationsPerSecond"><code>application.alert.monitor.notification.NotificationsPerSecond</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_MONITOR_NOTIFICATIONS_NOTIFICATIONSPERSECOND_NOTIFICATION_ID = "application.alert.storage.notifications.MetricsPerSecond";

    /**
     * Notification type constant for the notification system.monitor.Threshold.
     * <p>
     * Description: Sent when a notification monitoring threshold has been broken.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.monitor.Threshold"><code>system.monitor.Threshold</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_MONITOR_THRESHOLD_NOTIFICATION_ID = "system.monitor.Threshold";

    /**
     * Notification type constant for the notification system.state.Offline.
     * <p>
     * Description: Component stop complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_OFFLINE_NOTIFICATION_ID = "system.state.Offline";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    //
    // Metric indentity constants
    //

    /**
     * Metric identity constant for the metric storage.metrics.StoredPerMinute.
     * <p>
     * Description: Number of monitored metric values stored per minute.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.metrics.StoredPerMinute"><code>storage.metrics.StoredPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "storage",
        "metrics",
        "StoredPerMinute"
    });

    /**
     * Metric identity constant for the metric storage.notifications.StoredPerMinute.
     * <p>
     * Description: Number of monitored notifications stored per minute.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.notifications.StoredPerMinute"><code>storage.notifications.StoredPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "storage",
        "notifications",
        "StoredPerMinute"
    });

    /**
     * Metric identity constant for the metric monitor.metrics.AverageMetricLatency.
     * <p>
     * Description: Average latency(time since metric origination) of collected metrics in milliseconds.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#monitor.metrics.AverageMetricLatency"><code>monitor.metrics.AverageMetricLatency</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "monitor",
        "metrics",
        "AverageMetricLatency"
    }); 
    
    /**
     * Metric identity constant for the metric monitor.metrics.MaxMetricLatency.
     * <p>
     * Description: Maximum latency(time since metric origination) of collected metrics in milliseconds.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#monitor.metrics.MaxMetricLatency"><code>monitor.metrics.MaxMetricLatency</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "monitor",
        "metrics",
        "MaxMetricLatency"
    });
    
    /**
     * Metric identity constant for the metric monitor.metrics.MinMetricLatency.
     * <p>
     * Description: Minimum latency(time since metric origination) of collected metrics in milliseconds.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#monitor.metrics.MinMetricLatency"><code>monitor.metrics.MinMetricLatency</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "monitor",
        "metrics",
        "MinMetricLatency"
    }); 
    

    /**
     * Metric identity constant for the metric monitor.metrics.MetricsPerSecond.
     * <p>
     * Description: Metrics collection rate per second.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#monitor.metrics.MetricsPerSecond"><code>monitor.metrics.MetricsPerSecond</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "monitor",
        "metrics",
        "MetricsPerSecond"
    }); 

    /**
     * Metric identity constant for the metric monitor.notifications.NotificationsPerSecond.
     * <p>
     * Description: Notifications collection rate.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#monitor.notifications.NotificationsPerSecond"><code>monitor.notifications.NotificationsPerSecond</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "monitor",
        "notifications",
        "NotificationsPerSecond"
    }); 
    
     
    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of a CollectionsMonitor component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by a CollectionsMonitor are:
     * <ul>
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getHistoryDurationHours()"><code>HistoryDurationHours</code></a> (java.lang.Integer)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getMetricsCollectionInterval()"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsRefreshInterval()"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getRepeatMetricAlerts()"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#getSaveMonitoredNotifications()"><code>SaveMonitoredNotifications</code></a> (java.lang.Boolean)
     * <li><a href="#getSaveThresholdNotifications()"><code>SaveThresholdNotifications</code></a> (java.lang.Boolean)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(javax.management.AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of a CollectionsMonitor component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by a CollectionsMonitor are:
     * <ul>
     * <li><a href="#setHistoryDurationHours(java.lang.Integer)"><code>HistoryDurationHours</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsCollectionInterval(java.lang.Integer)"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsRefreshInterval(java.lang.Integer)"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#setRepeatMetricAlerts(java.lang.Boolean)"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#setSaveMonitoredNotifications(java.lang.Boolean)"><code>SaveMonitoredNotifications</code></a> (java.lang.Boolean)
     * <li><a href="#setSaveThresholdNotifications(java.lang.Boolean)"><code>SaveThresholdNotifications</code></a> (java.lang.Boolean)
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(java.lang.String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the HistoryDurationHours attribute.
     *
     * @return Duration (hours) for which historical monitoring data will be held.
     *
     * @see #setHistoryDurationHours(java.lang.Integer)
     */
    public java.lang.Integer getHistoryDurationHours();

    /**
     * Sets the value of the HistoryDurationHours attribute.
     *
     * @param value Duration (hours) for which historical monitoring data will be held.
     *
     * @see #getHistoryDurationHours()
     */
    public void setHistoryDurationHours(java.lang.Integer value);

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the MetricsCollectionInterval attribute.
     *
     * @return Metrics collection interval (in minutes)
     *
     * @see #setMetricsCollectionInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsCollectionInterval();

    /**
     * Sets the value of the MetricsCollectionInterval attribute.
     *
     * @param value Metrics collection interval (in minutes)
     *
     * @see #getMetricsCollectionInterval()
     */
    public void setMetricsCollectionInterval(java.lang.Integer value);

    /**
     * Gets the value of the MetricsRefreshInterval attribute.
     *
     * @return Metrics refresh interval (in seconds)
     *
     * @see #setMetricsRefreshInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsRefreshInterval();

    /**
     * Sets the value of the MetricsRefreshInterval attribute.
     *
     * @param value Metrics refresh interval (in seconds)
     *
     * @see #getMetricsRefreshInterval()
     */
    public void setMetricsRefreshInterval(java.lang.Integer value);

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the RepeatMetricAlerts attribute.
     *
     * @return Repeat metric alert notifications
     *
     * @see #setRepeatMetricAlerts(java.lang.Boolean)
     */
    public java.lang.Boolean getRepeatMetricAlerts();

    /**
     * Sets the value of the RepeatMetricAlerts attribute.
     *
     * @param value Repeat metric alert notifications
     *
     * @see #getRepeatMetricAlerts()
     */
    public void setRepeatMetricAlerts(java.lang.Boolean value);

    /**
     * Gets the value of the SaveMonitoredNotifications attribute.
     *
     * @return Flag indicating if a history of monitored notifications should be maintained.
     *
     * @see #setSaveMonitoredNotifications(java.lang.Boolean)
     */
    public java.lang.Boolean getSaveMonitoredNotifications();

    /**
     * Sets the value of the SaveMonitoredNotifications attribute.
     *
     * @param value Flag indicating if a history of monitored notifications should be maintained.
     *
     * @see #getSaveMonitoredNotifications()
     */
    public void setSaveMonitoredNotifications(java.lang.Boolean value);

    /**
     * Gets the value of the SaveThresholdNotifications attribute.
     *
     * @return Flag indicating if a history of threshold notifications should be maintained.
     *
     * @see #setSaveThresholdNotifications(java.lang.Boolean)
     */
    public java.lang.Boolean getSaveThresholdNotifications();

    /**
     * Sets the value of the SaveThresholdNotifications attribute.
     *
     * @param value Flag indicating if a history of threshold notifications should be maintained.
     *
     * @see #getSaveThresholdNotifications()
     */
    public void setSaveThresholdNotifications(java.lang.Boolean value);

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - received notifications
     * <li>32 - forwarded notifications
     * <li>64 - storage failure details
     * <li>128 - metric poll timeouts
     * <li>256 - metric enabling
     * <li>512 - monitoring request failures
     * <li>1024 - storage activity
     * <li>2048 - metric polling
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - received notifications
     * <li>32 - forwarded notifications
     * <li>64 - storage failure details
     * <li>128 - metric poll timeouts
     * <li>256 - metric enabling
     * <li>512 - monitoring request failures
     * <li>1024 - storage activity
     * <li>2048 - metric polling
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the clearHistory operation.
     * <p>
     * Clears all notification/metric history maintained by this monitor.
     * <p>
     * Impact: ACTION
     */
    public void clearHistory();

    /**
     * Invokes the disableAlerts operation.
     * <p>
     * Disable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.metrics.StoredPerMinute"><code>storage.metrics.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.notifications.StoredPerMinute"><code>storage.notifications.StoredPerMinute</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to disable.
     *
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void disableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the disableMetrics operation.
     * <p>
     * Disable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.metrics.StoredPerMinute"><code>storage.metrics.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.notifications.StoredPerMinute"><code>storage.notifications.StoredPerMinute</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public void disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the enableAlerts operation.
     * <p>
     * Enable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.metrics.StoredPerMinute"><code>storage.metrics.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.notifications.StoredPerMinute"><code>storage.notifications.StoredPerMinute</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to enable.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void enableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the enableMetrics operation.
     * <p>
     * Enable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.metrics.StoredPerMinute"><code>storage.metrics.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorMetrics.html#storage.notifications.StoredPerMinute"><code>storage.notifications.StoredPerMinute</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public void enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getActiveMetrics operation.
     * <p>
     * Gets the the list of metrics currently active in this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getAggregateMetricsData operation.
     * <p>
     * Gets aggregated metrics for a collection, based from recorded metrics of the given time window.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     * @param metricIDs The metric identities for which aggregate data is sought.
     * @param latestCurrency The time of the latest metric value to be used to compute the aggregate data..
     * @param lookbackPeriod The period to lookback for metric values.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IAggregateMetricsData getAggregateMetricsData(java.lang.String collectionID, com.sonicsw.mf.common.metrics.IMetricIdentity[] metricIDs, java.lang.Long latestCurrency, java.lang.Long lookbackPeriod);

    /**
     * Invokes the getEnabledAlerts operation.
     * <p>
     * Get all metric threshold alerts enabled by this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     */
    public com.sonicsw.mf.common.metrics.IAlert[] getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getEnabledMetrics operation.
     * <p>
     * Get the list of metric patterns that have been enabled for this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getForwardedNotificationsInfo operation.
     * <p>
     * Gets the meta-data for the notifications being forwarded by this monitor.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     */
    public javax.management.MBeanNotificationInfo[] getForwardedNotificationsInfo(java.lang.String collectionID);

    /**
     * Invokes the getInstanceMetricNames operation.
     * <p>
     * Gets the instance metric names for a monitored metric of a specified collection.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     * @param id The metric identity for which instance names are sought.
     */
    public java.lang.String[] getInstanceMetricNames(java.lang.String collectionID, com.sonicsw.mf.common.metrics.IMetricIdentity id);

    /**
     * Invokes the getMetricHistory operation.
     * <p>
     * Gets recorded metrics for the given collection and metrics, between the given dates. Metrics are returned in date order with most recent first.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     * @param metricIDs The metric identities of interest.
     * @param latest The time of the latest monitored metric value to be returned.
     * @param earliest The time of the earliest monitored metric value to be returned.
     */
    public com.sonicsw.mf.common.metrics.IMetricsData getMetricHistory(java.lang.String collectionID, com.sonicsw.mf.common.metrics.IMetricIdentity[] metricIDs, java.lang.Long latest, java.lang.Long earliest);

    /**
     * Invokes the getMetricsData operation.
     * <p>
     * Gets metric values for a given set of metrics. If a requested metric was not enabled or is otherwise unknown, then no data for that metric will be included in the results.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of active metrics, either individual metrics or instances.
     * @param returnTriggeredAlerts If true, each metric returned should include a list of triggered (exceeded) alerts for these metrics.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricsData getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids, java.lang.Boolean returnTriggeredAlerts);

    /**
     * Invokes the getMetricsInfo operation.
     * <p>
     * Gets the meta-data for all metrics supported by this component.
     * <p>
     * Impact: INFO
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricInfo[] getMetricsInfo();

    /**
     * Invokes the getMonitoredCollections operation.
     * <p>
     * Gets the list of collections being monitored by this monitor.
     * <p>
     * Impact: INFO
     */
    public java.lang.String[] getMonitoredCollections();

    /**
     * Invokes the getMonitoredMetricsInfo operation.
     * <p>
     * Gets the meta-data for the metrics being forwarded by this monitor.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricInfo[] getMonitoredMetricsInfo(java.lang.String collectionID);

    /**
     * Invokes the getNotificationHistory operation.
     * <p>
     * Gets recorded notifications for the given collection and notification types, between the given dates. Notifications are returned in date order with most recent first.
     * <p>
     * Impact: INFO
     *
     * @param collectionID The configuration ID to the monitored collection.
     * @param notificationTypes The (canonical) notification types of interest.
     * @param latest The time of the latest monitored notification to be returned.
     * @param earliest The time of the earliest monitored notification to be returned.
     */
    public com.sonicsw.mf.common.runtime.INotification[] getNotificationHistory(java.lang.String collectionID, java.lang.String[] notificationTypes, java.lang.Long latest, java.lang.Long earliest);

    /**
     * Invokes the getStoredMetrics operation.
     * <p>
     * Returns an instance of IMonitoredMetrics containing copies of the stored metrics for the specified component collection(s), for the given time window, up to a total size of approximately 1Mb, and a flag to indicate if there are more metrics to be retrieved.
     * <p>
     * Impact: INFO
     *
     * @param collectionIDs The configuration ID(s) of the monitored collection(s).
     * @param lastReceivedTimestamp The timestamp of the last retrieved metric, or the timr of the last retrieval attempt.
     * @param lookbackPeriod The period to look back for metric values.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.runtime.IMonitoredMetrics getStoredMetrics(java.lang.String[] collectionIDs, java.lang.Long lastReceivedTimestamp, java.lang.Long lookbackPeriod);

    /**
     * Invokes the getStoredNotifications operation.
     * <p>
     * Returns an instance of IMonitoredNotifications containing copies of the stored notifications for a collection, for the given time window, up to a total size of approximately 1Mb, and a flag to indicate if there are more notifications to be retrieved.
     * <p>
     * Impact: INFO
     *
     * @param collectionIDs The configuration ID(s) of the monitored collection(s).
     * @param lastReceivedTimestamp The timestamp of the last retrieved notification, or the time of the last retrieval attempt.
     * @param lookbackPeriod The period to look back for notification values.
     */
    public com.sonicsw.mf.common.runtime.IMonitoredNotifications getStoredNotifications(java.lang.String[] collectionIDs, java.lang.Long lastReceivedTimestamp, java.lang.Long lookbackPeriod);

    /**
     * Invokes the getThresholdNotificationHistory operation.
     * <p>
     * Gets recorded notifications for the given collection and notification types, between the given dates. Notifications are returned in date order with most recent first.
     * <p>
     * Impact: INFO
     *
     * @param latest The time of the latest threshold notification to be returned.
     * @param earliest The time of the earliest threshold notification to be returned.
     */
    public com.sonicsw.mf.common.runtime.INotification[] getThresholdNotificationHistory(java.lang.Long latest, java.lang.Long earliest);

    /**
     * Invokes the reload operation.
     * <p>
     * Asynchronously reload the component and restart the component if it was previously online.
     * <p>
     * Impact: ACTION
     */
    public void reload();

    /**
     * Invokes the resetMetrics operation.
     * <p>
     * Reset all metrics to their initial state.
     * <p>
     * Impact: ACTION
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getAggregateMetricsData(java.lang.String, com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Long, java.lang.Long)
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #getMonitoredMetricsInfo(java.lang.String)
     * @see #getStoredMetrics(java.lang.String[], java.lang.Long, java.lang.Long)
     */
    public void resetMetrics();

    /**
     * Invokes the start operation.
     * <p>
     * Start providing service.
     * <p>
     * Impact: ACTION
     * @see #stop()
     */
    public void start();

    /**
     * Invokes the stop operation.
     * <p>
     * Stop providing service.
     * <p>
     * Impact: ACTION
     * @see #start()
     */
    public void stop();

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * A CollectionsMonitor component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.storage.metrics.StoredPerMinute"><code>application.alert.storage.metrics.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#application.alert.storage.notifications.StoredPerMinute"><code>application.alert.storage.notifications.StoredPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.monitor.Threshold"><code>system.monitor.Threshold</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/CollectionsMonitorNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
